# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### IDPPOCDecider <a name="IDPPOCDecider" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer"></a>

```typescript
import { IDPPOCDecider } from 'schadem-cdk-construct-sfn-idp-decider'

new IDPPOCDecider(parent: Construct, id: string, props: IDPPOCDeciderProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps">IDPPOCDeciderProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps">IDPPOCDeciderProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.isConstruct"></a>

```typescript
import { IDPPOCDecider } from 'schadem-cdk-construct-sfn-idp-decider'

IDPPOCDecider.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---




## Protocols <a name="Protocols" id="Protocols"></a>

### IDPPOCDeciderProps <a name="IDPPOCDeciderProps" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps"></a>

- *Implemented By:* <a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps">IDPPOCDeciderProps</a>


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.s3OutputBucket">s3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.s3OutputPrefix">s3OutputPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.defaultClassification">defaultClassification</a></code> | <code>string</code> | *No description.* |

---

##### `s3OutputBucket`<sup>Required</sup> <a name="s3OutputBucket" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.s3OutputBucket"></a>

```typescript
public readonly s3OutputBucket: string;
```

- *Type:* string

---

##### `s3OutputPrefix`<sup>Required</sup> <a name="s3OutputPrefix" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.s3OutputPrefix"></a>

```typescript
public readonly s3OutputPrefix: string;
```

- *Type:* string

---

##### `defaultClassification`<sup>Optional</sup> <a name="defaultClassification" id="schadem-cdk-construct-sfn-idp-decider.IDPPOCDeciderProps.property.defaultClassification"></a>

```typescript
public readonly defaultClassification: string;
```

- *Type:* string

---

