# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOpenSearchPatternResult',
    'AwaitableGetOpenSearchPatternResult',
    'get_open_search_pattern',
    'get_open_search_pattern_output',
]

@pulumi.output_type
class GetOpenSearchPatternResult:
    """
    A collection of values returned by getOpenSearchPattern.
    """
    def __init__(__self__, cluster_id=None, id=None, max_index_count=None, pattern=None, service_name=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_index_count and not isinstance(max_index_count, int):
            raise TypeError("Expected argument 'max_index_count' to be a int")
        pulumi.set(__self__, "max_index_count", max_index_count)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxIndexCount")
    def max_index_count(self) -> int:
        """
        Maximum number of index for this pattern.
        """
        return pulumi.get(self, "max_index_count")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        Pattern format.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Current status of the pattern.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetOpenSearchPatternResult(GetOpenSearchPatternResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpenSearchPatternResult(
            cluster_id=self.cluster_id,
            id=self.id,
            max_index_count=self.max_index_count,
            pattern=self.pattern,
            service_name=self.service_name)


def get_open_search_pattern(cluster_id: Optional[str] = None,
                            id: Optional[str] = None,
                            service_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpenSearchPatternResult:
    """
    Use this data source to get information about a pattern of a opensearch cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    pattern = ovh.CloudProject.get_open_search_pattern(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("patternPattern", pattern.pattern)
    ```


    :param str cluster_id: Cluster ID
    :param str id: Pattern ID.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getOpenSearchPattern:getOpenSearchPattern', __args__, opts=opts, typ=GetOpenSearchPatternResult).value

    return AwaitableGetOpenSearchPatternResult(
        cluster_id=__ret__.cluster_id,
        id=__ret__.id,
        max_index_count=__ret__.max_index_count,
        pattern=__ret__.pattern,
        service_name=__ret__.service_name)


@_utilities.lift_output_func(get_open_search_pattern)
def get_open_search_pattern_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                   id: Optional[pulumi.Input[str]] = None,
                                   service_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpenSearchPatternResult]:
    """
    Use this data source to get information about a pattern of a opensearch cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    pattern = ovh.CloudProject.get_open_search_pattern(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("patternPattern", pattern.pattern)
    ```


    :param str cluster_id: Cluster ID
    :param str id: Pattern ID.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
