# Generated by Django 3.0.8 on 2020-07-15 14:06

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import huscy.projects.models.reserach_unit


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='DataAcquisitionMethod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveSmallIntegerField()),
                ('type', models.CharField(choices=[('behav', 'Behavioral'), ('bio', 'Biological samples'), ('eeg', 'Electroencephalography'), ('meg', 'Magnetoencephalography'), ('micro', 'Microscopy data'), ('mri', 'Magnetic resonance imaging'), ('nirs', 'Near-Infrared Spectroscopy'), ('pause', 'Pause'), ('pet', 'Positron-emission tomography'), ('phys', 'Physiological measures'), ('quest', 'Questionnaire'), ('screen', 'Screening')], max_length=16)),
                ('location', models.CharField(max_length=126)),
            ],
        ),
        migrations.CreateModel(
            name='Experiment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True, default='')),
                ('order', models.PositiveSmallIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Stimulus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.PositiveSmallIntegerField(choices=[(0, 'auditive'), (1, 'gustatory'), (2, 'haptic'), (3, 'olfactory'), (4, 'visual')])),
            ],
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64)),
                ('order', models.PositiveSmallIntegerField()),
                ('setup_time', models.DurationField(default=datetime.timedelta(0))),
                ('duration', models.DurationField()),
                ('teardown_time', models.DurationField(default=datetime.timedelta(0))),
                ('max_number_of_participants', models.PositiveIntegerField(default=1)),
                ('experiment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to='projects.Experiment')),
                ('operator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Screening',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='screenings', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='ResearchUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('code', models.CharField(blank=True, default=huscy.projects.models.reserach_unit.get_default_value_for_code, max_length=32, unique=True)),
                ('principal_investigator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Questionnaire',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questionnaires', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('local_id', models.PositiveIntegerField()),
                ('title', models.CharField(max_length=126)),
                ('description', models.TextField(blank=True, default='')),
                ('visibility', models.PositiveSmallIntegerField(choices=[(0, 'public'), (1, 'private')], default=0)),
                ('principal_investigator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
                ('research_unit', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='projects.ResearchUnit')),
            ],
            options={
                'permissions': (('can_view_private_projects', 'Can view private projects'),),
                'unique_together': {('local_id', 'research_unit')},
            },
        ),
        migrations.CreateModel(
            name='Physiological',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physiologicals', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='PET',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pet', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='Pause',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pause', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='NIRS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nirs', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='MRI',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='mri', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='Microscopy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='microscopys', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='MEG',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='meg', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.AddField(
            model_name='experiment',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='experiments', to='projects.Project'),
        ),
        migrations.CreateModel(
            name='EEG',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='eeg', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.AddField(
            model_name='dataacquisitionmethod',
            name='session',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projects.Session'),
        ),
        migrations.AddField(
            model_name='dataacquisitionmethod',
            name='stimulus',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='projects.Stimulus'),
        ),
        migrations.CreateModel(
            name='Biological',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='biologicals', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='Behavioral',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='behaviorals', to='projects.DataAcquisitionMethod')),
            ],
        ),
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_coordinator', models.BooleanField(default=False)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='projects.Project')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'project')},
            },
        ),
    ]
