"""added scene objects table

Revision ID: eae01b0af1c7
Revises: 0c2d591e286e
Create Date: 2023-02-18 11:11:20.198850

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "eae01b0af1c7"
down_revision = "0c2d591e286e"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "scene_objects",
        sa.Column("scene_object_id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=False),
        sa.Column("scene_id", sa.Integer(), nullable=False),
        sa.Column("object_number", sa.Integer(), nullable=False),
        sa.Column("frame_number", sa.Integer(), nullable=False),
        sa.Column("object_x", sa.Integer(), nullable=False),
        sa.Column("object_y", sa.Integer(), nullable=False),
        sa.Column("object_w", sa.Integer(), nullable=False),
        sa.Column("object_h", sa.Integer(), nullable=False),
        sa.Column("confidence_score", sa.Numeric(precision=3, scale=2), nullable=False),
        sa.Column("timestamp_added", sa.String(length=10), nullable=False),
        sa.ForeignKeyConstraint(
            ["scene_id"],
            ["scenes.scene_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("scene_object_id"),
        sa.UniqueConstraint(
            "scene_id", "object_number", "frame_number", name="scene_object_frame"
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("scene_objects")
    # ### end Alembic commands ###
