"""timestamp_adds not nullable and triggers uniqueness constraint

Revision ID: cc6544d0f3bb
Revises: 87163b759a86
Create Date: 2018-02-14 22:58:53.310498

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "cc6544d0f3bb"
down_revision = "87163b759a86"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "processes",
        "timestamp_add_processes",
        existing_type=mysql.VARCHAR(length=10),
        nullable=False,
    )
    op.alter_column(
        "triggers",
        "timestamp_add_trigger",
        existing_type=mysql.VARCHAR(length=10),
        nullable=False,
    )
    op.create_unique_constraint("video_process", "triggers", ["video_id", "process_id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("video_process", "triggers", type_="unique")
    op.alter_column(
        "triggers",
        "timestamp_add_trigger",
        existing_type=mysql.VARCHAR(length=10),
        nullable=True,
    )
    op.alter_column(
        "processes",
        "timestamp_add_processes",
        existing_type=mysql.VARCHAR(length=10),
        nullable=True,
    )
    # ### end Alembic commands ###
