"""added scenes table

Revision ID: a30667503cc5
Revises: c103233a6a69
Create Date: 2023-02-07 21:46:25.536017

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "a30667503cc5"
down_revision = "c103233a6a69"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "scenes",
        sa.Column("scene_id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=False),
        sa.Column(
            "detector_threshold", sa.Numeric(precision=3, scale=2), nullable=False
        ),
        sa.Column("scene_number", sa.Integer(), nullable=False),
        sa.Column("start_frame", sa.Integer(), nullable=False),
        sa.Column("end_frame", sa.Integer(), nullable=False),
        sa.Column("start_time", sa.String(length=12), nullable=False),
        sa.Column("end_time", sa.String(length=12), nullable=False),
        sa.Column("timestamp_added", sa.String(length=10), nullable=False),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("scene_id"),
        sa.UniqueConstraint(
            "video_id",
            "detector_threshold",
            "scene_number",
            name="video_threshold_scene_number",
        ),
    )
    op.create_foreign_key(
        None,
        "facenet_haar_predictions",
        "facenet_haar_models",
        ["facenet_haar_model_name"],
        ["model_name"],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "facenet_haar_predictions", type_="foreignkey")
    op.drop_table("scenes")
    # ### end Alembic commands ###
