import logging
import os
import pytest

from tral.sequence import sequence_io

TEST_FAA_FILE = "HIV-1_388796.faa"
TEST_SEQ_1 = "MKVMGIQRNCQQWWIWGILGFWMLMICNGMGNLWVTVYYGVPVWKDASPTLFCASDAKAYDTEVHNVWGTFACVPTDPSPQELGLENVTENFNMWKNDMVEQMHQDIISLWDQGLKPCVKLTPLCVTLNCNAIKNNTKVTNNSINSANDEMKNCSFNITTELRDKKRKAYALFYKLDIVPLNNGSTDYRLINCNTSTITQACPKVSLDPIPIHYCAPAGYAILKCRDKTFTGTGPCHNVSTVQCTHGIKPVVSTQLLLNGSIAEGETIIRFENLTNNAKIIIVQLNESVEITCTRPSNNTRESIRIGPGQTFYATGDIIGDIRQAHCNISEEKWNKTLQKVKEKLQKHFPNKTIEFKPSSGGDLEITTHSFNCGGEFFYCNTSNLFNSTKLELFNSSTNLNITLQCRIKQIINMWQGVGRAMYAPPIEGIIMCRSNITGLLLTRDGAKEPHSTKEIFRPEGGDMRDNWRSELYKYKVVEIKPLGVAPTKPKRRVVEREKRAALGALFLGFLGAAGSTMGAASITLTVQARQLLSGIVQQQSNLLKAIEAQQHMLQLTVWGIKQLQTRVLAIERHLRDQQLLGIWGCSGKLICTTAVPWNSSWSNKSQEEIWDNMTWMQWDREISNYTDIIYNLLEVSQNQQDKNEKDLLALDKWENLWNWFNITNWLWYIKIFIMIVGGVIGLRIIFAVLSIVNRVRQGYSPLSFQTLIPHPRGPDRLGGIEEEGGEQGRDRSIRLVNGFLAIFWDDLRSLCLFSYHRLRDLILIAARTVELLGRSSLKGLQRGWETLKYLGSLVQYWGLELKKSAINLLNTTAIVVGEGTDRFIELIQRIWRAFCNIPRRIRQGLEAALQ"
TEST_SEQ_1_ID = "sp|Q75008|ENV_HV1ET"

notfixed = pytest.mark.notfixed

@pytest.fixture
def path():
    """Return the path to the test data files.
    """
    return os.path.join(os.path.abspath('.'), 'sequence', 'test')


@pytest.mark.no_external_software_required
def test_read_fasta():

    test_lSeq = list(sequence_io.read_fasta( os.path.join(path(), TEST_FAA_FILE) ))
    assert len(test_lSeq) == 9
    assert test_lSeq[0] == (TEST_SEQ_1, TEST_SEQ_1_ID)


