"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BundledNodejsFunction = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
// projen defines the bundling as a post compile task. it's defined at the bottom of .projenrc.js.
class BundledNodejsFunction extends aws_cdk_lib_1.aws_lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', id)),
            handler: 'index.handler',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        this.props = props;
    }
}
exports.BundledNodejsFunction = BundledNodejsFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLDZDQUFxRTtBQUdyRSxrR0FBa0c7QUFDbEcsTUFBYSxxQkFBc0IsU0FBUSx3QkFBTSxDQUFDLFFBQVE7SUFDeEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBVyxLQUE2QjtRQUM5RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLEdBQUcsS0FBSztZQUNSLElBQUksRUFBRSx3QkFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1lBQ2hFLE9BQU8sRUFBRSxlQUFlO1lBQ3hCLE9BQU8sRUFBRSx3QkFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1lBQ25DLFlBQVksRUFBRSxzQkFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTO1NBQzNDLENBQUMsQ0FBQztRQVA4QyxVQUFLLEdBQUwsS0FBSyxDQUF3QjtJQVFoRixDQUFDO0NBQ0Y7QUFWRCxzREFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBhd3NfbGFtYmRhIGFzIGxhbWJkYSwgYXdzX2xvZ3MgYXMgbG9ncyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vLyBwcm9qZW4gZGVmaW5lcyB0aGUgYnVuZGxpbmcgYXMgYSBwb3N0IGNvbXBpbGUgdGFzay4gaXQncyBkZWZpbmVkIGF0IHRoZSBib3R0b20gb2YgLnByb2plbnJjLmpzLlxuZXhwb3J0IGNsYXNzIEJ1bmRsZWROb2RlanNGdW5jdGlvbiBleHRlbmRzIGxhbWJkYS5GdW5jdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlYWRvbmx5IHByb3BzOiBsYW1iZGEuRnVuY3Rpb25PcHRpb25zKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGFtYmRhcycsIGlkKSksXG4gICAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTRfWCxcbiAgICAgIGxvZ1JldGVudGlvbjogbG9ncy5SZXRlbnRpb25EYXlzLk9ORV9NT05USCxcbiAgICB9KTtcbiAgfVxufSJdfQ==