import { Duration, aws_codebuild as codebuild, aws_ec2 as ec2, aws_iam as iam, aws_stepfunctions as stepfunctions } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IRunnerProvider, RunnerProviderProps, RunnerRuntimeParameters } from './common';
export interface CodeBuildRunnerProps extends RunnerProviderProps {
    /**
     * GitHub Actions label used for this provider.
     *
     * @default 'codebuild'
     */
    readonly label?: string;
    /**
     * VPC to launch the runners in.
     *
     * @default no VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Security Group to assign to this instance.
     *
     * @default public project with no security group
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * Where to place the network interfaces within the VPC.
     *
     * @default no subnet
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * The type of compute to use for this build.
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default {@link ComputeType#SMALL}
     */
    readonly computeType?: codebuild.ComputeType;
    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's
     * not complete. For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     *
     * @default Duration.hours(1)
     */
    readonly timeout?: Duration;
}
/**
 * GitHub Actions runner provider using CodeBuild to execute the actions.
 *
 * Creates a project that gets started for each job.
 */
export declare class CodeBuildRunner extends Construct implements IRunnerProvider {
    readonly project: codebuild.Project;
    readonly label: string;
    readonly vpc?: ec2.IVpc;
    readonly securityGroup?: ec2.ISecurityGroup;
    readonly grantPrincipal: iam.IPrincipal;
    constructor(scope: Construct, id: string, props: CodeBuildRunnerProps);
    getStepFunctionTask(parameters: RunnerRuntimeParameters): stepfunctions.IChainable;
    get connections(): ec2.Connections;
}
//# sourceMappingURL=codebuild.d.ts.map