#############################################################################
##
## MIT License
## 
## Copyright (c) 2021 tonquer
## 
## Permission is hereby granted, free of charge, to any person obtaining a copy
## of this software and associated documentation files (the "Software"), to deal
## in the Software without restriction, including without limitation the rights
## to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
## copies of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
## 
## The above copyright notice and this permission notice shall be included in all
## copies or substantial portions of the Software.
## 
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
## AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
## OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.
##
#############################################################################
"""
This file contains the exact signatures for all functions in module
waifu2x_vulkan.waifu2x, except for defaults which are replaced by "...".
"""

# Module `waifu2x_vulkan.waifu2x`

from typing import Tuple, overload, Union, Optional, List
from typing_extensions import Literal
import waifu2x_vulkan

MODEL_ANIME_STYLE_ART_RGB_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE0 = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE0_TTA = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE1 = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE1_TTA = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE2 = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE2_TTA = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE3 = ...
MODEL_ANIME_STYLE_ART_RGB_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE3_TTA = ...
MODEL_ANIME_STYLE_ART_RGB_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NO_NOISE = ...
MODEL_ANIME_STYLE_ART_RGB_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NO_NOISE_TTA = ...
MODEL_CUNET_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE0 = ...
MODEL_CUNET_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE0_TTA = ...
MODEL_CUNET_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE1 = ...
MODEL_CUNET_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE1_TTA = ...
MODEL_CUNET_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE2 = ...
MODEL_CUNET_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE2_TTA = ...
MODEL_CUNET_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE3 = ... 
MODEL_CUNET_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE3_TTA = ...
MODEL_CUNET_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_NOISE = ... 
MODEL_CUNET_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_NOISE_TTA = ...
MODEL_CUNET_NO_SCALE_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE0 = ...
MODEL_CUNET_NO_SCALE_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE0_TTA = ...
MODEL_CUNET_NO_SCALE_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE1 = ...
MODEL_CUNET_NO_SCALE_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE1_TTA = ...
MODEL_CUNET_NO_SCALE_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE2 = ...
MODEL_CUNET_NO_SCALE_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE2_TTA = ...
MODEL_CUNET_NO_SCALE_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE3 = ...
MODEL_CUNET_NO_SCALE_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE3_TTA = ...
MODEL_CUNET_NO_SCALE_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NO_NOISE = ...
MODEL_CUNET_NO_SCALE_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NO_NOISE_TTA = ...
MODEL_PHOTO_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE0 = ...
MODEL_PHOTO_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE0_TTA = ...
MODEL_PHOTO_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE1 = ...
MODEL_PHOTO_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE1_TTA = ...
MODEL_PHOTO_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE2 = ...
MODEL_PHOTO_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE2_TTA = ...
MODEL_PHOTO_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE3 = ...
MODEL_PHOTO_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE3_TTA = ...
MODEL_PHOTO_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NO_NOISE = ...
MODEL_PHOTO_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NO_NOISE_TTA = ...

class MODEL:
    MODEL_ANIME_STYLE_ART_RGB_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE0 = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE0_TTA = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE1 = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE1_TTA = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE2 = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE2_TTA = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE3 = ...
    MODEL_ANIME_STYLE_ART_RGB_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NOISE3_TTA = ...
    MODEL_ANIME_STYLE_ART_RGB_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NO_NOISE = ...
    MODEL_ANIME_STYLE_ART_RGB_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_ANIME_STYLE_ART_RGB_NO_NOISE_TTA = ...
    MODEL_CUNET_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE0 = ...
    MODEL_CUNET_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE0_TTA = ...
    MODEL_CUNET_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE1 = ...
    MODEL_CUNET_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE1_TTA = ...
    MODEL_CUNET_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE2 = ...
    MODEL_CUNET_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE2_TTA = ...
    MODEL_CUNET_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE3 = ... 
    MODEL_CUNET_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NOISE3_TTA = ...
    MODEL_CUNET_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_NOISE = ... 
    MODEL_CUNET_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_NOISE_TTA = ...
    MODEL_CUNET_NO_SCALE_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE0 = ...
    MODEL_CUNET_NO_SCALE_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE0_TTA = ...
    MODEL_CUNET_NO_SCALE_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE1 = ...
    MODEL_CUNET_NO_SCALE_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE1_TTA = ...
    MODEL_CUNET_NO_SCALE_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE2 = ...
    MODEL_CUNET_NO_SCALE_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE2_TTA = ...
    MODEL_CUNET_NO_SCALE_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE3 = ...
    MODEL_CUNET_NO_SCALE_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NOISE3 = ...
    MODEL_CUNET_NO_SCALE_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NO_NOISE = ...
    MODEL_CUNET_NO_SCALE_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_CUNET_NO_SCALE_NO_NOISE_TTA = ...
    MODEL_PHOTO_NOISE0 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE0 = ...
    MODEL_PHOTO_NOISE0_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE0_TTA = ...
    MODEL_PHOTO_NOISE1 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE1 = ...
    MODEL_PHOTO_NOISE1_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE1_TTA = ...
    MODEL_PHOTO_NOISE2 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE2 = ...
    MODEL_PHOTO_NOISE2_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE2_TTA = ...
    MODEL_PHOTO_NOISE3 :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE3 = ...
    MODEL_PHOTO_NOISE3_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NOISE3_TTA = ...
    MODEL_PHOTO_NO_NOISE :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NO_NOISE = ...
    MODEL_PHOTO_NO_NOISE_TTA :  waifu2x_vulkan.MODEL.MODEL_PHOTO_NO_NOISE_TTA = ...

_FORMAT = Literal["", "jpg", "jpeg", "png", "bmp", "webp", "apng"]

def init() -> int: ...
def getGpuInfo() -> Union[None, List[str]]: ...
def getGpuCoreNum(gpuId:int) -> int: ...
def getCpuCoreNum() -> int: ...
def initSet(gpuId:int, cpuNum:int=...) -> int: ...
@overload
def add(data:bytes, modelIndex: MODEL, backId:int, width:int, height:int, format:_FORMAT="", tileSize:int=400) -> int: ...
@overload
def add(data:bytes, modelIndex: MODEL, backId:int, scale:float, format:_FORMAT="", tileSize:int=400) -> int: ...
def getVersion() -> str: ...
def setDebug(bool) -> None: ...
def setWebpQuality(int) -> None: ...
def getLastError() -> str: ...
def remove(backIds:List[int]) -> None: ...
def removeWaitProc(backIds:List[int]) -> None: ...
def load(block:int) -> Union[None, Tuple]: ...
def stop() -> None: ...

# eof
