# pylingdocs

Create data-rich linguistic documents.

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6567304.svg)](https://doi.org/10.5281/zenodo.6567304)
![License](https://img.shields.io/github/license/fmatter/pylingdocs)
[![Documentation Status](https://readthedocs.org/projects/pylingdocs/badge/?version=latest)](https://pylingdocs.readthedocs.io/en/latest/?badge=latest)
[![Tests](https://img.shields.io/github/workflow/status/fmatter/pylingdocs/tests?label=tests)](https://github.com/fmatter/pylingdocs/actions/workflows/tests.yml)
[![Linting](https://img.shields.io/github/workflow/status/fmatter/pylingdocs/lint?label=linting)](https://github.com/fmatter/pylingdocs/actions/workflows/lint.yml)
[![Codecov](https://img.shields.io/codecov/c/github/fmatter/pylingdocs)](https://app.codecov.io/gh/fmatter/pylingdocs/)
[![PyPI](https://img.shields.io/pypi/v/pylingdocs.svg)](https://pypi.org/project/pylingdocs)
![Versions](https://img.shields.io/pypi/pyversions/pylingdocs)

The main functionalities of `pylingdocs` are showcased in the demo, where [this text](https://github.com/fmatter/pylingdocs/blob/main/docs/demo.txt), using [this dataset](https://github.com/fmatter/pylingdocs/tree/main/tests/data/cldf), is turned into a [PDF file](https://raw.githubusercontent.com/fmatter/pylingdocs/main/docs/demo.pdf).
Integration into CLLD web apps is possible with [clld-markdown-plugin](https://github.com/clld/clld-markdown-plugin/), optionally combined with [clld-document-plugin](https://github.com/fmatter/clld-document-plugin/); an example can be inspected [here](https://fl.mt/yawarana-sketch).

Installation:

`pip install pylingdocs`

For further instructions check out the documentation at [pylingdocs.readthedocs.io](https://pylingdocs.readthedocs.io).

Rudimentary GUI editor:

`pip install pylingdocs-gui`
