# Roadmap

lihil follows semantic versioning, where a version in x.y.z format,
x: major, breaking change
y: minor, feature updates
z: patch, bug fixes, typing updates

1.0.0 onwards means a stable api.

## version 0.1.0

First release, provide a working solution to most cases

- routing, request/response
- dependency injection
- lifespan event
- openapi schema
- message bus

## 🔮 **What’s Next**

Lihil is currently **v0.1.6**, and already quite usable for real apps.

Planned for v0.2.0 and beyond, likely in order:

- Tutorials & videos on lihil and web dev in general
- Out-of-process event system (RabbitMQ, Kafka, etc.).
- A highly performant schema-based query builder based on asyncpg
- Local command handler(http rpc) and remote command handler (gRPC)
- More middleware and official plugins (e.g., throttling, caching, auth).

If you are building **a scalable API**, **an AI backend**, or **a large Python web app**, I would love to hear your thoughts and feedback.
