from enum import Enum, unique


@unique
class EnumOrderRejectReason(Enum):
    每秒请求超许可数 = 0  # 已撤单报单被拒绝综合交易平台：交易所每秒发送请求数超过许可数
    价格非最小单位倍数 = 1  # 已撤单报单被拒绝价格非最小单位的倍数
    价格高于涨停板 = 2   # 已撤单报单被拒绝价格涨破涨停板
    价格低于跌停板 = 3 # 已撤单报单被拒绝价格跌破跌停板
    资金不足 = 4   # 综合交易平台：资金不足
    平今仓位不足 = 5   # 综合交易平台：平今仓位不足
    平昨仓位不足 = 6    # 综合交易平台：平昨仓位不足
    不支持报单类型= 7  # 已撤单报单被拒绝不被支持的报单类型
    不支持套利类型报单= 8  # 该交易所不支持套利类型报单
    保值额度不足= 9  # 已撤单报单被拒绝保值额度不足
    网络连接失败= 10  # 网络连接失败
    延迟开仓被Qi拒绝= 11  # 委托数超过流量限制，MagicQuant拒绝延迟发送开仓单
    Qi暂停开仓= 12 # MagicQuant暂停发送开仓单XX秒
    报单数量错误= 13
    提交委托失败= 14  # 发送委托失败
    未知= 15 # 未知