FFT Multiplication
=======

Author: **[Moin Khan](https://github.com/mo-inkhan)**

# FFT Multiplication: An implementation of the Fast Fourier Transform (FFT) algorithm to multiply two polynomials efficiently.

## Introduction

`FFT Multiplication` is a simple, zero-configuration command-line static HTTP server.

## Installation:

#### Globally via `pip`

    pip install fft_multiplication

This will install `fft_multiplication` globally so that it can be imported into any python program.

## Usage:

```python
from fft_multiplication import multiply

p = [1, 1]
q = [1, 0]

print(multiply(p, q))
```

## Features

- Efficient polynomial multiplication using the Fast Fourier Transform (FFT) algorithm
- Comparison with the direct multiplication method
- Test cases to ensure correctness of the implementations

---

## Requirements
Python 3.x

---

## Contributing
All contributions are welcome. Please create an issue first for any feature request
or bug. Then fork the repository, create a branch and make any changes to fix the bug
or add the feature and create a pull request. That's it!
Thanks!

---

## License
**fft_multiplication** is released under the MIT License.
Check out the full license [here](LICENSE).
