import enum
from uuid import UUID

from myst.connectors.source_connector import SourceConnector
from myst.core.time.time_delta import TimeDelta


@enum.unique
class CountryField(str, enum.Enum):
    ANGOLA = "Angola"
    ARGENTINA = "Argentina"
    ARUBA = "Aruba"
    AUSTRALIA = "Australia"
    AUSTRIA = "Austria"
    BANGLADESH = "Bangladesh"
    BELARUS = "Belarus"
    BELGIUM = "Belgium"
    BOTSWANA = "Botswana"
    BRAZIL = "Brazil"
    BULGARIA = "Bulgaria"
    BURUNDI = "Burundi"
    CANADA = "Canada"
    CHILE = "Chile"
    COLOMBIA = "Colombia"
    CROATIA = "Croatia"
    CURACAO = "Curacao"
    CZECHIA = "Czechia"
    DENMARK = "Denmark"
    DJIBOUTI = "Djibouti"
    DOMINICAN_REPUBLIC = "DominicanRepublic"
    EGYPT = "Egypt"
    ENGLAND = "England"
    ESTONIA = "Estonia"
    EUROPEAN_CENTRAL_BANK = "EuropeanCentralBank"
    FINLAND = "Finland"
    FRANCE = "France"
    GEORGIA = "Georgia"
    GERMANY = "Germany"
    GREECE = "Greece"
    HONDURAS = "Honduras"
    HONGKONG = "HongKong"
    HUNGARY = "Hungary"
    ICELAND = "Iceland"
    INDIA = "India"
    IRELAND = "Ireland"
    ISLE_OF_MAN = "IsleOfMan"
    ISRAEL = "Israel"
    ITALY = "Italy"
    JAMAICA = "Jamaica"
    JAPAN = "Japan"
    KENYA = "Kenya"
    KOREA = "Korea"
    LATVIA = "Latvia"
    LITHUANIA = "Lithuania"
    LUXEMBOURG = "Luxembourg"
    MALAYSIA = "Malaysia"
    MALAWI = "Malawi"
    MEXICO = "Mexico"
    MOROCCO = "Morocco"
    MOZAMBIQUE = "Mozambique"
    NETHERLANDS = "Netherlands"
    NEW_ZEALAND = "NewZealand"
    NICARAGUA = "Nicaragua"
    NIGERIA = "Nigeria"
    NORTHERN_IRELAND = "NorthernIreland"
    NORWAY = "Norway"
    PARAGUAY = "Paraguay"
    PERU = "Peru"
    POLAND = "Poland"
    PORTUGAL = "Portugal"
    PORTUGAL_EXTENDED = "PortugalExt"
    ROMANIA = "Romania"
    RUSSIA = "Russia"
    SAUDI_ARABIA = "SaudiArabia"
    SCOTLAND = "Scotland"
    SERBIA = "Serbia"
    SINGAPORE = "Singapore"
    SLOVAKIA = "Slovakia"
    SLOVENIA = "Slovenia"
    SOUTH_AFRICA = "SouthAfrica"
    SPAIN = "Spain"
    SWEDEN = "Sweden"
    SWITZERLAND = "Switzerland"
    TURKEY = "Turkey"
    UKRAINE = "Ukraine"
    UNITED_ARAB_EMIRATES = "UnitedArabEmirates"
    UNITED_KINGDOM = "UnitedKingdom"
    UNITED_STATES = "UnitedStates"
    VENEZUELA = "Venezuela"
    VIETNAM = "Vietnam"
    WALES = "Wales"


class Holidays(SourceConnector):
    def __init__(self, sample_period: TimeDelta, time_zone: str, country: CountryField) -> None:
        super().__init__(
            uuid=UUID("7c712128-ff20-4a71-b69d-92c5b3df665e"),
            parameters=dict(sample_period=sample_period, time_zone=time_zone, country=country),
        )
