"""The official `myst` python package owned by Myst AI, Inc."""

from myst.auth.credentials import authenticate, authenticate_with_service_account
from myst.client import Client, get_client, set_client
from myst.core.data.time_array import TimeArray
from myst.core.time.time import Time
from myst.core.time.time_delta import TimeDelta
from myst.resources.input import Input
from myst.resources.layer import Layer
from myst.resources.model import Model
from myst.resources.operation import Operation
from myst.resources.project import Project
from myst.resources.source import Source
from myst.resources.time_series import TimeSeries
from myst.settings import settings
from myst.version import get_package_version

__version__ = get_package_version()


__all__ = [
    "authenticate_with_service_account",
    "authenticate",
    "Client",
    "get_client",
    "set_client",
    "Input",
    "Layer",
    "Model",
    "Operation",
    "Project",
    "settings",
    "Source",
    "Time",
    "TimeArray",
    "TimeDelta",
    "TimeSeries",
]
