import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::ImpactApi::EC2Instance::MODULE
 *
 * @schema CfnEc2InstanceModuleProps
 */
export interface CfnEc2InstanceModuleProps {
    /**
     * @schema CfnEc2InstanceModuleProps#Parameters
     */
    readonly parameters?: CfnEc2InstanceModulePropsParameters;
    /**
     * @schema CfnEc2InstanceModuleProps#Resources
     */
    readonly resources?: CfnEc2InstanceModulePropsResources;
}
/**
 * Converts an object of type 'CfnEc2InstanceModuleProps' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModuleProps(obj: CfnEc2InstanceModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEc2InstanceModulePropsParameters
 */
export interface CfnEc2InstanceModulePropsParameters {
    /**
     * The environment name
     *
     * @schema CfnEc2InstanceModulePropsParameters#EnvName
     */
    readonly envName?: CfnEc2InstanceModulePropsParametersEnvName;
    /**
     * The ImageDigest
     *
     * @schema CfnEc2InstanceModulePropsParameters#ImageDigest
     */
    readonly imageDigest?: CfnEc2InstanceModulePropsParametersImageDigest;
}
/**
 * Converts an object of type 'CfnEc2InstanceModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModulePropsParameters(obj: CfnEc2InstanceModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEc2InstanceModulePropsResources
 */
export interface CfnEc2InstanceModulePropsResources {
    /**
     * @schema CfnEc2InstanceModulePropsResources#ImpactClassifyEC2Instance
     */
    readonly impactClassifyEc2Instance?: CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance;
}
/**
 * Converts an object of type 'CfnEc2InstanceModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModulePropsResources(obj: CfnEc2InstanceModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnEc2InstanceModulePropsParametersEnvName
 */
export interface CfnEc2InstanceModulePropsParametersEnvName {
    /**
     * @schema CfnEc2InstanceModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnEc2InstanceModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnEc2InstanceModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModulePropsParametersEnvName(obj: CfnEc2InstanceModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * The ImageDigest
 *
 * @schema CfnEc2InstanceModulePropsParametersImageDigest
 */
export interface CfnEc2InstanceModulePropsParametersImageDigest {
    /**
     * @schema CfnEc2InstanceModulePropsParametersImageDigest#Type
     */
    readonly type: string;
    /**
     * @schema CfnEc2InstanceModulePropsParametersImageDigest#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnEc2InstanceModulePropsParametersImageDigest' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModulePropsParametersImageDigest(obj: CfnEc2InstanceModulePropsParametersImageDigest | undefined): Record<string, any> | undefined;
/**
 * @schema CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance
 */
export interface CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance {
    /**
     * @schema CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance#Type
     */
    readonly type?: string;
    /**
     * @schema CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance' to JSON representation.
 */
export declare function toJson_CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance(obj: CfnEc2InstanceModulePropsResourcesImpactClassifyEc2Instance | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::ImpactApi::EC2Instance::MODULE`
 *
 * @cloudformationResource FreyrAIM::ImpactApi::EC2Instance::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnEc2InstanceModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::ImpactApi::EC2Instance::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnEc2InstanceModuleProps;
    /**
     * Create a new `FreyrAIM::ImpactApi::EC2Instance::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnEc2InstanceModuleProps);
}
