from typing import Optional, Dict
from typing_extensions import NotRequired, TypedDict


class RequestOptions(TypedDict):
    api_key: NotRequired[Optional[str]]
    api_base: NotRequired[Optional[str]]
    xpay_version: NotRequired[Optional[str]]
    xpay_account: NotRequired[Optional[str]]
    idempotency_key: NotRequired[Optional[str]]
    headers: NotRequired[Optional[Dict[str, str]]]
