# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Product(object):

    def __init__(self, id=None, name=None, brand=None, category=None, variant=None, position=None, price=None, quantity=None, coupon_code=None, added_to_cart_time_ms=None, total_product_amount=None, custom_attributes=None):
        """
        Product - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'brand': 'str',
            'category': 'str',
            'variant': 'str',
            'position': 'int',
            'price': 'float',
            'quantity': 'float',
            'coupon_code': 'str',
            'added_to_cart_time_ms': 'int',
            'total_product_amount': 'float',
            'custom_attributes': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'brand': 'brand',
            'category': 'category',
            'variant': 'variant',
            'position': 'position',
            'price': 'price',
            'quantity': 'quantity',
            'coupon_code': 'coupon_code',
            'added_to_cart_time_ms': 'added_to_cart_time_ms',
            'total_product_amount': 'total_product_amount',
            'custom_attributes': 'custom_attributes'
        }

        self._id = id
        self._name = name
        self._brand = brand
        self._category = category
        self._variant = variant
        self._position = position
        self._price = price
        self._quantity = quantity
        self._coupon_code = coupon_code
        self._added_to_cart_time_ms = added_to_cart_time_ms
        self._total_product_amount = total_product_amount
        self._custom_attributes = custom_attributes

    @property
    def id(self):
        """
        Gets the id of this Product.


        :return: The id of this Product.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Product.


        :param id: The id of this Product.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Product.


        :return: The name of this Product.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Product.


        :param name: The name of this Product.
        :type: str
        """

        self._name = name

    @property
    def brand(self):
        """
        Gets the brand of this Product.


        :return: The brand of this Product.
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """
        Sets the brand of this Product.


        :param brand: The brand of this Product.
        :type: str
        """

        self._brand = brand

    @property
    def category(self):
        """
        Gets the category of this Product.


        :return: The category of this Product.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this Product.


        :param category: The category of this Product.
        :type: str
        """

        self._category = category

    @property
    def variant(self):
        """
        Gets the variant of this Product.


        :return: The variant of this Product.
        :rtype: str
        """
        return self._variant

    @variant.setter
    def variant(self, variant):
        """
        Sets the variant of this Product.


        :param variant: The variant of this Product.
        :type: str
        """

        self._variant = variant

    @property
    def position(self):
        """
        Gets the position of this Product.


        :return: The position of this Product.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this Product.


        :param position: The position of this Product.
        :type: int
        """

        self._position = position

    @property
    def price(self):
        """
        Gets the price of this Product.


        :return: The price of this Product.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this Product.


        :param price: The price of this Product.
        :type: float
        """

        self._price = price

    @property
    def quantity(self):
        """
        Gets the quantity of this Product.


        :return: The quantity of this Product.
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this Product.


        :param quantity: The quantity of this Product.
        :type: float
        """

        self._quantity = quantity

    @property
    def coupon_code(self):
        """
        Gets the coupon_code of this Product.


        :return: The coupon_code of this Product.
        :rtype: str
        """
        return self._coupon_code

    @coupon_code.setter
    def coupon_code(self, coupon_code):
        """
        Sets the coupon_code of this Product.


        :param coupon_code: The coupon_code of this Product.
        :type: str
        """

        self._coupon_code = coupon_code

    @property
    def added_to_cart_time_ms(self):
        """
        Gets the added_to_cart_time_ms of this Product.


        :return: The added_to_cart_time_ms of this Product.
        :rtype: int
        """
        return self._added_to_cart_time_ms

    @added_to_cart_time_ms.setter
    def added_to_cart_time_ms(self, added_to_cart_time_ms):
        """
        Sets the added_to_cart_time_ms of this Product.


        :param added_to_cart_time_ms: The added_to_cart_time_ms of this Product.
        :type: int
        """

        self._added_to_cart_time_ms = added_to_cart_time_ms

    @property
    def total_product_amount(self):
        """
        Gets the total_product_amount of this Product.


        :return: The total_product_amount of this Product.
        :rtype: float
        """
        return self._total_product_amount

    @total_product_amount.setter
    def total_product_amount(self, total_product_amount):
        """
        Sets the total_product_amount of this Product.


        :param total_product_amount: The total_product_amount of this Product.
        :type: float
        """

        self._total_product_amount = total_product_amount

    @property
    def custom_attributes(self):
        """
        Gets the custom_attributes of this Product.


        :return: The custom_attributes of this Product.
        :rtype: dict(str, str)
        """
        return self._custom_attributes

    @custom_attributes.setter
    def custom_attributes(self, custom_attributes):
        """
        Sets the custom_attributes of this Product.


        :param custom_attributes: The custom_attributes of this Product.
        :type: dict(str, str)
        """

        self._custom_attributes = custom_attributes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
