# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re
from .api_response import ApiResponse
from .api_response_errors import ApiResponseErrors
from .app_event import AppEvent
from .application_information import ApplicationInformation
from .application_state_transition_event import ApplicationStateTransitionEvent
from .attribution_info import AttributionInfo
from .breadcrumb_event import BreadcrumbEvent
from .consent_state import ConsentState
from .commerce_event import CommerceEvent
from .crash_report_event import CrashReportEvent
from .device_current_state import DeviceCurrentState
from .device_information import DeviceInformation
from .event_base import EventBase
from .event_data import EventData
from .first_run_event import FirstRunEvent
from .geo_location import GeoLocation
from .media_info import MediaInfo
from .network_performance_event import NetworkPerformanceEvent
from .opt_out_event import OptOutEvent
from .product import Product
from .product_action import ProductAction
from .product_impression import ProductImpression
from .profile_event import ProfileEvent
from .promotion import Promotion
from .promotion_action import PromotionAction
from .push_message_event import PushMessageEvent
from .push_registration_event import PushRegistrationEvent
from .screen_view_event import ScreenViewEvent
from .session_end_event import SessionEndEvent
from .session_start_event import SessionStartEvent
from .shopping_cart import ShoppingCart
from .source_information import SourceInformation
from .user_identities import UserIdentities


class Batch(object):

    def __init__(self, events=None, source_request_id=None, environment=None, ip=None, schema_version=None, device_info=None, application_info=None, user_attributes=None, deleted_user_attributes=None, user_identities=None, api_key=None, mpid=None, mp_deviceid=None, consent_state=None, context=None):
        """
        Batch - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'events': 'list[EventBase]',
            'source_request_id': 'str',
            'environment': 'str',
            'ip': 'str',
            'schema_version': 'int',
            'device_info': 'DeviceInformation',
            'application_info': 'ApplicationInformation',
            'user_attributes': 'object',
            'deleted_user_attributes': 'list[str]',
            'user_identities': 'UserIdentities',
            'consent_state': 'ConsentState',
            'api_key': 'str',
            'mpid': 'int',
            'mp_deviceid': 'str',
            'context': 'BatchContext'
        }

        self.attribute_map = {
            'events': 'events',
            'source_request_id': 'source_request_id',
            'environment': 'environment',
            'ip': 'ip',
            'schema_version': 'schema_version',
            'device_info': 'device_info',
            'application_info': 'application_info',
            'user_attributes': 'user_attributes',
            'deleted_user_attributes': 'deleted_user_attributes',
            'user_identities': 'user_identities',
            'consent_state': 'consent_state',
            'api_key': 'api_key',
            'mpid': 'mpid',
            'mp_deviceid': 'mp_deviceid',
            'context': 'context',
        }

        self._api_key = api_key
        self._events = events
        self._source_request_id = source_request_id
        self._environment = environment
        self._ip = ip
        self._schema_version = schema_version
        self._device_info = device_info
        self._application_info = application_info
        self._user_attributes = user_attributes
        self._consent_state = consent_state
        self._deleted_user_attributes = deleted_user_attributes
        self._user_identities = user_identities
        self._mpid = mpid
        self._mp_deviceid = mp_deviceid
        self._allowed_types = {type(AppEvent('empty')): 'custom_event',
                               type(FirstRunEvent()): 'first_run',
                               type(SessionStartEvent()): 'session_start',
                               type(SessionEndEvent()): 'session_end',
                               type(ApplicationStateTransitionEvent()): 'application_state_transition',
                               type(ScreenViewEvent()): 'screen_view',
                               type(PushRegistrationEvent()): 'push_registration',
                               type(ProfileEvent()): 'profile',
                               type(OptOutEvent()): 'opt_out',
                               type(BreadcrumbEvent()): 'breadcrumb',
                               type(CommerceEvent(ProductAction('purchase'))): 'commerce_event',
                               type(PushMessageEvent()): 'push_message',
                               type(NetworkPerformanceEvent()): 'network_performance',
                               type(CrashReportEvent()): 'commerce_event'}
        self._context = context

    @property
    def events(self):
        """
        Gets the events of this Batch.


        :return: The events of this Batch.
        :rtype: list[EventBase]
        """
        return self._events

    @events.setter
    def events(self, events):
        """
        Sets the events of this Batch.


        :param events: The events of this Batch.
        :type: list[EventBase]
        """
        self._events = [self.__convert_to_eventbase(event) for event in events]

    def __convert_to_eventbase(self, event):
        event_type = type(event)
        if (event_type is EventBase):
            return event

        if event_type not in self._allowed_types:
            raise ValueError(
                "Invalid event type: " +
                str(event_type) + " added to batch, must be one of {0}"
                .format(self._allowed_types.keys())
            )

        event_base = EventBase()
        event_base.event_type = self._allowed_types[event_type]
        event_base.data = event
        return event_base

    @property
    def source_request_id(self):
        """
        Gets the source_request_id of this Batch.


        :return: The source_request_id of this Batch.
        :rtype: str
        """
        return self._source_request_id

    @source_request_id.setter
    def source_request_id(self, source_request_id):
        """
        Sets the source_request_id of this Batch.


        :param source_request_id: The source_request_id of this Batch.
        :type: str
        """

        self._source_request_id = source_request_id

    @property
    def environment(self):
        """
        Gets the environment of this Batch.


        :return: The environment of this Batch.
        :rtype: str
        """
        return self._environment

    @environment.setter
    def environment(self, environment):
        """
        Sets the environment of this Batch.


        :param environment: The environment of this Batch.
        :type: str
        """
        allowed_values = ["production", "development"]
        if environment not in allowed_values:
            raise ValueError(
                "Invalid value for `environment` ({0}), must be one of {1}"
                .format(environment, allowed_values)
            )

        self._environment = environment

    @property
    def api_key(self):
        """
        Gets the api_key of this Batch. This should only be used while uploading
        data via Amazon SQS.


        :return: The api_key of this Batch.
        :rtype: str
        """
        return self._api_key

    @api_key.setter
    def api_key(self, api_key):
        """
        Sets the api_key of this Batch. This should only be used while uploading
        data via Amazon SQS.


        :param ip: The api_key of this Batch.
        :type: str
        """

        self._api_key = api_key

    @property
    def ip(self):
        """
        Gets the ip address of this Batch.


        :return: The ip of this Batch.
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """
        Sets the ip address of this Batch.


        :param ip: The ip of this Batch.
        :type: str
        """

        self._ip = ip

    @property
    def schema_version(self):
        """
        Gets the schema_version of this Batch.


        :return: The schema_version of this Batch.
        :rtype: int
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version):
        """
        Sets the schema_version of this Batch.


        :param schema_version: The schema_version of this Batch.
        :type: int
        """

        self._schema_version = schema_version

    @property
    def device_info(self):
        """
        Gets the device_info of this Batch.


        :return: The device_info of this Batch.
        :rtype: DeviceInformation
        """
        return self._device_info

    @device_info.setter
    def device_info(self, device_info):
        """
        Sets the device_info of this Batch.


        :param device_info: The device_info of this Batch.
        :type: DeviceInformation
        """

        self._device_info = device_info

    @property
    def application_info(self):
        """
        Gets the application_info of this Batch.


        :return: The application_info of this Batch.
        :rtype: ApplicationInformation
        """
        return self._application_info

    @application_info.setter
    def application_info(self, application_info):
        """
        Sets the application_info of this Batch.


        :param application_info: The application_info of this Batch.
        :type: ApplicationInformation
        """

        self._application_info = application_info

    @property
    def user_attributes(self):
        """
        Gets the user_attributes of this Batch.


        :return: The user_attributes of this Batch.
        :rtype: object
        """
        return self._user_attributes

    @user_attributes.setter
    def user_attributes(self, user_attributes):
        """
        Sets the user_attributes of this Batch.

        User attributes must be a dictionary with strings for keys and either strings or arrays of strings as values,
        for example: batch.user_attributes = {"eyes":"brown","favorite_foods":["indian","chinese","italian"]}
        :param user_attributes: The user_attributes of this Batch.
        :type: object
        """

        self._user_attributes = user_attributes

    @property
    def deleted_user_attributes(self):
        """
        Gets the deleted_user_attributes of this Batch.


        :return: The deleted_user_attributes of this Batch.
        :rtype: list[str]
        """
        return self._deleted_user_attributes

    @deleted_user_attributes.setter
    def deleted_user_attributes(self, deleted_user_attributes):
        """
        Sets the deleted_user_attributes of this Batch.


        :param deleted_user_attributes: The deleted_user_attributes of this Batch.
        :type: list[str]
        """

        self._deleted_user_attributes = deleted_user_attributes

    @property
    def user_identities(self):
        """
        Gets the user_identities of this Batch.


        :return: The user_identities of this Batch.
        :rtype: UserIdentities
        """
        return self._user_identities

    @user_identities.setter
    def user_identities(self, user_identities):
        """
        Sets the user_identities of this Batch.


        :param user_identities: The user_identities of this Batch.
        :type: UserIdentities
        """

        self._user_identities = user_identities

    @property
    def mpid(self):
        """
            Gets the mpid of this Batch.


            :return: The mpid of this Batch.
            :rtype: str
            """
        return self._mpid

    @mpid.setter
    def mpid(self, mpid):
        """
            Sets the mpid of this Batch.


            :param mpid: The mpid of this Batch.
            :type: str
            """

        self._mpid = mpid

    @property
    def mp_deviceid(self):
        """
            Gets the mp_deviceid of this Batch.


            :return: The mp_deviceid of this Batch.
            :rtype: str
            """
        return self._mp_deviceid

    @mp_deviceid.setter
    def mp_deviceid(self, mp_deviceid):
        """
            Sets the mp_deviceid of this Batch.


            :param mp_deviceid: The mp_deviceid of this Batch.
            :type: str
            """

        self._mp_deviceid = mp_deviceid

    @property
    def consent_state(self):
        """
        Gets the ConsentState of this Batch

        :return: The consent_state of this Batch
        :rtype: dict
        """

        return self._consent_state

    @consent_state.setter
    def consent_state(self, consent_state):
        """
        Sets the consent_state of this Batch.


        :param consent_state: The consent_state of this Batch.
        :type: str
        """

        self._consent_state = consent_state

    @property
    def context(self):
        """
        Gets the BatchContext of this Batch

        :return: The context of this Batch
        :rtype: BatchContext
        """

        return self._context

    @context.setter
    def context(self, context):
        """
        Sets the BatchContext of this Batch.


        :param context: The context of this Batch.
        :type: BatchContext
        """

        self._context = context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
