from gerel.genome.factories import minimal, copy
from gerel.mutators.mutator import Mutator


def curry_genome_seeder(mutator, seed_genomes=None):
    """Construct genome generator.

    Given a mutator and a collection of initial genomes builds a
    function that can then return as many as needed. Used for
    populating Population Objects.

    :param mutator: defined Mutator object that acts on genomes.
    :param seed_genomes: list of genomes that will be copied and mutated.
    :return: Generator function that takes a value n and returns n genomes
      generated by sampling the seed_genome list, copying and mutating.
    :raises ValueError: mutator param must be of type Mutator.
    """
    if not seed_genomes:
        seed_genomes = [minimal()]

    if not issubclass(type(mutator), Mutator):
        raise ValueError('Mutator param must be of type Mutator')

    def genome_seeder(n):
        count = 0
        while count < n:
            for seed_genome in seed_genomes:
                genome = copy(seed_genome)
                mutator(genome)
                yield genome
                count += 1
    return genome_seeder
