# This module defines the entry Click CLI function
# All modules of SuperHelper should define its own group, which can imported by this module.
import sys
import click


# Program entry point
@click.group()
def cli():
    pass


# Console entry call
def main_entry():
    from SuperHelper.Core.Helper.Config import load_app_config, save_app_config
    load_app_config()
    from SuperHelper.Core.Loader import load_installed_modules
    for module in load_installed_modules():
        cli.add_command(module)
    try:
        sys.exit(cli())
    except SystemExit:
        save_app_config()
        raise


if __name__ == '__main__':
    main_entry()
