"""
█▀▄▀█ █▀▀ ▀█▀ █▀▀ █▀█ █▀ ▀█▀ ▄▀█ ▀█▀
█░▀░█ ██▄ ░█░ ██▄ █▄█ ▄█ ░█░ █▀█ ░█░

A Python library for accessing open weather and climate data

Meteorological data provided by Meteostat (https://dev.meteostat.net)
under the terms of the Creative Commons Attribution-NonCommercial
4.0 International Public License.

The code is licensed under the MIT license.
"""

__appname__ = 'meteostat'
__version__ = '1.5.0'

from .interface.base import Base
from .interface.timeseries import Timeseries
from .interface.stations import Stations
from .interface.point import Point
from .interface.hourly import Hourly
from .interface.daily import Daily
from .interface.monthly import Monthly
from .interface.normals import Normals
