---

Thanks for contributing to Nesta's Skills Extractor Library 🙏!

If you have suggested changes to _code_ anywhere outside of the ExtractSkills class, please consult the checklist below.

Checklist ✔️🐍:

- [ ] I have refactored my code out from `notebooks/`
- [ ] I have checked the code runs
- [ ] I have tested the code
- [ ] I have run `pre-commit` and addressed any issues not automatically fixed
- [ ] I have merged any new changes from `dev`
- [ ] I have documented the code
  - [ ] Major functions have docstrings
  - [ ] Appropriate information has been added to `README`s
- [ ] I have explained the feature in this PR or (better) in `output/reports/`
- [ ] I have requested a code review

If you have suggested changes to _documentation_ (and/or the ExtractSkills class), please **ALSO** consult the checklist below.

Documentation Checklist ✔️📚:

- [ ] I have run `make html` in `docs`
- [ ] I have manually reviewed the `docs/build/*.html` files locally to ensure they have formatted correctly
- [ ] I have pushed both relevant files AND their corresponding `docs/build/*.html` files
