import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
import * as cdk from '@aws-cdk/core';
import { DualAlbFargateService, FargateTaskProps, Database } from './';
/**
 * @stability stable
 */
export interface WordPressProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * VPC subnets for database.
     *
     * @default - VPC isolated subnets
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * Database instance type.
     *
     * @default r5.large
     * @stability stable
     */
    readonly databaseInstanceType?: ec2.InstanceType;
    /**
     * The database instance engine.
     *
     * @default - MySQL 8.0.21
     * @stability stable
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine.
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     * @stability stable
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * Whether to use aurora serverless.
     *
     * When enabled, the `databaseInstanceType` and
     * `engine` will be ignored. The `rds.DatabaseClusterEngine.AURORA_MYSQL` will be used as
     * the default cluster engine instead.
     *
     * @default false
     * @stability stable
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster.
     *
     * Not recommended for production.
     *
     * @default false
     * @stability stable
     */
    readonly singleDbInstance?: boolean;
    /**
     * database backup retension.
     *
     * @default - 7 days
     * @stability stable
     */
    readonly backupRetention?: cdk.Duration;
    /**
     * task options for the WordPress fargate service.
     *
     * @stability stable
     */
    readonly serviceProps?: FargateTaskProps;
    /**
     * enable fargate spot.
     *
     * @stability stable
     */
    readonly spot?: boolean;
    /**
     * enable ECS Exec.
     *
     * @stability stable
     */
    readonly enableExecuteCommand?: boolean;
}
/**
 * @stability stable
 */
export declare class WordPress extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly db?: Database;
    /**
     * @stability stable
     */
    readonly svc: DualAlbFargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: WordPressProps);
    private addDatabase;
}
