/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.Arrow;
import ij.gui.ImageRoi;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiBrush;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.MacroRunner;
import ij.measure.ResultsTable;
import ij.plugin.WandToolOptions;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.plugin.tool.PlugInTool;
import ij.process.FloatPolygon;
import ij.util.Tools;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    protected int xMouse;
    protected int yMouse;
    private boolean showCursorStatus = true;
    private int sx2;
    private int sy2;
    private boolean disablePopupMenu;
    private static Color zoomIndicatorColor;
    private static Font smallFont;
    private static Font largeFont;
    private Font font;
    private Rectangle[] labelRects;
    private boolean maxBoundsReset;
    private Overlay overlay;
    private Overlay showAllOverlay;
    private static final int LIST_OFFSET = 100000;
    private static Color showAllColor;
    private Color defaultColor = showAllColor;
    private static Color labelColor;
    private static Color bgColor;
    private int resetMaxBoundsCount;
    private Roi currentRoi;
    private int mousePressedX;
    private int mousePressedY;
    private long mousePressedTime;
    private boolean overOverlayLabel;
    protected static final int MAX_MOUSEMOVE_ZOOM = 10;
    protected int lastZoomSX = -9999999;
    protected int lastZoomSY = -9999999;
    protected int zoomTargetOX = -1;
    protected int zoomTargetOY;
    protected ImageJ ij;
    protected double magnification;
    protected int dstWidth;
    protected int dstHeight;
    protected int xMouseStart;
    protected int yMouseStart;
    protected int xSrcStart;
    protected int ySrcStart;
    protected int flags;
    private Image offScreenImage;
    private int offScreenWidth = 0;
    private int offScreenHeight = 0;
    private boolean mouseExited = true;
    private boolean customRoi;
    private boolean drawNames;
    private AtomicBoolean paintPending;
    private boolean scaleToFit;
    private boolean painted;
    private boolean hideZoomIndicator;
    private boolean flattening;
    long firstFrame;
    int frames;
    int fps;
    private static final double[] zoomLevels;

    public ImageCanvas(ImagePlus imp) {
        this.imp = imp;
        this.paintPending = new AtomicBoolean(false);
        this.ij = IJ.getInstance();
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
    }

    void updateImage(ImagePlus imp) {
        this.imp = imp;
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
    }

    void update(ImageCanvas ic) {
        if (ic == null || ic == this || ic.imp == null) {
            return;
        }
        if (ic.imp.getWidth() != this.imageWidth || ic.imp.getHeight() != this.imageHeight) {
            return;
        }
        this.srcRect = new Rectangle(ic.srcRect.x, ic.srcRect.y, ic.srcRect.width, ic.srcRect.height);
        this.setMagnification(ic.magnification);
        this.setSize(ic.dstWidth, ic.dstHeight);
    }

    public void setSourceRect(Rectangle r) {
        if (r == null) {
            return;
        }
        r = new Rectangle(r.x, r.y, r.width, r.height);
        this.imageWidth = this.imp.getWidth();
        this.imageHeight = this.imp.getHeight();
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.width < 1) {
            r.width = 1;
        }
        if (r.height < 1) {
            r.height = 1;
        }
        if (r.width > this.imageWidth) {
            r.width = this.imageWidth;
        }
        if (r.height > this.imageHeight) {
            r.height = this.imageHeight;
        }
        if (r.x + r.width > this.imageWidth) {
            r.x = this.imageWidth - r.width;
        }
        if (r.y + r.height > this.imageHeight) {
            r.y = this.imageHeight - r.height;
        }
        if (this.srcRect == null) {
            this.srcRect = r;
        } else {
            this.srcRect.x = r.x;
            this.srcRect.y = r.y;
            this.srcRect.width = r.width;
            this.srcRect.height = r.height;
        }
        if (this.dstWidth == 0) {
            Dimension size = this.getSize();
            this.dstWidth = size.width;
            this.dstHeight = size.height;
        }
        this.magnification = (double)this.dstWidth / (double)this.srcRect.width;
        this.imp.setTitle(this.imp.getTitle());
        if (IJ.debugMode) {
            IJ.log("setSourceRect: " + this.magnification + " " + (int)((double)this.srcRect.height * this.magnification + 0.5) + " " + this.dstHeight + " " + this.srcRect);
        }
    }

    void setSrcRect(Rectangle srcRect) {
        this.setSourceRect(srcRect);
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    public void setDrawingSize(int width, int height) {
        this.dstWidth = width;
        this.dstHeight = height;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.dstWidth = width;
        this.dstHeight = height;
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void setPaintPending(boolean state) {
        this.paintPending.set(state);
    }

    public boolean getPaintPending() {
        return this.paintPending.get();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.painted = true;
        Roi roi = this.imp.getRoi();
        if (roi != null || this.overlay != null || this.showAllOverlay != null || Prefs.paintDoubleBuffered || IJ.isLinux() && this.magnification < 0.25) {
            if (roi != null) {
                roi.updatePaste();
            }
            if (this.imageWidth != 0) {
                this.paintDoubleBuffered(g);
                this.setPaintPending(false);
                return;
            }
        }
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            this.setInterpolation(g, Prefs.interpolateScaledImages);
            Image img = this.imp.getImage();
            if (img != null) {
                g.drawImage(img, 0, 0, (int)((double)this.srcRect.width * this.magnification + 0.5), (int)((double)this.srcRect.height * this.magnification + 0.5), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.overlay != null) {
                this.drawOverlay(this.overlay, g);
            }
            if (this.showAllOverlay != null) {
                this.drawOverlay(this.showAllOverlay, g);
            }
            if (roi != null) {
                this.drawRoi(roi, g);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(g);
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Paint");
        }
        this.setPaintPending(false);
    }

    private void setInterpolation(Graphics g, boolean interpolate) {
        if (this.magnification == 1.0) {
            return;
        }
        if (this.magnification < 1.0 || interpolate) {
            Object value = RenderingHints.VALUE_RENDER_QUALITY;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, value);
        } else if (this.magnification > 1.0) {
            Object value = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, value);
        }
    }

    private void drawRoi(Roi roi, Graphics g) {
        if (roi == this.currentRoi) {
            boolean strokeSet;
            Color lineColor = roi.getStrokeColor();
            Color fillColor = roi.getFillColor();
            float lineWidth = roi.getStrokeWidth();
            roi.setStrokeColor(null);
            roi.setFillColor(null);
            boolean bl = strokeSet = roi.getStroke() != null;
            if (strokeSet) {
                roi.setStrokeWidth(1.0f);
            }
            roi.draw(g);
            roi.setStrokeColor(lineColor);
            if (strokeSet) {
                roi.setStrokeWidth(lineWidth);
            }
            roi.setFillColor(fillColor);
            this.currentRoi = null;
        } else {
            roi.draw(g);
        }
    }

    public int getSliceNumber(String label) {
        if (label == null) {
            return 0;
        }
        int slice = 0;
        if (label.length() >= 14 && label.charAt(4) == '-' && label.charAt(9) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 4), 0.0);
        } else if (label.length() >= 17 && label.charAt(5) == '-' && label.charAt(11) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 5), 0.0);
        } else if (label.length() >= 20 && label.charAt(6) == '-' && label.charAt(13) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 6), 0.0);
        }
        return slice;
    }

    private void drawOverlay(Overlay overlay, Graphics g) {
        Roi roi;
        double mag;
        Color labelColor;
        if (this.imp != null && this.imp.getHideOverlay() && overlay != this.showAllOverlay) {
            return;
        }
        boolean bl = this.flattening = this.imp != null && "flatten~canvas".equals(this.imp.getTitle());
        if (this.imp != null && this.showAllOverlay != null && overlay != this.showAllOverlay) {
            overlay.drawLabels(false);
        }
        if ((labelColor = overlay.getLabelColor()) == null) {
            labelColor = Color.white;
        }
        this.initGraphics(overlay, g, labelColor, Roi.getColor());
        int n = overlay.size();
        int currentImage = this.imp != null ? this.imp.getCurrentSlice() : -1;
        int stackSize = this.imp.getStackSize();
        if (stackSize == 1) {
            currentImage = -1;
        }
        int channel = 0;
        int slice = 0;
        int frame = 0;
        boolean hyperstack = this.imp.isHyperStack();
        if (hyperstack) {
            channel = this.imp.getChannel();
            slice = this.imp.getSlice();
            frame = this.imp.getFrame();
        }
        this.drawNames = overlay.getDrawNames() && overlay.getDrawLabels();
        boolean drawLabels = this.drawNames || overlay.getDrawLabels();
        this.labelRects = drawLabels ? new Rectangle[n] : null;
        this.font = overlay.getLabelFont();
        if (overlay.scalableLabels() && this.font != null && (mag = this.getMagnification()) != 1.0) {
            this.font = this.font.deriveFont((float)((double)this.font.getSize() * mag));
        }
        Roi activeRoi = this.imp.getRoi();
        boolean roiManagerShowAllMode = overlay == this.showAllOverlay && !Prefs.showAllSliceOnly;
        for (int i = 0; i < n && overlay != null && (roi = overlay.get(i)) != null; ++i) {
            int position;
            if (hyperstack) {
                int c = roi.getCPosition();
                int z = roi.getZPosition();
                int t = roi.getTPosition();
                int position2 = roi.getPosition();
                if (position2 > 0) {
                    if (z == 0 && this.imp.getNSlices() > 1) {
                        z = position2;
                    } else if (t == 0) {
                        t = position2;
                    }
                }
                if ((c != 0 && c != channel || z != 0 && z != slice || t != 0 && t != frame) && !roiManagerShowAllMode) continue;
                this.drawRoi(g, roi, drawLabels ? i + 100000 : -1);
                continue;
            }
            int n2 = position = stackSize > 1 ? roi.getPosition() : 0;
            if (position == 0 && stackSize > 1) {
                position = this.getSliceNumber(roi.getName());
            }
            if (position > 0 && this.imp.getCompositeMode() == 1) {
                position = 0;
            }
            if (position != 0 && position != currentImage && !roiManagerShowAllMode) continue;
            this.drawRoi(g, roi, drawLabels ? i + 100000 : -1);
        }
        ((Graphics2D)g).setStroke(Roi.onePixelWide);
        this.drawNames = false;
        this.font = null;
    }

    void drawOverlay(Graphics g) {
        this.drawOverlay(this.overlay, g);
    }

    private void initGraphics(Overlay overlay, Graphics g, Color textColor, Color defaultColor) {
        Font font;
        if (smallFont == null) {
            smallFont = new Font("SansSerif", 0, 9);
            largeFont = ImageJ.SansSerif12;
        }
        if (textColor != null) {
            labelColor = textColor;
            if (overlay != null && overlay.getDrawBackgrounds()) {
                double brightness = (double)(labelColor.getRed() + labelColor.getGreen() + labelColor.getBlue()) / 3.0;
                if (labelColor == Color.green) {
                    brightness = 255.0;
                }
                bgColor = brightness <= 85.0 ? Color.white : Color.black;
            } else {
                bgColor = null;
            }
        } else {
            int blue;
            int green;
            int red = defaultColor.getRed();
            labelColor = (red + (green = defaultColor.getGreen()) + (blue = defaultColor.getBlue())) / 3 < 128 ? Color.white : Color.black;
            bgColor = defaultColor;
        }
        this.defaultColor = defaultColor;
        Font font2 = font = overlay != null ? overlay.getLabelFont() : null;
        if (font != null && font.getSize() > 12) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(defaultColor);
    }

    void drawRoi(Graphics g, Roi roi, int index) {
        ImagePlus imp2 = roi.getImage();
        roi.setImage(this.imp);
        Color saveColor = roi.getStrokeColor();
        if (saveColor == null) {
            roi.setStrokeColor(this.defaultColor);
        }
        if (roi.getStroke() == null) {
            ((Graphics2D)g).setStroke(Roi.onePixelWide);
        }
        if (roi instanceof TextRoi) {
            ((TextRoi)roi).drawText(g);
        } else {
            roi.drawOverlay(g);
        }
        roi.setStrokeColor(saveColor);
        if (index >= 0) {
            if (roi == this.currentRoi) {
                g.setColor(Roi.getColor());
            } else {
                g.setColor(this.defaultColor);
            }
            this.drawRoiLabel(g, index, roi);
        }
        if (imp2 != null) {
            roi.setImage(imp2);
        } else {
            roi.setImage(null);
        }
    }

    void drawRoiLabel(Graphics g, int index, Roi roi) {
        boolean drawingList;
        if (roi.isCursor()) {
            return;
        }
        boolean pointRoi = roi instanceof PointRoi;
        Rectangle r = roi.getBounds();
        int x = this.screenX(r.x);
        int y = this.screenY(r.y);
        double mag = this.getMagnification();
        int width = (int)((double)r.width * mag);
        int height = (int)((double)r.height * mag);
        int size = width > 40 || height > 40 ? 12 : 9;
        int pointSize = 0;
        int crossSize = 0;
        if (pointRoi) {
            pointSize = ((PointRoi)roi).getSize();
            switch (pointSize) {
                case 0: 
                case 1: {
                    size = 9;
                    break;
                }
                case 2: 
                case 3: {
                    size = 10;
                    break;
                }
                case 4: {
                    size = 12;
                }
            }
            crossSize = pointSize + 10 + 2 * pointSize;
        }
        if (this.font != null) {
            g.setFont(this.font);
            size = this.font.getSize();
        } else if (size == 12) {
            g.setFont(largeFont);
        } else {
            g.setFont(smallFont);
        }
        boolean bl = drawingList = index >= 100000;
        if (drawingList) {
            index -= 100000;
        }
        String label = "" + (index + 1);
        if (this.drawNames) {
            label = roi.getName();
        }
        if (label == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int w = metrics.stringWidth(label);
        x = x + width / 2 - w / 2;
        y = y + height / 2 + Math.max(size / 2, 6);
        int h = metrics.getAscent() + metrics.getDescent();
        int xoffset = 0;
        int yoffset = 0;
        if (pointRoi) {
            xoffset = 6 + pointSize;
            yoffset = h - 6 + pointSize;
        }
        if (bgColor != null) {
            int h2 = h;
            if (this.font != null && this.font.getSize() > 14) {
                h2 = (int)((double)h2 * 0.8);
            }
            g.setColor(bgColor);
            g.fillRoundRect(x - 1 + xoffset, y - h2 + 2 + yoffset, w + 1, h2 - 2, 5, 5);
        }
        if (this.labelRects != null && index < this.labelRects.length) {
            if (pointRoi) {
                int x2 = this.screenX(r.x);
                int y2 = this.screenY(r.y);
                int crossSize2 = crossSize / 2;
                this.labelRects[index] = new Rectangle(x2 - crossSize2, y2 - crossSize2, crossSize, crossSize);
            } else {
                this.labelRects[index] = new Rectangle(x - 3, y - h + 1, w + 4, h);
            }
        }
        g.setColor(labelColor);
        g.drawString(label, x + xoffset, y - 2 + yoffset);
        g.setColor(this.defaultColor);
    }

    void drawZoomIndicator(Graphics g) {
        if (this.hideZoomIndicator) {
            return;
        }
        int x1 = 10;
        int y1 = 10;
        double aspectRatio = (double)this.imageHeight / (double)this.imageWidth;
        int w1 = 64;
        if (aspectRatio > 1.0) {
            w1 = (int)((double)w1 / aspectRatio);
        }
        int h1 = (int)((double)w1 * aspectRatio);
        if (w1 < 4) {
            w1 = 4;
        }
        if (h1 < 4) {
            h1 = 4;
        }
        int w2 = (int)((double)w1 * ((double)this.srcRect.width / (double)this.imageWidth));
        int h2 = (int)((double)h1 * ((double)this.srcRect.height / (double)this.imageHeight));
        if (w2 < 1) {
            w2 = 1;
        }
        if (h2 < 1) {
            h2 = 1;
        }
        int x2 = (int)((double)w1 * ((double)this.srcRect.x / (double)this.imageWidth));
        int y2 = (int)((double)h1 * ((double)this.srcRect.y / (double)this.imageHeight));
        if (zoomIndicatorColor == null) {
            zoomIndicatorColor = new Color(128, 128, 255);
        }
        g.setColor(zoomIndicatorColor);
        ((Graphics2D)g).setStroke(Roi.onePixelWide);
        g.drawRect(x1, y1, w1, h1);
        if (w2 * h2 <= 200 || w2 < 10 || h2 < 10) {
            g.fillRect(x1 + x2, y1 + y2, w2, h2);
        } else {
            g.drawRect(x1 + x2, y1 + y2, w2, h2);
        }
    }

    void paintDoubleBuffered(Graphics g) {
        int srcRectWidthMag = (int)((double)this.srcRect.width * this.magnification + 0.5);
        int srcRectHeightMag = (int)((double)this.srcRect.height * this.magnification + 0.5);
        if (this.offScreenImage == null || this.offScreenWidth != srcRectWidthMag || this.offScreenHeight != srcRectHeightMag) {
            this.offScreenImage = this.createImage(srcRectWidthMag, srcRectHeightMag);
            this.offScreenWidth = srcRectWidthMag;
            this.offScreenHeight = srcRectHeightMag;
        }
        Roi roi = this.imp.getRoi();
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Graphics offScreenGraphics = this.offScreenImage.getGraphics();
            this.setInterpolation(offScreenGraphics, Prefs.interpolateScaledImages);
            Image img = this.imp.getImage();
            if (img != null) {
                offScreenGraphics.drawImage(img, 0, 0, srcRectWidthMag, srcRectHeightMag, this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.overlay != null) {
                this.drawOverlay(this.overlay, offScreenGraphics);
            }
            if (this.showAllOverlay != null) {
                this.drawOverlay(this.showAllOverlay, offScreenGraphics);
            }
            if (roi != null) {
                this.drawRoi(roi, offScreenGraphics);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(offScreenGraphics);
            }
            g.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("Paint");
        }
    }

    public void resetDoubleBuffer() {
        this.offScreenImage = null;
    }

    void showFrameRate(Graphics g) {
        ++this.frames;
        if (System.currentTimeMillis() > this.firstFrame + 1000L) {
            this.firstFrame = System.currentTimeMillis();
            this.fps = this.frames;
            this.frames = 0;
        }
        g.setColor(Color.white);
        g.fillRect(10, 12, 50, 15);
        g.setColor(Color.black);
        g.drawString((int)((double)this.fps + 0.5) + " fps", 10, 25);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public boolean cursorOverImage() {
        return !this.mouseExited;
    }

    public int getModifiers() {
        return this.flags;
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCursor(int sx, int sy, int ox, int oy) {
        block19: {
            block18: {
                Roi roi;
                block16: {
                    block17: {
                        boolean arrowTool;
                        this.xMouse = ox;
                        this.yMouse = oy;
                        this.mouseExited = false;
                        roi = this.imp.getRoi();
                        ImageWindow win = this.imp.getWindow();
                        this.overOverlayLabel = false;
                        if (win == null) {
                            return;
                        }
                        if (IJ.spaceBarDown()) {
                            this.setCursor(handCursor);
                            return;
                        }
                        int id = Toolbar.getToolId();
                        switch (id) {
                            case 11: {
                                this.setCursor(moveCursor);
                                return;
                            }
                            case 12: {
                                this.setCursor(handCursor);
                                return;
                            }
                        }
                        PlugInTool tool = Toolbar.getPlugInTool();
                        boolean bl = arrowTool = roi != null && roi instanceof Arrow && tool != null && "Arrow Tool".equals(tool.getToolName());
                        if (id >= 15 && !arrowTool) {
                            if (Prefs.usePointerCursor) {
                                this.setCursor(defaultCursor);
                                return;
                            }
                            this.setCursor(crosshairCursor);
                            return;
                        }
                        if (roi != null) {
                            if (roi.getState() != 0 && roi.isHandle(sx, sy) >= 0) {
                                this.setCursor(handCursor);
                                return;
                            }
                        }
                        if (this.overlay == null && this.showAllOverlay == null || !this.overOverlayLabel(sx, sy, ox, oy)) break block16;
                        if (roi == null) break block17;
                        if (roi.getState() == 0) break block16;
                    }
                    this.overOverlayLabel = true;
                    this.setCursor(handCursor);
                    return;
                }
                if (Prefs.usePointerCursor) break block18;
                if (roi == null) break block19;
                if (roi.getState() == 0 || !roi.contains(ox, oy)) break block19;
            }
            this.setCursor(defaultCursor);
            return;
        }
        this.setCursor(crosshairCursor);
    }

    private boolean overOverlayLabel(int sx, int sy, int ox, int oy) {
        Overlay o = this.showAllOverlay;
        if (o == null) {
            o = this.overlay;
        }
        if (o == null || !o.isSelectable() || !o.getDrawLabels() || this.labelRects == null) {
            return false;
        }
        for (int i = o.size() - 1; i >= 0; --i) {
            if (this.labelRects == null || this.labelRects[i] == null || !this.labelRects[i].contains(sx, sy)) continue;
            Roi roi = this.imp.getRoi();
            return roi == null || !roi.contains(ox, oy);
        }
        return false;
    }

    public int offScreenX(int sx) {
        return this.srcRect.x + (int)((double)sx / this.magnification);
    }

    public int offScreenY(int sy) {
        return this.srcRect.y + (int)((double)sy / this.magnification);
    }

    public int offScreenX2(int sx) {
        return this.srcRect.x + (int)Math.round((double)sx / this.magnification);
    }

    public int offScreenY2(int sy) {
        return this.srcRect.y + (int)Math.round((double)sy / this.magnification);
    }

    public double offScreenXD(int sx) {
        return (double)this.srcRect.x + (double)sx / this.magnification;
    }

    public double offScreenYD(int sy) {
        return (double)this.srcRect.y + (double)sy / this.magnification;
    }

    public int screenX(int ox) {
        return (int)((double)(ox - this.srcRect.x) * this.magnification);
    }

    public int screenY(int oy) {
        return (int)((double)(oy - this.srcRect.y) * this.magnification);
    }

    public int screenXD(double ox) {
        return (int)((ox - (double)this.srcRect.x) * this.magnification);
    }

    public int screenYD(double oy) {
        return (int)((oy - (double)this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.setMagnification2(magnification);
    }

    void setMagnification2(double magnification) {
        if (magnification > 32.0) {
            magnification = 32.0;
        }
        if (magnification < zoomLevels[0]) {
            magnification = zoomLevels[0];
        }
        this.magnification = magnification;
        this.imp.setTitle(this.imp.getTitle());
    }

    void resizeCanvas(int width, int height) {
        ImageWindow win = this.imp.getWindow();
        if (!(this.maxBoundsReset || width <= this.dstWidth && height <= this.dstHeight || win == null || win.maxBounds == null || width == win.maxBounds.width - 10)) {
            if (this.resetMaxBoundsCount != 0) {
                this.resetMaxBounds();
            }
            ++this.resetMaxBoundsCount;
        }
        if (this.scaleToFit || IJ.altKeyDown()) {
            this.fitToWindow();
            return;
        }
        if ((double)width > (double)this.imageWidth * this.magnification) {
            width = (int)((double)this.imageWidth * this.magnification);
        }
        if ((double)height > (double)this.imageHeight * this.magnification) {
            height = (int)((double)this.imageHeight * this.magnification);
        }
        Dimension size = this.getSize();
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight || this.painted && (width != size.width || height != size.height)) {
            this.setSize(width, height);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    public void fitToWindow() {
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return;
        }
        Rectangle bounds = win.getBounds();
        Insets insets = win.getInsets();
        int sliderHeight = win.getSliderHeight();
        double xmag = (double)(bounds.width - (insets.left + insets.right + 10)) / (double)this.srcRect.width;
        double ymag = (double)(bounds.height - (10 + insets.top + insets.bottom + sliderHeight)) / (double)this.srcRect.height;
        this.setMagnification(Math.min(xmag, ymag));
        int width = (int)((double)this.imageWidth * this.magnification);
        int height = (int)((double)this.imageHeight * this.magnification);
        if (width == this.dstWidth && height == this.dstHeight) {
            return;
        }
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setSize(width, height);
        this.getParent().doLayout();
    }

    void setMaxBounds() {
        if (this.maxBoundsReset) {
            this.maxBoundsReset = false;
            ImageWindow win = this.imp.getWindow();
            if (win != null && !IJ.isLinux() && win.maxBounds != null) {
                win.setMaximizedBounds(win.maxBounds);
                win.setMaxBoundsTime = System.currentTimeMillis();
            }
        }
    }

    void resetMaxBounds() {
        ImageWindow win = this.imp.getWindow();
        if (win != null && System.currentTimeMillis() - win.setMaxBoundsTime > 500L) {
            win.setMaximizedBounds(win.maxWindowBounds);
            this.maxBoundsReset = true;
        }
    }

    public static double getLowerZoomLevel(double currentMag) {
        double newMag = zoomLevels[0];
        for (int i = 0; i < zoomLevels.length && zoomLevels[i] < currentMag; ++i) {
            newMag = zoomLevels[i];
        }
        return newMag;
    }

    public static double getHigherZoomLevel(double currentMag) {
        double newMag = 32.0;
        for (int i = zoomLevels.length - 1; i >= 0 && zoomLevels[i] > currentMag; --i) {
            newMag = zoomLevels[i];
        }
        return newMag;
    }

    public void zoomIn(int sx, int sy) {
        int newHeight;
        double newMag;
        int newWidth;
        Dimension newSize;
        if (this.magnification >= 32.0) {
            return;
        }
        this.scaleToFit = false;
        boolean mouseMoved = this.sqr(sx - this.lastZoomSX) + this.sqr(sy - this.lastZoomSY) > 100;
        this.lastZoomSX = sx;
        this.lastZoomSY = sy;
        if (mouseMoved || this.zoomTargetOX < 0) {
            boolean cursorInside = sx >= 0 && sy >= 0 && sx < this.dstWidth && sy < this.dstHeight;
            this.zoomTargetOX = this.offScreenX(cursorInside ? sx : this.dstWidth / 2);
            this.zoomTargetOY = this.offScreenY(cursorInside ? sy : this.dstHeight / 2);
        }
        if ((newSize = this.canEnlarge(newWidth = (int)((double)this.imageWidth * (newMag = ImageCanvas.getHigherZoomLevel(this.magnification))), newHeight = (int)((double)this.imageHeight * newMag))) != null) {
            this.setSize(newSize.width, newSize.height);
            if (newSize.width != newWidth || newSize.height != newHeight) {
                this.adjustSourceRect(newMag, this.zoomTargetOX, this.zoomTargetOY);
            } else {
                this.setMagnification(newMag);
            }
            this.imp.getWindow().pack();
        } else {
            this.adjustSourceRect(newMag, this.zoomTargetOX, this.zoomTargetOY);
        }
        this.repaint();
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            this.resetMaxBounds();
        }
    }

    void adjustSourceRect(double newMag, int x, int y) {
        int h;
        int w = (int)Math.round((double)this.dstWidth / newMag);
        if ((double)w * newMag < (double)this.dstWidth) {
            ++w;
        }
        if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
            ++h;
        }
        Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.x + w > this.imageWidth) {
            r.x = this.imageWidth - w;
        }
        if (r.y + h > this.imageHeight) {
            r.y = this.imageHeight - h;
        }
        this.srcRect = r;
        this.setMagnification(newMag);
    }

    protected Dimension canEnlarge(int newWidth, int newHeight) {
        boolean fitsVertically;
        if (IJ.altKeyDown()) {
            return null;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return null;
        }
        Rectangle r1 = win.getBounds();
        Insets insets = win.getInsets();
        Point loc = this.getLocation();
        if (loc.x > insets.left + 5 || loc.y > insets.top + 5) {
            r1.width = newWidth + insets.left + insets.right + 10;
            r1.height = newHeight + insets.top + insets.bottom + 10 + win.getSliderHeight();
        } else {
            r1.width = r1.width - this.dstWidth + newWidth;
            r1.height = r1.height - this.dstHeight + newHeight;
        }
        Rectangle max = win.getMaxWindow(r1.x, r1.y);
        boolean fitsHorizontally = r1.x + r1.width < max.x + max.width;
        boolean bl = fitsVertically = r1.y + r1.height < max.y + max.height;
        if (fitsHorizontally && fitsVertically) {
            return new Dimension(newWidth, newHeight);
        }
        if (fitsVertically && newHeight < this.dstWidth) {
            return new Dimension(this.dstWidth, newHeight);
        }
        if (fitsHorizontally && newWidth < this.dstHeight) {
            return new Dimension(newWidth, this.dstHeight);
        }
        return null;
    }

    public void zoomOut(int sx, int sy) {
        if (this.magnification <= zoomLevels[0]) {
            return;
        }
        boolean mouseMoved = this.sqr(sx - this.lastZoomSX) + this.sqr(sy - this.lastZoomSY) > 100;
        this.lastZoomSX = sx;
        this.lastZoomSY = sy;
        if (mouseMoved || this.zoomTargetOX < 0) {
            boolean cursorInside = sx >= 0 && sy >= 0 && sx < this.dstWidth && sy < this.dstHeight;
            this.zoomTargetOX = this.offScreenX(cursorInside ? sx : this.dstWidth / 2);
            this.zoomTargetOY = this.offScreenY(cursorInside ? sy : this.dstHeight / 2);
        }
        double oldMag = this.magnification;
        double newMag = ImageCanvas.getLowerZoomLevel(this.magnification);
        double srcRatio = (double)this.srcRect.width / (double)this.srcRect.height;
        double imageRatio = (double)this.imageWidth / (double)this.imageHeight;
        double initialMag = this.imp.getWindow().getInitialMagnification();
        if (Math.abs(srcRatio - imageRatio) > 0.05) {
            double scale = oldMag / newMag;
            int newSrcWidth = (int)Math.round((double)this.srcRect.width * scale);
            int newSrcHeight = (int)Math.round((double)this.srcRect.height * scale);
            if (newSrcWidth > this.imageWidth) {
                newSrcWidth = this.imageWidth;
            }
            if (newSrcHeight > this.imageHeight) {
                newSrcHeight = this.imageHeight;
            }
            int newSrcX = this.srcRect.x - (newSrcWidth - this.srcRect.width) / 2;
            int newSrcY = this.srcRect.y - (newSrcHeight - this.srcRect.height) / 2;
            if (newSrcX + newSrcWidth > this.imageWidth) {
                newSrcX = this.imageWidth - newSrcWidth;
            }
            if (newSrcY + newSrcHeight > this.imageHeight) {
                newSrcY = this.imageHeight - newSrcHeight;
            }
            if (newSrcX < 0) {
                newSrcX = 0;
            }
            if (newSrcY < 0) {
                newSrcY = 0;
            }
            this.srcRect = new Rectangle(newSrcX, newSrcY, newSrcWidth, newSrcHeight);
            int newDstWidth = (int)((double)this.srcRect.width * newMag);
            int newDstHeight = (int)((double)this.srcRect.height * newMag);
            this.setMagnification(newMag);
            this.setMaxBounds();
            if (newDstWidth < this.dstWidth || newDstHeight < this.dstHeight) {
                this.setSize(newDstWidth, newDstHeight);
                this.imp.getWindow().pack();
            } else {
                this.repaint();
            }
            return;
        }
        if ((double)this.imageWidth * newMag > (double)this.dstWidth) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            Rectangle r = new Rectangle(this.zoomTargetOX - w / 2, this.zoomTargetOY - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
            this.setMagnification(newMag);
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setSize((int)((double)this.imageWidth * newMag), (int)((double)this.imageHeight * newMag));
            this.setMagnification(newMag);
            this.imp.getWindow().pack();
        }
        this.setMaxBounds();
        this.repaint();
    }

    int sqr(int x) {
        return x * x;
    }

    public void unzoom() {
        double imag = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == imag) {
            return;
        }
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow win = this.imp.getWindow();
        this.setSize((int)((double)this.imageWidth * imag), (int)((double)this.imageHeight * imag));
        this.setMagnification(imag);
        this.setMaxBounds();
        win.pack();
        this.setMaxBounds();
        this.repaint();
    }

    public void zoom100Percent() {
        if (this.magnification == 1.0) {
            return;
        }
        double imag = this.imp.getWindow().getInitialMagnification();
        if (this.magnification != imag) {
            this.unzoom();
        }
        if (this.magnification == 1.0) {
            return;
        }
        if (this.magnification < 1.0) {
            while (this.magnification < 1.0) {
                this.zoomIn(this.imageWidth / 2, this.imageHeight / 2);
            }
        } else if (this.magnification > 1.0) {
            while (this.magnification > 1.0) {
                this.zoomOut(this.imageWidth / 2, this.imageHeight / 2);
            }
        } else {
            return;
        }
        int x = this.xMouse;
        int y = this.yMouse;
        if (this.mouseExited) {
            x = this.imageWidth / 2;
            y = this.imageHeight / 2;
        }
        int sx = this.screenX(x);
        int sy = this.screenY(y);
        this.adjustSourceRect(1.0, sx, sy);
        this.repaint();
    }

    protected void scroll(int sx, int sy) {
        int ox = this.xSrcStart + (int)((double)sx / this.magnification);
        int oy = this.ySrcStart + (int)((double)sy / this.magnification);
        int newx = this.xSrcStart + (this.xMouseStart - ox);
        int newy = this.ySrcStart + (this.yMouseStart - oy);
        if (newx < 0) {
            newx = 0;
        }
        if (newy < 0) {
            newy = 0;
        }
        if (newx + this.srcRect.width > this.imageWidth) {
            newx = this.imageWidth - this.srcRect.width;
        }
        if (newy + this.srcRect.height > this.imageHeight) {
            newy = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = newx;
        this.srcRect.y = newy;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int index) {
        IndexColorModel cm = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(cm.getRGB(index));
    }

    public void setDrawingColor(int ox, int oy, boolean setBackground) {
        Color c;
        int type = this.imp.getType();
        int[] v = this.imp.getPixel(ox, oy);
        switch (type) {
            case 0: {
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(v[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(v[0]));
                break;
            }
            case 1: 
            case 2: {
                double min = this.imp.getProcessor().getMin();
                double max = this.imp.getProcessor().getMax();
                double value = type == 2 ? (double)Float.intBitsToFloat(v[0]) : (double)v[0];
                int index = (int)(255.0 * ((value - min) / (max - min)));
                if (index < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(index));
                    break;
                }
                this.setForegroundColor(this.getColor(index));
                break;
            }
            case 3: 
            case 4: {
                Color c2 = new Color(v[0], v[1], v[2]);
                if (setBackground) {
                    this.setBackgroundColor(c2);
                    break;
                }
                this.setForegroundColor(c2);
                break;
            }
        }
        if (setBackground) {
            c = Toolbar.getBackgroundColor();
        } else {
            c = Toolbar.getForegroundColor();
            this.imp.setColor(c);
        }
        IJ.showStatus("(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ")");
    }

    private void setForegroundColor(Color c) {
        Toolbar.setForegroundColor(c);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    private void setBackgroundColor(Color c) {
        Toolbar.setBackgroundColor(c);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showCursorStatus = true;
        int toolID = Toolbar.getToolId();
        ImageWindow win = this.imp.getWindow();
        if (win != null && win.running2 && toolID != 11) {
            if (win instanceof StackWindow) {
                ((StackWindow)win).setAnimate(false);
            } else {
                win.running2 = false;
            }
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.flags = e.getModifiers();
        if (toolID != 11 && (e.isPopupTrigger() || !IJ.isMacintosh() && (this.flags & 4) != 0)) {
            this.handlePopupMenu(e);
            return;
        }
        int ox = this.offScreenX(x);
        int oy = this.offScreenY(y);
        this.xMouse = ox;
        this.yMouse = oy;
        if (IJ.spaceBarDown()) {
            this.setupScroll(ox, oy);
            return;
        }
        if (this.overOverlayLabel && (this.overlay != null || this.showAllOverlay != null) && this.activateOverlayRoi(ox, oy)) {
            return;
        }
        this.mousePressedX = ox;
        this.mousePressedY = oy;
        this.mousePressedTime = System.currentTimeMillis();
        PlugInTool tool = Toolbar.getPlugInTool();
        if (tool != null) {
            tool.mousePressed(this.imp, e);
            if (e.isConsumed()) {
                return;
            }
        }
        if (this.customRoi && this.overlay != null) {
            return;
        }
        if (toolID >= 15) {
            if (tool != null && "Arrow Tool".equals(tool.getToolName())) {
                this.handleRoiMouseDown(e);
            } else {
                Toolbar.getInstance().runMacroTool(toolID);
            }
            return;
        }
        switch (toolID) {
            case 11: {
                if (IJ.shiftKeyDown()) {
                    this.zoomToSelection(ox, oy);
                    break;
                }
                if ((this.flags & 0xE) != 0) {
                    this.zoomOut(x, y);
                    if (!(this.getMagnification() < 1.0)) break;
                    this.imp.repaintWindow();
                    break;
                }
                this.zoomIn(x, y);
                if (!(this.getMagnification() <= 1.0)) break;
                this.imp.repaintWindow();
                break;
            }
            case 12: {
                this.setupScroll(ox, oy);
                break;
            }
            case 13: {
                this.setDrawingColor(ox, oy, IJ.altKeyDown());
                break;
            }
            case 8: {
                int handle;
                double tolerance = WandToolOptions.getTolerance();
                Roi roi = this.imp.getRoi();
                if (roi != null && (tolerance == 0.0 || this.imp.isThreshold()) && roi.contains(ox, oy)) {
                    Rectangle r = roi.getBounds();
                    if (r.width == this.imageWidth && r.height == this.imageHeight) {
                        this.imp.deleteRoi();
                    } else if (!e.isAltDown()) {
                        this.handleRoiMouseDown(e);
                        return;
                    }
                }
                if (roi != null && (handle = roi.isHandle(x, y)) >= 0) {
                    roi.mouseDownInHandle(handle, x, y);
                    return;
                }
                this.setRoiModState(e, roi, -1);
                String mode = WandToolOptions.getMode();
                if (Prefs.smoothWand) {
                    mode = mode + " smooth";
                }
                int npoints = IJ.doWand(ox, oy, tolerance, mode);
                if (!Recorder.record || npoints <= 0) break;
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.doWand(imp, " + ox + ", " + oy + ", " + tolerance + ", \"" + mode + "\");");
                    break;
                }
                if (tolerance == 0.0 && mode.equals("Legacy")) {
                    Recorder.record("doWand", ox, oy);
                    break;
                }
                Recorder.recordString("doWand(" + ox + ", " + oy + ", " + tolerance + ", \"" + mode + "\");\n");
                break;
            }
            case 1: {
                if (Toolbar.getBrushSize() > 0) {
                    new RoiBrush();
                    break;
                }
                this.handleRoiMouseDown(e);
                break;
            }
            default: {
                this.handleRoiMouseDown(e);
            }
        }
    }

    private boolean drawingTool() {
        return Toolbar.getToolName().equals("Paintbrush Tool") || Toolbar.getToolName().equals("Pencil Tool");
    }

    void zoomToSelection(int x, int y) {
        IJ.setKeyUp(-1);
        String macro = "args = split(getArgument);\nx1=parseInt(args[0]); y1=parseInt(args[1]); flags=20;\nwhile (flags&20!=0) {\ngetCursorLoc(x2, y2, z, flags);\nif (x2>=x1) x=x1; else x=x2;\nif (y2>=y1) y=y1; else y=y2;\nmakeRectangle(x, y, abs(x2-x1), abs(y2-y1));\nwait(10);\n}\nrun('To Selection');\n";
        new MacroRunner(macro, x + " " + y);
    }

    protected void setupScroll(int ox, int oy) {
        this.xMouseStart = ox;
        this.yMouseStart = oy;
        this.xSrcStart = this.srcRect.x;
        this.ySrcStart = this.srcRect.y;
    }

    protected void handlePopupMenu(MouseEvent e) {
        PopupMenu popup;
        if (this.disablePopupMenu) {
            return;
        }
        if (IJ.debugMode) {
            IJ.log("show popup: " + (e.isPopupTrigger() ? "true" : "false"));
        }
        int x = e.getX();
        int y = e.getY();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8)) {
            if (roi.getState() == 0) {
                roi.handleMouseUp(x, y);
                roi.handleMouseUp(x, y);
                return;
            }
        }
        if ((popup = Menus.getPopupMenu()) != null) {
            this.add(popup);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            popup.show(this, x, y);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ImageWindow win;
        PlugInTool tool = Toolbar.getPlugInTool();
        if (tool != null) {
            tool.mouseExited(this.imp, e);
            if (e.isConsumed()) {
                return;
            }
        }
        if ((win = this.imp.getWindow()) != null) {
            this.setCursor(defaultCursor);
        }
        IJ.showStatus("");
        this.mouseExited = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.xMouse = this.offScreenX(x);
        this.yMouse = this.offScreenY(y);
        this.flags = e.getModifiers();
        this.mousePressedY = -1;
        this.mousePressedX = -1;
        if (this.flags == 0) {
            this.flags = 16;
        }
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(x, y);
        } else {
            PlugInTool tool = Toolbar.getPlugInTool();
            if (tool != null) {
                tool.mouseDragged(this.imp, e);
                if (e.isConsumed()) {
                    return;
                }
            }
            IJ.setInputEvent(e);
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(x, y, this.flags);
            }
        }
    }

    protected void handleRoiMouseDown(MouseEvent e) {
        boolean multiPointMode;
        int sx = e.getX();
        int sy = e.getY();
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        Roi roi = this.imp.getRoi();
        int tool = Toolbar.getToolId();
        int handle = roi != null ? roi.isHandle(sx, sy) : -1;
        boolean bl = multiPointMode = roi != null && roi instanceof PointRoi && handle == -1 && tool == 7 && Toolbar.getMultiPointMode();
        if (multiPointMode) {
            double oxd = this.offScreenXD(sx);
            double oyd = this.offScreenYD(sy);
            if (e.isShiftDown() && !IJ.isMacro()) {
                FloatPolygon points = roi.getFloatPolygon();
                if (points.npoints > 0) {
                    double x0 = points.xpoints[0];
                    double y0 = points.ypoints[0];
                    double slope = Math.abs((oxd - x0) / (oyd - y0));
                    if (slope >= 1.0) {
                        oyd = points.ypoints[0];
                    } else {
                        oxd = points.xpoints[0];
                    }
                }
            }
            ((PointRoi)roi).addUserPoint(this.imp, oxd, oyd);
            this.imp.setRoi(roi);
            return;
        }
        if (roi != null && roi instanceof PointRoi && ((PointRoi)roi).promptBeforeDeleting()) {
            String msg;
            int npoints = ((PolygonRoi)roi).getNCoordinates();
            int counters = ((PointRoi)roi).getNCounters();
            if (!(handle != -1 || tool == 7 && !Toolbar.getMultiPointMode() && IJ.shiftKeyDown() || IJ.showMessageWithCancel("Delete Points?", (msg = "Delete this multi-point selection (" + npoints + " points, " + counters + " counter" + (counters > 1 ? "s" : "") + ")?") + "\nRestore using Edit>Selection>Restore Selection."))) {
                return;
            }
        }
        this.setRoiModState(e, roi, handle);
        if (roi != null) {
            if (handle >= 0) {
                roi.mouseDownInHandle(handle, sx, sy);
                return;
            }
            Rectangle r = roi.getBounds();
            int type = roi.getType();
            if (type == 0 && r.width == this.imp.getWidth() && r.height == this.imp.getHeight() && roi.getPasteMode() == -1 && !(roi instanceof ImageRoi)) {
                this.imp.deleteRoi();
                return;
            }
            if (roi.contains(ox, oy)) {
                if (roi.modState == 0) {
                    roi.handleMouseDown(sx, sy);
                } else {
                    this.imp.deleteRoi();
                    this.imp.createNewRoi(sx, sy);
                }
                return;
            }
            if (type == 2 || type == 6 || type == 8) {
                if (roi.getState() == 0) {
                    return;
                }
            }
            if (!(tool != 2 && tool != 5 && tool != 14 || IJ.shiftKeyDown() || IJ.altKeyDown())) {
                this.imp.deleteRoi();
                return;
            }
        }
        this.imp.createNewRoi(sx, sy);
    }

    void setRoiModState(MouseEvent e, Roi roi, int handle) {
        if (roi == null || handle >= 0 && roi.modState == 0) {
            return;
        }
        if (roi.state == 0) {
            return;
        }
        int tool = Toolbar.getToolId();
        if (tool > 3 && tool != 8 && tool != 7) {
            roi.modState = 0;
            return;
        }
        roi.modState = e.isShiftDown() ? 1 : (e.isAltDown() ? 2 : 0);
    }

    public void disablePopupMenu(boolean status) {
        this.disablePopupMenu = status;
    }

    public void setShowAllList(Overlay showAllList) {
        this.showAllOverlay = showAllList;
        this.labelRects = null;
    }

    public Overlay getShowAllList() {
        return this.showAllOverlay;
    }

    public void setShowAllROIs(boolean showAllROIs) {
        RoiManager rm = RoiManager.getInstance();
        if (rm != null) {
            rm.runCommand(showAllROIs ? "show all" : "show none");
        }
    }

    public boolean getShowAllROIs() {
        return this.getShowAllList() != null;
    }

    public static Color getShowAllColor() {
        if (showAllColor != null && showAllColor.getRGB() == -8323073) {
            showAllColor = Color.cyan;
        }
        return showAllColor;
    }

    public static void setShowAllColor(Color c) {
        if (c == null) {
            return;
        }
        showAllColor = c;
        labelColor = null;
    }

    public static void setCursor(Cursor cursor, int type) {
        crosshairCursor = cursor;
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
        this.labelRects = null;
        this.repaint();
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setDisplayList(Vector list) {
        if (list != null) {
            Overlay list2 = new Overlay();
            list2.setVector(list);
            this.setOverlay(list2);
        } else {
            this.setOverlay(null);
        }
        if (this.overlay != null) {
            this.overlay.drawLabels(this.overlay.size() > 0 && this.overlay.get(0).getStrokeColor() == null);
        } else {
            this.customRoi = false;
        }
        this.repaint();
    }

    public void setDisplayList(Shape shape, Color color, BasicStroke stroke) {
        if (shape == null) {
            this.setOverlay(null);
            return;
        }
        ShapeRoi roi = new ShapeRoi(shape);
        roi.setStrokeColor(color);
        roi.setStroke(stroke);
        Overlay list = new Overlay();
        list.add(roi);
        this.setOverlay(list);
    }

    public void setDisplayList(Roi roi, Color color) {
        roi.setStrokeColor(color);
        Overlay list = new Overlay();
        list.add(roi);
        this.setOverlay(list);
    }

    public Vector getDisplayList() {
        if (this.overlay == null) {
            return null;
        }
        Vector<Roi> displayList = new Vector<Roi>();
        for (int i = 0; i < this.overlay.size(); ++i) {
            displayList.add(this.overlay.get(i));
        }
        return displayList;
    }

    public void setCustomRoi(boolean customRoi) {
        this.customRoi = customRoi;
    }

    public boolean getCustomRoi() {
        return this.customRoi;
    }

    public void setShowCursorStatus(boolean status) {
        this.showCursorStatus = status;
        if (status) {
            this.sy2 = -1000;
            this.sx2 = -1000;
        } else {
            this.sx2 = this.screenX(this.xMouse);
            this.sy2 = this.screenY(this.yMouse);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        PlugInTool tool;
        Roi roi;
        int ox = this.offScreenX(e.getX());
        int oy = this.offScreenY(e.getY());
        if ((this.overlay != null || this.showAllOverlay != null) && ox == this.mousePressedX && oy == this.mousePressedY) {
            boolean cmdDown = IJ.isMacOSX() && e.isMetaDown();
            roi = this.imp.getRoi();
            if (roi != null && roi.getBounds().width == 0) {
                roi = null;
            }
            if ((e.isAltDown() || e.isControlDown() || cmdDown) && roi == null ? this.activateOverlayRoi(ox, oy) : System.currentTimeMillis() - this.mousePressedTime > 250L && !this.drawingTool() && this.activateOverlayRoi(ox, oy)) {
                return;
            }
        }
        if ((tool = Toolbar.getPlugInTool()) != null) {
            tool.mouseReleased(this.imp, e);
            if (e.isConsumed()) {
                return;
            }
        }
        this.flags = e.getModifiers();
        this.flags &= 0xFFFFFFEF;
        this.flags &= 0xFFFFFFF7;
        this.flags &= 0xFFFFFFFB;
        roi = this.imp.getRoi();
        if (roi == null) return;
        Rectangle r = roi.getBounds();
        int type = roi.getType();
        if (!(r.width != 0 && r.height != 0 || type == 2 || type == 6 || type == 8 || type == 5 || roi instanceof TextRoi)) {
            if (roi.getState() == 0) {
                if (type != 10) {
                    this.imp.deleteRoi();
                    return;
                }
            }
        }
        roi.handleMouseUp(e.getX(), e.getY());
    }

    private boolean activateOverlayRoi(int ox, int oy) {
        Overlay o;
        int currentImage = -1;
        int stackSize = this.imp.getStackSize();
        if (stackSize > 1) {
            currentImage = this.imp.getCurrentSlice();
        }
        int channel = 0;
        int slice = 0;
        int frame = 0;
        boolean hyperstack = this.imp.isHyperStack();
        if (hyperstack) {
            channel = this.imp.getChannel();
            slice = this.imp.getSlice();
            frame = this.imp.getFrame();
        }
        if ((o = this.showAllOverlay) == null) {
            o = this.overlay;
        }
        if (o == null || !o.isSelectable()) {
            return false;
        }
        boolean roiManagerShowAllMode = o == this.showAllOverlay && !Prefs.showAllSliceOnly;
        boolean labels = o.getDrawLabels();
        int sx = this.screenX(ox);
        int sy = this.screenY(oy);
        for (int i = o.size() - 1; i >= 0; --i) {
            Roi roi = o.get(i);
            if (!roi.contains(ox, oy) && (!labels || this.labelRects == null || this.labelRects[i] == null || !this.labelRects[i].contains(sx, sy))) continue;
            if (hyperstack && roi.getPosition() == 0) {
                int c = roi.getCPosition();
                int z = roi.getZPosition();
                int t = roi.getTPosition();
                if ((c != 0 && c != channel || z != 0 && z != slice || t != 0 && t != frame) && !roiManagerShowAllMode) {
                    continue;
                }
            } else {
                int position;
                int n = position = stackSize > 1 ? roi.getPosition() : 0;
                if (position != 0 && position != currentImage && !roiManagerShowAllMode) continue;
            }
            if (!IJ.altKeyDown() && roi.getType() == 9 && roi.getBounds().width == this.imp.getWidth() && roi.getBounds().height == this.imp.getHeight()) {
                return false;
            }
            if (Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0) {
                Toolbar.getInstance().setTool(0);
            }
            roi.setImage(null);
            this.imp.setRoi(roi);
            roi.handleMouseDown(sx, sy);
            this.roiManagerSelect(roi, false);
            ResultsTable.selectRow(roi);
            return true;
        }
        return false;
    }

    public boolean roiManagerSelect(Roi roi, boolean delete) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return false;
        }
        int index = rm.getRoiIndex(roi);
        if (index < 0) {
            return false;
        }
        if (delete) {
            rm.select(this.imp, index);
            rm.runCommand("delete");
        } else {
            rm.selectAndMakeVisible(this.imp, index);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        int oy;
        int ox;
        int sy;
        int sx;
        block8: {
            Roi roi;
            block9: {
                int type;
                sx = e.getX();
                sy = e.getY();
                ox = this.offScreenX(sx);
                oy = this.offScreenY(sy);
                this.flags = e.getModifiers();
                this.setCursor(sx, sy, ox, oy);
                this.mousePressedY = -1;
                this.mousePressedX = -1;
                IJ.setInputEvent(e);
                PlugInTool tool = Toolbar.getPlugInTool();
                if (tool != null) {
                    tool.mouseMoved(this.imp, e);
                    if (e.isConsumed()) {
                        return;
                    }
                }
                int n = type = (roi = this.imp.getRoi()) != null ? roi.getType() : -1;
                if (type <= 0) break block8;
                if (type == 2 || type == 6 || type == 8) break block9;
                if (type != 5) break block8;
            }
            if (roi.getState() == 0) {
                roi.mouseMoved(e);
                return;
            }
        }
        if (ox < this.imageWidth && oy < this.imageHeight) {
            ImageWindow win = this.imp.getWindow();
            if ((sx - this.sx2) * (sx - this.sx2) + (sy - this.sy2) * (sy - this.sy2) > 144) {
                this.showCursorStatus = true;
            }
            if (win == null) return;
            if (!this.showCursorStatus) return;
            win.mouseMoved(ox, oy);
            return;
        }
        IJ.showStatus("");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        PlugInTool tool = Toolbar.getPlugInTool();
        if (tool != null) {
            tool.mouseEntered(this.imp, e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        PlugInTool tool = Toolbar.getPlugInTool();
        if (tool != null) {
            tool.mouseClicked(this.imp, e);
        }
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    public boolean getScaleToFit() {
        return this.scaleToFit;
    }

    public boolean hideZoomIndicator(boolean hide) {
        boolean hidden = this.hideZoomIndicator;
        if (this.srcRect.width >= this.imageWidth && this.srcRect.height >= this.imageHeight) {
            return hidden;
        }
        this.hideZoomIndicator = hide;
        this.setPaintPending(true);
        this.repaint();
        long t0 = System.currentTimeMillis();
        while (this.getPaintPending() && System.currentTimeMillis() - t0 < 500L) {
            IJ.wait(10);
        }
        return hidden;
    }

    static {
        showAllColor = Prefs.getColor("showcolor", new Color(0, 255, 255));
        zoomLevels = new double[]{0.013888888888888888, 0.020833333333333332, 0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};
    }
}

