/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;

public class GUI {
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    private static Color lightGray = new Color(240, 240, 240);
    private static boolean isWindows8;
    private static Rectangle maxBounds;
    private static Rectangle zeroBasedMaxBounds;
    private static Rectangle unionOfBounds;
    private static Frame frame;

    public static void center(Window win) {
        int top;
        if (win == null) {
            return;
        }
        Rectangle bounds = GUI.getMaxWindowBounds();
        Dimension window = win.getSize();
        if (window.width == 0) {
            return;
        }
        int left = bounds.x + (bounds.width - window.width) / 2;
        if (left < bounds.x) {
            left = bounds.x;
        }
        if ((top = bounds.y + (bounds.height - window.height) / 4) < bounds.y) {
            top = bounds.y;
        }
        win.setLocation(left, top);
    }

    public static Rectangle getMaxWindowBounds() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Rectangle(0, 0, 0, 0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getMaximumWindowBounds();
        if (IJ.isLinux() && unionOfBounds == null) {
            unionOfBounds = GUI.getUnionOfBounds(ge);
        }
        zeroBasedMaxBounds = null;
        if (bounds.x > 300 || bounds.equals(unionOfBounds)) {
            bounds = GUI.getZeroBasedMonitor(ge, bounds);
        }
        if (bounds.x < 0 || bounds.x > 300 || bounds.width < 300) {
            Dimension screen = GUI.getScreenSize();
            bounds = new Rectangle(0, 0, screen.width, screen.height);
        }
        if (IJ.debugMode) {
            IJ.log("GUI.getMaxWindowBounds: " + bounds);
        }
        maxBounds = bounds;
        return bounds;
    }

    public static Rectangle getZeroBasedMaxBounds() {
        if (maxBounds == null) {
            GUI.getMaxWindowBounds();
        }
        return zeroBasedMaxBounds;
    }

    private static Dimension getScreenSize() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        GraphicsConfiguration[] gc = gd[0].getConfigurations();
        Rectangle bounds = gc[0].getBounds();
        if (bounds.x == 0 && bounds.y == 0 || IJ.isLinux() && gc.length > 1) {
            return new Dimension(bounds.width, bounds.height);
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Rectangle getUnionOfBounds() {
        if (unionOfBounds == null) {
            GUI.getMaxWindowBounds();
        }
        return unionOfBounds;
    }

    private static Rectangle getUnionOfBounds(GraphicsEnvironment ge) {
        Rectangle virtualBounds = new Rectangle();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle bounds2 = null;
        int nMonitors = 0;
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle bounds = gc[i].getBounds();
                if (bounds != null && !bounds.equals(bounds2)) {
                    virtualBounds = virtualBounds.union(bounds);
                    ++nMonitors;
                }
                bounds2 = bounds;
            }
        }
        if (nMonitors < 2) {
            virtualBounds = new Rectangle(0, 0, 1, 1);
        }
        if (IJ.debugMode) {
            IJ.log("GUI.getUnionOfBounds: " + nMonitors + " " + virtualBounds);
        }
        return virtualBounds;
    }

    private static Rectangle getZeroBasedMonitor(GraphicsEnvironment ge, Rectangle bounds) {
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle bounds2 = null;
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length && ((bounds2 = gc[i].getBounds()) == null || bounds.x != 0); ++i) {
            }
        }
        if (bounds2 != null) {
            bounds = bounds2;
            zeroBasedMaxBounds = bounds2;
        }
        return bounds;
    }

    public static Image createBlankImage(int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("");
        }
        if (frame == null) {
            frame = new Frame();
            frame.pack();
            frame.setBackground(Color.white);
        }
        Image img = frame.createImage(width, height);
        return img;
    }

    public static void fix(Scrollbar sb) {
    }

    public static boolean showCompositeAdvisory(ImagePlus imp, String title) {
        if (imp == null || imp.getCompositeMode() != 1 || imp.getNChannels() == 1 || IJ.macroRunning()) {
            return true;
        }
        String msg = "Channel " + imp.getC() + " of this color composite image will be processed.";
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static void scale(Component component) {
        float scale = (float)Prefs.getGuiScale();
        if (scale == 1.0f) {
            return;
        }
        if (component instanceof Container) {
            GUI.scaleComponents((Container)component, scale);
        } else {
            GUI.scaleComponent(component, scale);
        }
    }

    private static void scaleComponents(Container container, float scale) {
        for (Component child : container.getComponents()) {
            if (child instanceof Container) {
                GUI.scaleComponents((Container)child, scale);
                continue;
            }
            GUI.scaleComponent(child, scale);
        }
    }

    private static void scaleComponent(Component component, float scale) {
        Font font = component.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        font = font.deriveFont(scale * (float)font.getSize());
        component.setFont(font);
    }

    public static void scalePopupMenu(PopupMenu popup) {
        float scale = (float)Prefs.getGuiScale();
        if (scale == 1.0f) {
            return;
        }
        Font font = popup.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        font = font.deriveFont(scale * (float)font.getSize());
        popup.setFont(font);
    }

    public static boolean scale(JComponent component) {
        double guiScale = Prefs.getGuiScale();
        if (guiScale == 1.0) {
            return false;
        }
        Font font = component.getFont();
        if (font == null && component instanceof JList) {
            font = UIManager.getFont("List.font");
        } else if (font == null && component instanceof JTable) {
            font = UIManager.getFont("Table.font");
        } else if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        if (font.getSize() > DEFAULT_FONT.getSize()) {
            return false;
        }
        if (component instanceof JTable) {
            ((JTable)component).setRowHeight((int)((double)((JTable)component).getRowHeight() * guiScale * 0.9));
        } else if (component instanceof JList) {
            ((JList)component).setFixedCellHeight((int)((double)((JList)component).getFixedCellHeight() * guiScale * 0.9));
        }
        component.setFont(font.deriveFont((float)guiScale * (float)font.getSize()));
        return true;
    }

    static {
        if (IJ.isWindows()) {
            String osname = System.getProperty("os.name");
            isWindows8 = osname.contains("unknown") || osname.contains("8");
        }
    }
}

