/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class MutablePeriod
extends BasePeriod
implements ReadWritablePeriod,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3436451121567212165L;

    @FromString
    public static MutablePeriod parse(String string) {
        return MutablePeriod.parse(string, ISOPeriodFormat.standard());
    }

    public static MutablePeriod parse(String string, PeriodFormatter periodFormatter) {
        return periodFormatter.parsePeriod(string).toMutablePeriod();
    }

    public MutablePeriod() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public MutablePeriod(PeriodType periodType) {
        super(0L, periodType, (Chronology)null);
    }

    public MutablePeriod(int n2, int n3, int n4, int n5) {
        super(0, 0, 0, 0, n2, n3, n4, n5, PeriodType.standard());
    }

    public MutablePeriod(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n2, n3, n4, n5, n6, n7, n8, n9, PeriodType.standard());
    }

    public MutablePeriod(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, PeriodType periodType) {
        super(n2, n3, n4, n5, n6, n7, n8, n9, periodType);
    }

    public MutablePeriod(long l2) {
        super(l2);
    }

    public MutablePeriod(long l2, PeriodType periodType) {
        super(l2, periodType, (Chronology)null);
    }

    public MutablePeriod(long l2, Chronology chronology) {
        super(l2, (PeriodType)null, chronology);
    }

    public MutablePeriod(long l2, PeriodType periodType, Chronology chronology) {
        super(l2, periodType, chronology);
    }

    public MutablePeriod(long l2, long l3) {
        super(l2, l3, null, null);
    }

    public MutablePeriod(long l2, long l3, PeriodType periodType) {
        super(l2, l3, periodType, null);
    }

    public MutablePeriod(long l2, long l3, Chronology chronology) {
        super(l2, l3, null, chronology);
    }

    public MutablePeriod(long l2, long l3, PeriodType periodType, Chronology chronology) {
        super(l2, l3, periodType, chronology);
    }

    public MutablePeriod(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2, null);
    }

    public MutablePeriod(ReadableInstant readableInstant, ReadableInstant readableInstant2, PeriodType periodType) {
        super(readableInstant, readableInstant2, periodType);
    }

    public MutablePeriod(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        super(readableInstant, readableDuration, null);
    }

    public MutablePeriod(ReadableInstant readableInstant, ReadableDuration readableDuration, PeriodType periodType) {
        super(readableInstant, readableDuration, periodType);
    }

    public MutablePeriod(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        super(readableDuration, readableInstant, null);
    }

    public MutablePeriod(ReadableDuration readableDuration, ReadableInstant readableInstant, PeriodType periodType) {
        super(readableDuration, readableInstant, periodType);
    }

    public MutablePeriod(Object object) {
        super(object, null, null);
    }

    public MutablePeriod(Object object, PeriodType periodType) {
        super(object, periodType, null);
    }

    public MutablePeriod(Object object, Chronology chronology) {
        super(object, null, chronology);
    }

    public MutablePeriod(Object object, PeriodType periodType, Chronology chronology) {
        super(object, periodType, chronology);
    }

    public void clear() {
        super.setValues(new int[this.size()]);
    }

    public void setValue(int n2, int n3) {
        super.setValue(n2, n3);
    }

    public void set(DurationFieldType durationFieldType, int n2) {
        super.setField(durationFieldType, n2);
    }

    public void setPeriod(ReadablePeriod readablePeriod) {
        super.setPeriod(readablePeriod);
    }

    public void setPeriod(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super.setPeriod(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void setPeriod(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            this.setPeriod(0L);
        } else {
            Chronology chronology = DateTimeUtils.getChronology(readableInterval.getChronology());
            this.setPeriod(readableInterval.getStartMillis(), readableInterval.getEndMillis(), chronology);
        }
    }

    public void setPeriod(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        if (readableInstant == readableInstant2) {
            this.setPeriod(0L);
        } else {
            long l2 = DateTimeUtils.getInstantMillis(readableInstant);
            long l3 = DateTimeUtils.getInstantMillis(readableInstant2);
            Chronology chronology = DateTimeUtils.getIntervalChronology(readableInstant, readableInstant2);
            this.setPeriod(l2, l3, chronology);
        }
    }

    public void setPeriod(long l2, long l3) {
        this.setPeriod(l2, l3, null);
    }

    public void setPeriod(long l2, long l3, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.setValues(chronology.get(this, l2, l3));
    }

    public void setPeriod(ReadableDuration readableDuration) {
        this.setPeriod(readableDuration, null);
    }

    public void setPeriod(ReadableDuration readableDuration, Chronology chronology) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        this.setPeriod(l2, chronology);
    }

    public void setPeriod(long l2) {
        this.setPeriod(l2, null);
    }

    public void setPeriod(long l2, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.setValues(chronology.get(this, l2));
    }

    public void add(DurationFieldType durationFieldType, int n2) {
        super.addField(durationFieldType, n2);
    }

    public void add(ReadablePeriod readablePeriod) {
        super.addPeriod(readablePeriod);
    }

    public void add(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setPeriod(FieldUtils.safeAdd(this.getYears(), n2), FieldUtils.safeAdd(this.getMonths(), n3), FieldUtils.safeAdd(this.getWeeks(), n4), FieldUtils.safeAdd(this.getDays(), n5), FieldUtils.safeAdd(this.getHours(), n6), FieldUtils.safeAdd(this.getMinutes(), n7), FieldUtils.safeAdd(this.getSeconds(), n8), FieldUtils.safeAdd(this.getMillis(), n9));
    }

    public void add(ReadableInterval readableInterval) {
        if (readableInterval != null) {
            this.add(readableInterval.toPeriod(this.getPeriodType()));
        }
    }

    public void add(ReadableDuration readableDuration) {
        if (readableDuration != null) {
            this.add(new Period(readableDuration.getMillis(), this.getPeriodType()));
        }
    }

    public void add(long l2) {
        this.add(new Period(l2, this.getPeriodType()));
    }

    public void add(long l2, Chronology chronology) {
        this.add(new Period(l2, this.getPeriodType(), chronology));
    }

    public void mergePeriod(ReadablePeriod readablePeriod) {
        super.mergePeriod(readablePeriod);
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    public void setYears(int n2) {
        super.setField(DurationFieldType.years(), n2);
    }

    public void addYears(int n2) {
        super.addField(DurationFieldType.years(), n2);
    }

    public void setMonths(int n2) {
        super.setField(DurationFieldType.months(), n2);
    }

    public void addMonths(int n2) {
        super.addField(DurationFieldType.months(), n2);
    }

    public void setWeeks(int n2) {
        super.setField(DurationFieldType.weeks(), n2);
    }

    public void addWeeks(int n2) {
        super.addField(DurationFieldType.weeks(), n2);
    }

    public void setDays(int n2) {
        super.setField(DurationFieldType.days(), n2);
    }

    public void addDays(int n2) {
        super.addField(DurationFieldType.days(), n2);
    }

    public void setHours(int n2) {
        super.setField(DurationFieldType.hours(), n2);
    }

    public void addHours(int n2) {
        super.addField(DurationFieldType.hours(), n2);
    }

    public void setMinutes(int n2) {
        super.setField(DurationFieldType.minutes(), n2);
    }

    public void addMinutes(int n2) {
        super.addField(DurationFieldType.minutes(), n2);
    }

    public void setSeconds(int n2) {
        super.setField(DurationFieldType.seconds(), n2);
    }

    public void addSeconds(int n2) {
        super.addField(DurationFieldType.seconds(), n2);
    }

    public void setMillis(int n2) {
        super.setField(DurationFieldType.millis(), n2);
    }

    public void addMillis(int n2) {
        super.addField(DurationFieldType.millis(), n2);
    }

    public MutablePeriod copy() {
        return (MutablePeriod)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }
}

