/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.rulefit;

import hex.genmodel.algos.rulefit.MojoRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class MojoRuleEnsemble
implements Serializable {
    MojoRule[][][] _orderedRules;

    public MojoRuleEnsemble(MojoRule[][][] orderedRules) {
        this._orderedRules = orderedRules;
    }

    public double[] transformRow(double[] row, int depth, int ntrees, String[] linearModelNames, String[][] linearModelDomains, String[] classes) {
        boolean isMultinomial = classes != null && classes.length > 2;
        double[] transformedRow = isMultinomial ? new double[depth * ntrees * classes.length] : new double[depth * ntrees];
        for (int i2 = 0; i2 < depth; ++i2) {
            for (int j2 = 0; j2 < ntrees; ++j2) {
                MojoRule[] filteredOrderedRules = this._orderedRules[i2][j2];
                if (isMultinomial) {
                    int k2;
                    ArrayList[] classRules = new ArrayList[classes.length];
                    for (k2 = 0; k2 < filteredOrderedRules.length; ++k2) {
                        for (int l2 = 0; l2 < classes.length; ++l2) {
                            if (!filteredOrderedRules[k2]._varName.endsWith(classes[l2])) continue;
                            if (classRules[l2] == null) {
                                classRules[l2] = new ArrayList();
                            }
                            classRules[l2].add(filteredOrderedRules[k2]);
                        }
                    }
                    for (k2 = 0; k2 < classes.length; ++k2) {
                        transformedRow[i2 * ntrees * classes.length + j2 * classes.length + k2] = MojoRuleEnsemble.decode(MojoRuleEnsemble.transform(row, classRules[k2].toArray(new MojoRule[0])), classRules[k2].toArray(new MojoRule[0]), linearModelNames, linearModelDomains, k2);
                    }
                    continue;
                }
                transformedRow[i2 * ntrees + j2] = MojoRuleEnsemble.decode(MojoRuleEnsemble.transform(row, this._orderedRules[i2][j2]), filteredOrderedRules, linearModelNames, linearModelDomains, -1);
            }
        }
        return transformedRow;
    }

    static double decode(double[] cs, MojoRule[] rules, String[] linearModelNames, String[][] linearModelDomains, int classId) {
        int newValue = -1;
        for (int iCol = 0; iCol < cs.length; ++iCol) {
            if (cs[iCol] != 1.0) continue;
            newValue = MojoRuleEnsemble.getValueByVarName(rules[iCol]._varName, linearModelNames, linearModelDomains, classId);
        }
        if (newValue >= 0) {
            return newValue;
        }
        return Double.NaN;
    }

    static int getValueByVarName(String varname, String[] linearModelNames, String[][] linearModelDomains, int classId) {
        String var = varname.substring(0, varname.indexOf(78));
        if (classId != -1) {
            var = var + "C" + classId;
        }
        int i2 = Arrays.asList(linearModelNames).indexOf(var);
        return Arrays.asList(linearModelDomains[i2]).indexOf(varname);
    }

    static double[] transform(double[] row, MojoRule[] rules) {
        double[] transformedRow = new double[rules.length];
        byte[] out = new byte[]{1};
        for (int i2 = 0; i2 < rules.length; ++i2) {
            out[0] = 1;
            rules[i2].map(row, out);
            transformedRow[i2] = out[0];
        }
        return transformedRow;
    }
}

