/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting regression.")
@ScalaSignature(bytes="\u0006\u0001i4Aa\u0005\u000b\u0001?!AA\u0005\u0001BC\u0002\u0013\u0005S\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015!\u0004\u0001\"\u00019\u0011\u001dI\u0004A1A\u0005\u0012iBa\u0001\u0013\u0001!\u0002\u0013Y\u0004bB%\u0001\u0005\u0004%\tB\u000f\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\u001e\t\u000f-\u0003!\u0019!C\tu!1A\n\u0001Q\u0001\nmBq!\u0014\u0001C\u0002\u0013E!\b\u0003\u0004O\u0001\u0001\u0006Ia\u000f\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006+\u0002!\t\u0001\u0015\u0005\u0006-\u0002!\t\u0001\u0015\u0005\u0006/\u0002!\t\u0001\u0015\u0005\u00061\u0002!\t%\u0017\u0005\u0006W\u0002!\t\u0005\u001c\u0002\u0015\u0011Jz%+Z4sKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u000b\u0005U1\u0012aB7fiJL7m\u001d\u0006\u0003/a\t!!\u001c7\u000b\u0005eQ\u0012!C:qCJ\\G.\u001b8h\u0015\tYB$A\u0002ie=T\u0011!H\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011EI\u0007\u0002)%\u00111\u0005\u0006\u0002\u0011\u0011Jz5i\\7n_:lU\r\u001e:jGN\f1!^5e+\u00051\u0003CA\u00141\u001d\tAc\u0006\u0005\u0002*Y5\t!F\u0003\u0002,=\u00051AH]8pizR\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006L\u0001\u0005k&$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003m]\u0002\"!\t\u0001\t\u000b\u0011\u001a\u0001\u0019\u0001\u0014\u0015\u0003Y\n!A\u001d\u001a\u0016\u0003m\u0002\"\u0001\u0010$\u000e\u0003uR!AP \u0002\u000bA\f'/Y7\u000b\u0005]\u0001%BA!C\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001dk$a\u0003#pk\ndW\rU1sC6\f1A\u001d\u001a!\u0003QiW-\u00198SKNLG-^1m\t\u00164\u0018.\u00198dK\u0006)R.Z1o%\u0016\u001c\u0018\u000eZ;bY\u0012+g/[1oG\u0016\u0004\u0013aA7bK\u0006!Q.Y3!\u0003\u0015\u0011Xn\u001d7f\u0003\u0019\u0011Xn\u001d7fA\u0005)q-\u001a;SeQ\t\u0011\u000b\u0005\u0002S'6\tA&\u0003\u0002UY\t1Ai\\;cY\u0016\fqcZ3u\u001b\u0016\fgNU3tS\u0012,\u0018\r\u001c#fm&\fgnY3\u0002\r\u001d,G/T!F\u0003!9W\r\u001e*N'2+\u0015AC:fi6+GO]5dgR\u0019!,X5\u0011\u0005I[\u0016B\u0001/-\u0005\u0011)f.\u001b;\t\u000by\u000b\u0002\u0019A0\u0002\t)\u001cxN\u001c\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\fAaZ:p]*\u0011A-Z\u0001\u0007O>|w\r\\3\u000b\u0003\u0019\f1aY8n\u0013\tA\u0017M\u0001\u0006Kg>twJ\u00196fGRDQA[\tA\u0002\u0019\nqaY8oi\u0016DH/\u0001\u0003d_BLHCA7o\u001b\u0005\u0001\u0001\"B8\u0013\u0001\u0004\u0001\u0018!B3yiJ\f\u0007C\u0001\u001fr\u0013\t\u0011XH\u0001\u0005QCJ\fW.T1qQ\u0011\u0001Ao\u001e=\u0011\u0005\u0005*\u0018B\u0001<\u0015\u0005IiU\r\u001e:jGN$Um]2sSB$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002s\u0006qF\u000b[3!G2\f7o\u001d\u0011nC.,7\u000fI1wC&d\u0017M\u00197fA\u0005dG\u000eI7fiJL7m\u001d\u0011uQ\u0006$\be\u001d5be\u0016$\u0007%Y2s_N\u001c\b%\u00197mA\u0005dwm\u001c:ji\"l7\u000fI:vaB|'\u000f^5oO\u0002\u0012Xm\u001a:fgNLwN\u001c\u0018")
public class H2ORegressionMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final DoubleParam meanResidualDeviance;
    private final DoubleParam mae;
    private final DoubleParam rmsle;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public DoubleParam meanResidualDeviance() {
        return this.meanResidualDeviance;
    }

    public DoubleParam mae() {
        return this.mae;
    }

    public DoubleParam rmsle() {
        return this.rmsle;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public double getMeanResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanResidualDeviance()));
    }

    public double getMAE() {
        return BoxesRunTime.unboxToDouble(this.$(this.mae()));
    }

    public double getRMSLE() {
        return BoxesRunTime.unboxToDouble(this.$(this.rmsle()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block37: {
            Params params;
            block34: {
                block33: {
                    Params params2;
                    block30: {
                        block29: {
                            Params params3;
                            block26: {
                                super.setMetrics(json, context);
                                if (!json.has("r2")) break block26;
                                try {
                                    params3 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2;
                                    block28: {
                                        block27: {
                                            Throwable throwable3 = throwable;
                                            if (throwable3 == null) break block27;
                                            throwable2 = throwable3;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string2 = "true";
                                            if (string == null ? string2 != null : !string.equals(string2)) break block28;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'r2' from ").append(context).toString(), throwable2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block29;
                            }
                            String message = new StringBuilder(35).append("The metric 'r2' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string3 = "true";
                            if (!(string == null ? string3 != null : !string.equals(string3))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("mean_residual_deviance")) break block30;
                        try {
                            params2 = this.set("meanResidualDeviance", BoxesRunTime.boxToDouble((double)json.get("mean_residual_deviance").getAsDouble()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable4;
                            block32: {
                                block31: {
                                    Throwable throwable5 = throwable;
                                    if (throwable5 == null) break block31;
                                    throwable4 = throwable5;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string4 = "true";
                                    if (string == null ? string4 != null : !string.equals(string4)) break block32;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Unsuccessful try to extract 'mean_residual_deviance' from ").append(context).toString(), throwable4);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block33;
                    }
                    String message = new StringBuilder(55).append("The metric 'mean_residual_deviance' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string5 = "true";
                    if (!(string == null ? string5 != null : !string.equals(string5))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("mae")) break block34;
                try {
                    params = this.set("mae", BoxesRunTime.boxToDouble((double)json.get("mae").getAsDouble()));
                }
                catch (Throwable throwable) {
                    Throwable throwable6;
                    block36: {
                        block35: {
                            Throwable throwable7 = throwable;
                            if (throwable7 == null) break block35;
                            throwable6 = throwable7;
                            String string = System.getProperty("spark.testing", "false");
                            String string6 = "true";
                            if (string == null ? string6 != null : !string.equals(string6)) break block36;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Unsuccessful try to extract 'mae' from ").append(context).toString(), throwable6);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block37;
            }
            String message = new StringBuilder(36).append("The metric 'mae' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (!(string == null ? string7 != null : !string.equals(string7))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("rmsle")) {
            try {
                this.set("rmsle", BoxesRunTime.boxToDouble((double)json.get("rmsle").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 != null) {
                    Throwable throwable9 = throwable8;
                    String string = System.getProperty("spark.testing", "false");
                    String string8 = "true";
                    if (string == null ? string8 != null : !string.equals(string8)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Unsuccessful try to extract 'rmsle' from ").append(context).toString(), throwable9);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(38).append("The metric 'rmsle' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null ? string9 != null : !string.equals(string9)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2ORegressionMetrics copy(ParamMap extra) {
        return (H2ORegressionMetrics)this.defaultCopy(extra);
    }

    public H2ORegressionMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.meanResidualDeviance = this.doubleParam("meanResidualDeviance", "The mean residual deviance for this scoring run.");
        this.mae = this.doubleParam("mae", "The mean absolute error for this scoring run.");
        this.rmsle = this.doubleParam("rmsle", "The root mean squared log error for this scoring run.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanResidualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.mae().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.rmsle().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2ORegressionMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2ORegressionMetrics"));
    }
}

