import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type AWSQS::EC2::LinuxBastionQS::MODULE
 *
 * @schema CfnLinuxBastionQsModuleProps
 */
export interface CfnLinuxBastionQsModuleProps {
    /**
     * @schema CfnLinuxBastionQsModuleProps#Parameters
     */
    readonly parameters?: CfnLinuxBastionQsModulePropsParameters;
    /**
     * @schema CfnLinuxBastionQsModuleProps#Resources
     */
    readonly resources?: CfnLinuxBastionQsModulePropsResources;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModuleProps' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModuleProps(obj: CfnLinuxBastionQsModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsParameters
 */
export interface CfnLinuxBastionQsModulePropsParameters {
    /**
     * The Linux distribution for the AMI to be used for the bastion instances.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#BastionAMIOS
     */
    readonly bastionAmios?: CfnLinuxBastionQsModulePropsParametersBastionAmios;
    /**
     * The value used for the name tag of the bastion host.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#BastionHostName
     */
    readonly bastionHostName?: CfnLinuxBastionQsModulePropsParametersBastionHostName;
    /**
     * Banner text to display upon login.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#BastionBanner
     */
    readonly bastionBanner?: CfnLinuxBastionQsModulePropsParametersBastionBanner;
    /**
     * Bastion VPC tenancy (dedicated or default).
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#BastionTenancy
     */
    readonly bastionTenancy?: CfnLinuxBastionQsModulePropsParametersBastionTenancy;
    /**
     * Amazon EC2 instance type for the bastion instances.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#BastionInstanceType
     */
    readonly bastionInstanceType?: CfnLinuxBastionQsModulePropsParametersBastionInstanceType;
    /**
     * Choose *true* to display a banner when connecting via SSH to the bastion.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#EnableBanner
     */
    readonly enableBanner?: CfnLinuxBastionQsModulePropsParametersEnableBanner;
    /**
     * To enable TCP forwarding, choose *true*.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#EnableTCPForwarding
     */
    readonly enableTcpForwarding?: CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding;
    /**
     * To enable X11 forwarding, choose *true*.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#EnableX11Forwarding
     */
    readonly enableX11Forwarding?: CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding;
    /**
     * Name of an existing public/private key pair. If you do not have one in this AWS Region, please create it before continuing.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#KeyPairName
     */
    readonly keyPairName?: CfnLinuxBastionQsModulePropsParametersKeyPairName;
    /**
     * The number of bastion hosts to create. The maximum number is four.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#NumBastionHosts
     */
    readonly numBastionHosts?: CfnLinuxBastionQsModulePropsParametersNumBastionHosts;
    /**
     * ID of the public subnet 1 that you want to provision the first bastion into (e.g., subnet-a0246dcd).
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#PublicSubnet1ID
     */
    readonly publicSubnet1Id?: CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id;
    /**
     * ID of the public subnet 2 that you want to provision the second bastion into (e.g., subnet-e3246d8e).
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#PublicSubnet2ID
     */
    readonly publicSubnet2Id?: CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id;
    /**
     * Name of the S3 bucket for your copy of the Quick Start assets. Keep the default name unless you are customizing the template. Changing the name updates code references to point to a new Quick Start location. This name can include numbers, lowercase letters, uppercase letters, and hyphens, but do not start or end with a hyphen (-). See https://aws-quickstart.github.io/option1.html.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#QSS3BucketName
     */
    readonly qss3BucketName?: CfnLinuxBastionQsModulePropsParametersQss3BucketName;
    /**
     * The AWS Region where the Quick Start S3 bucket (QSS3BucketName) is hosted. When using your own bucket, you must specify this value.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#QSS3BucketRegion
     */
    readonly qss3BucketRegion?: CfnLinuxBastionQsModulePropsParametersQss3BucketRegion;
    /**
     * S3 key prefix that is used to simulate a directory for your copy of the Quick Start assets. Keep the default prefix unless you are customizing the template. Changing this prefix updates code references to point to a new Quick Start location. This prefix can include numbers, lowercase letters, uppercase letters, hyphens (-), and forward slashes (/). End with a forward slash. See https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html and https://aws-quickstart.github.io/option1.html.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#QSS3KeyPrefix
     */
    readonly qss3KeyPrefix?: CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix;
    /**
     * Allowed CIDR block for external SSH access to the bastions.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#RemoteAccessCIDR
     */
    readonly remoteAccessCidr?: CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr;
    /**
     * ID of the VPC (e.g., vpc-0343606e).
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#VPCID
     */
    readonly vpcid?: CfnLinuxBastionQsModulePropsParametersVpcid;
    /**
     * An alternative initialization script to run during setup.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#AlternativeInitializationScript
     */
    readonly alternativeInitializationScript?: CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript;
    /**
     * The Region-specific image to use for the instance.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#OSImageOverride
     */
    readonly osImageOverride?: CfnLinuxBastionQsModulePropsParametersOsImageOverride;
    /**
     * An existing IAM role name to attach to the bastion. If left blank, a new role will be created.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#AlternativeIAMRole
     */
    readonly alternativeIamRole?: CfnLinuxBastionQsModulePropsParametersAlternativeIamRole;
    /**
     * A comma-separated list of environment variables for use in bootstrapping. Variables must be in the format `key=value`. `Value` cannot contain commas.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#EnvironmentVariables
     */
    readonly environmentVariables?: CfnLinuxBastionQsModulePropsParametersEnvironmentVariables;
    /**
     * The size in GB for the root EBS volume.
     *
     * @schema CfnLinuxBastionQsModulePropsParameters#RootVolumeSize
     */
    readonly rootVolumeSize?: CfnLinuxBastionQsModulePropsParametersRootVolumeSize;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParameters(obj: CfnLinuxBastionQsModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResources
 */
export interface CfnLinuxBastionQsModulePropsResources {
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionMainLogGroup
     */
    readonly bastionMainLogGroup?: CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#SSHMetricFilter
     */
    readonly sshMetricFilter?: CfnLinuxBastionQsModulePropsResourcesSshMetricFilter;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionHostRole
     */
    readonly bastionHostRole?: CfnLinuxBastionQsModulePropsResourcesBastionHostRole;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionHostPolicy
     */
    readonly bastionHostPolicy?: CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionHostProfile
     */
    readonly bastionHostProfile?: CfnLinuxBastionQsModulePropsResourcesBastionHostProfile;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#EIP1
     */
    readonly eip1?: CfnLinuxBastionQsModulePropsResourcesEip1;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#EIP2
     */
    readonly eip2?: CfnLinuxBastionQsModulePropsResourcesEip2;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#EIP3
     */
    readonly eip3?: CfnLinuxBastionQsModulePropsResourcesEip3;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#EIP4
     */
    readonly eip4?: CfnLinuxBastionQsModulePropsResourcesEip4;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionAutoScalingGroup
     */
    readonly bastionAutoScalingGroup?: CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionLaunchConfiguration
     */
    readonly bastionLaunchConfiguration?: CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration;
    /**
     * @schema CfnLinuxBastionQsModulePropsResources#BastionSecurityGroup
     */
    readonly bastionSecurityGroup?: CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResources(obj: CfnLinuxBastionQsModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The Linux distribution for the AMI to be used for the bastion instances.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersBastionAmios
 */
export interface CfnLinuxBastionQsModulePropsParametersBastionAmios {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionAmios#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionAmios#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersBastionAmios' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersBastionAmios(obj: CfnLinuxBastionQsModulePropsParametersBastionAmios | undefined): Record<string, any> | undefined;
/**
 * The value used for the name tag of the bastion host.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersBastionHostName
 */
export interface CfnLinuxBastionQsModulePropsParametersBastionHostName {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionHostName#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionHostName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersBastionHostName' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersBastionHostName(obj: CfnLinuxBastionQsModulePropsParametersBastionHostName | undefined): Record<string, any> | undefined;
/**
 * Banner text to display upon login.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersBastionBanner
 */
export interface CfnLinuxBastionQsModulePropsParametersBastionBanner {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionBanner#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionBanner#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersBastionBanner' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersBastionBanner(obj: CfnLinuxBastionQsModulePropsParametersBastionBanner | undefined): Record<string, any> | undefined;
/**
 * Bastion VPC tenancy (dedicated or default).
 *
 * @schema CfnLinuxBastionQsModulePropsParametersBastionTenancy
 */
export interface CfnLinuxBastionQsModulePropsParametersBastionTenancy {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersBastionTenancy' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersBastionTenancy(obj: CfnLinuxBastionQsModulePropsParametersBastionTenancy | undefined): Record<string, any> | undefined;
/**
 * Amazon EC2 instance type for the bastion instances.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersBastionInstanceType
 */
export interface CfnLinuxBastionQsModulePropsParametersBastionInstanceType {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionInstanceType#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersBastionInstanceType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersBastionInstanceType' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersBastionInstanceType(obj: CfnLinuxBastionQsModulePropsParametersBastionInstanceType | undefined): Record<string, any> | undefined;
/**
 * Choose *true* to display a banner when connecting via SSH to the bastion.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersEnableBanner
 */
export interface CfnLinuxBastionQsModulePropsParametersEnableBanner {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableBanner#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableBanner#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersEnableBanner' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersEnableBanner(obj: CfnLinuxBastionQsModulePropsParametersEnableBanner | undefined): Record<string, any> | undefined;
/**
 * To enable TCP forwarding, choose *true*.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding
 */
export interface CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding(obj: CfnLinuxBastionQsModulePropsParametersEnableTcpForwarding | undefined): Record<string, any> | undefined;
/**
 * To enable X11 forwarding, choose *true*.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding
 */
export interface CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding(obj: CfnLinuxBastionQsModulePropsParametersEnableX11Forwarding | undefined): Record<string, any> | undefined;
/**
 * Name of an existing public/private key pair. If you do not have one in this AWS Region, please create it before continuing.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersKeyPairName
 */
export interface CfnLinuxBastionQsModulePropsParametersKeyPairName {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersKeyPairName#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersKeyPairName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersKeyPairName' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersKeyPairName(obj: CfnLinuxBastionQsModulePropsParametersKeyPairName | undefined): Record<string, any> | undefined;
/**
 * The number of bastion hosts to create. The maximum number is four.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersNumBastionHosts
 */
export interface CfnLinuxBastionQsModulePropsParametersNumBastionHosts {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersNumBastionHosts#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersNumBastionHosts#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersNumBastionHosts' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersNumBastionHosts(obj: CfnLinuxBastionQsModulePropsParametersNumBastionHosts | undefined): Record<string, any> | undefined;
/**
 * ID of the public subnet 1 that you want to provision the first bastion into (e.g., subnet-a0246dcd).
 *
 * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id
 */
export interface CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id(obj: CfnLinuxBastionQsModulePropsParametersPublicSubnet1Id | undefined): Record<string, any> | undefined;
/**
 * ID of the public subnet 2 that you want to provision the second bastion into (e.g., subnet-e3246d8e).
 *
 * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id
 */
export interface CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id(obj: CfnLinuxBastionQsModulePropsParametersPublicSubnet2Id | undefined): Record<string, any> | undefined;
/**
 * Name of the S3 bucket for your copy of the Quick Start assets. Keep the default name unless you are customizing the template. Changing the name updates code references to point to a new Quick Start location. This name can include numbers, lowercase letters, uppercase letters, and hyphens, but do not start or end with a hyphen (-). See https://aws-quickstart.github.io/option1.html.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketName
 */
export interface CfnLinuxBastionQsModulePropsParametersQss3BucketName {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersQss3BucketName' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersQss3BucketName(obj: CfnLinuxBastionQsModulePropsParametersQss3BucketName | undefined): Record<string, any> | undefined;
/**
 * The AWS Region where the Quick Start S3 bucket (QSS3BucketName) is hosted. When using your own bucket, you must specify this value.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketRegion
 */
export interface CfnLinuxBastionQsModulePropsParametersQss3BucketRegion {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketRegion#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3BucketRegion#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersQss3BucketRegion' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersQss3BucketRegion(obj: CfnLinuxBastionQsModulePropsParametersQss3BucketRegion | undefined): Record<string, any> | undefined;
/**
 * S3 key prefix that is used to simulate a directory for your copy of the Quick Start assets. Keep the default prefix unless you are customizing the template. Changing this prefix updates code references to point to a new Quick Start location. This prefix can include numbers, lowercase letters, uppercase letters, hyphens (-), and forward slashes (/). End with a forward slash. See https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html and https://aws-quickstart.github.io/option1.html.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix
 */
export interface CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix(obj: CfnLinuxBastionQsModulePropsParametersQss3KeyPrefix | undefined): Record<string, any> | undefined;
/**
 * Allowed CIDR block for external SSH access to the bastions.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr
 */
export interface CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr(obj: CfnLinuxBastionQsModulePropsParametersRemoteAccessCidr | undefined): Record<string, any> | undefined;
/**
 * ID of the VPC (e.g., vpc-0343606e).
 *
 * @schema CfnLinuxBastionQsModulePropsParametersVpcid
 */
export interface CfnLinuxBastionQsModulePropsParametersVpcid {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersVpcid#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersVpcid#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersVpcid' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersVpcid(obj: CfnLinuxBastionQsModulePropsParametersVpcid | undefined): Record<string, any> | undefined;
/**
 * An alternative initialization script to run during setup.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript
 */
export interface CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript(obj: CfnLinuxBastionQsModulePropsParametersAlternativeInitializationScript | undefined): Record<string, any> | undefined;
/**
 * The Region-specific image to use for the instance.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersOsImageOverride
 */
export interface CfnLinuxBastionQsModulePropsParametersOsImageOverride {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersOsImageOverride#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersOsImageOverride#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersOsImageOverride' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersOsImageOverride(obj: CfnLinuxBastionQsModulePropsParametersOsImageOverride | undefined): Record<string, any> | undefined;
/**
 * An existing IAM role name to attach to the bastion. If left blank, a new role will be created.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersAlternativeIamRole
 */
export interface CfnLinuxBastionQsModulePropsParametersAlternativeIamRole {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersAlternativeIamRole#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersAlternativeIamRole#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersAlternativeIamRole' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersAlternativeIamRole(obj: CfnLinuxBastionQsModulePropsParametersAlternativeIamRole | undefined): Record<string, any> | undefined;
/**
 * A comma-separated list of environment variables for use in bootstrapping. Variables must be in the format `key=value`. `Value` cannot contain commas.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersEnvironmentVariables
 */
export interface CfnLinuxBastionQsModulePropsParametersEnvironmentVariables {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnvironmentVariables#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersEnvironmentVariables#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersEnvironmentVariables' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersEnvironmentVariables(obj: CfnLinuxBastionQsModulePropsParametersEnvironmentVariables | undefined): Record<string, any> | undefined;
/**
 * The size in GB for the root EBS volume.
 *
 * @schema CfnLinuxBastionQsModulePropsParametersRootVolumeSize
 */
export interface CfnLinuxBastionQsModulePropsParametersRootVolumeSize {
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersRootVolumeSize#Type
     */
    readonly type: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsParametersRootVolumeSize#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsParametersRootVolumeSize' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsParametersRootVolumeSize(obj: CfnLinuxBastionQsModulePropsParametersRootVolumeSize | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup(obj: CfnLinuxBastionQsModulePropsResourcesBastionMainLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesSshMetricFilter
 */
export interface CfnLinuxBastionQsModulePropsResourcesSshMetricFilter {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesSshMetricFilter#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesSshMetricFilter#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesSshMetricFilter' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesSshMetricFilter(obj: CfnLinuxBastionQsModulePropsResourcesSshMetricFilter | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostRole
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionHostRole {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionHostRole' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionHostRole(obj: CfnLinuxBastionQsModulePropsResourcesBastionHostRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy(obj: CfnLinuxBastionQsModulePropsResourcesBastionHostPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostProfile
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionHostProfile {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostProfile#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionHostProfile#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionHostProfile' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionHostProfile(obj: CfnLinuxBastionQsModulePropsResourcesBastionHostProfile | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesEip1
 */
export interface CfnLinuxBastionQsModulePropsResourcesEip1 {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesEip1' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesEip1(obj: CfnLinuxBastionQsModulePropsResourcesEip1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesEip2
 */
export interface CfnLinuxBastionQsModulePropsResourcesEip2 {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesEip2' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesEip2(obj: CfnLinuxBastionQsModulePropsResourcesEip2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesEip3
 */
export interface CfnLinuxBastionQsModulePropsResourcesEip3 {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip3#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip3#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesEip3' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesEip3(obj: CfnLinuxBastionQsModulePropsResourcesEip3 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesEip4
 */
export interface CfnLinuxBastionQsModulePropsResourcesEip4 {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip4#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesEip4#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesEip4' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesEip4(obj: CfnLinuxBastionQsModulePropsResourcesEip4 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup(obj: CfnLinuxBastionQsModulePropsResourcesBastionAutoScalingGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration(obj: CfnLinuxBastionQsModulePropsResourcesBastionLaunchConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup
 */
export interface CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup {
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup(obj: CfnLinuxBastionQsModulePropsResourcesBastionSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::EC2::LinuxBastionQS::MODULE`
 *
 * @cloudformationResource AWSQS::EC2::LinuxBastionQS::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnLinuxBastionQsModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::EC2::LinuxBastionQS::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnLinuxBastionQsModuleProps;
    /**
     * Create a new `AWSQS::EC2::LinuxBastionQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnLinuxBastionQsModuleProps);
}
