from types import TracebackType
from typing import Any, Optional, Text, Type, Union

from redis.client import Redis

_TokenValue = Union[bytes, Text]

class Lock:
    def __init__(
        self,
        redis: Redis[Any],
        name: str,
        timeout: Union[None, int, float] = ...,
        sleep: float = ...,
        blocking: bool = ...,
        blocking_timeout: Optional[bool] = ...,
        thread_local: bool = ...,
    ) -> None: ...
    def register_scripts(self) -> None: ...
    def __enter__(self) -> Lock: ...
    def __exit__(
        self, exc_type: Optional[Type[BaseException]], exc_value: Optional[BaseException], traceback: Optional[TracebackType]
    ) -> Optional[bool]: ...
    def acquire(
        self, blocking: Optional[bool] = ..., blocking_timeout: Union[None, int, float] = ..., token: Optional[_TokenValue] = ...
    ) -> bool: ...
    def do_acquire(self, token: _TokenValue) -> bool: ...
    def locked(self) -> bool: ...
    def owned(self) -> bool: ...
    def release(self) -> None: ...
    def do_release(self, expected_token: _TokenValue) -> None: ...
    def extend(self, additional_time: Union[int, float], replace_ttl: bool = ...) -> bool: ...
    def do_extend(self, additional_time: Union[int, float], replace_ttl: bool) -> bool: ...
    def reacquire(self) -> bool: ...
    def do_reacquire(self) -> bool: ...
