from tkinter import Event, Misc, Tk, Widget
from typing import ClassVar, Optional, Protocol

class _DndSource(Protocol):
    def dnd_end(self, target: Optional[Widget], event: Optional[Event[Misc]]) -> None: ...

class DndHandler:
    root: ClassVar[Optional[Tk]]
    def __init__(self, source: _DndSource, event: Event[Misc]) -> None: ...
    def cancel(self, event: Optional[Event[Misc]] = ...) -> None: ...
    def finish(self, event: Optional[Event[Misc]], commit: int = ...) -> None: ...
    def on_motion(self, event: Event[Misc]) -> None: ...
    def on_release(self, event: Event[Misc]) -> None: ...

def dnd_start(source, event) -> Optional[DndHandler]: ...
