"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .embeddingrequest import EmbeddingRequest, EmbeddingRequestTypedDict
from .entitysettings import EntitySettings, EntitySettingsTypedDict
from .jsontextoutputsettings import (
    JSONTextOutputSettings,
    JSONTextOutputSettingsTypedDict,
)
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class TextSettingsTypedDict(TypedDict):
    embed: NotRequired[List[EmbeddingRequestTypedDict]]
    r"""List of embedding settings for generating multiple embeddings. field_name's provided are how the raw text will be inserted, if not provided, the field_name will be auto-generated.
    Default: [{type: 'text', embedding_model: 'multimodal'}] if none provided.
    """
    json_output: NotRequired[Nullable[JSONTextOutputSettingsTypedDict]]
    r"""Settings for structured JSON output of text analysis."""
    entities: NotRequired[Nullable[EntitySettingsTypedDict]]
    r"""Settings for extracting entities from text content"""


class TextSettings(BaseModel):
    embed: Optional[List[EmbeddingRequest]] = None
    r"""List of embedding settings for generating multiple embeddings. field_name's provided are how the raw text will be inserted, if not provided, the field_name will be auto-generated.
    Default: [{type: 'text', embedding_model: 'multimodal'}] if none provided.
    """

    json_output: OptionalNullable[JSONTextOutputSettings] = UNSET
    r"""Settings for structured JSON output of text analysis."""

    entities: OptionalNullable[EntitySettings] = UNSET
    r"""Settings for extracting entities from text content"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "json_output", "entities"]
        nullable_fields = ["json_output", "entities"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
