"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class LogoDetectSettingsTypedDict(TypedDict):
    enabled: NotRequired[bool]
    r"""Enable logo detection"""
    confidence_threshold: NotRequired[Nullable[float]]
    r"""Minimum confidence threshold for detected logos"""


class LogoDetectSettings(BaseModel):
    enabled: Optional[bool] = True
    r"""Enable logo detection"""

    confidence_threshold: OptionalNullable[float] = UNSET
    r"""Minimum confidence threshold for detected logos"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["enabled", "confidence_threshold"]
        nullable_fields = ["confidence_threshold"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
