"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .logicaloperator import LogicalOperator, LogicalOperatorTypedDict
from .sortoption import SortOption, SortOptionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, List, Optional
from typing_extensions import NotRequired, TypedDict


class ListFeaturesRequestTypedDict(TypedDict):
    collections: List[str]
    r"""Collection identifiers - can be either collection IDs or collection names"""
    filters: NotRequired[Nullable[LogicalOperatorTypedDict]]
    r"""Complex nested query filters"""
    sort: NotRequired[Nullable[SortOptionTypedDict]]
    r"""
    List of fields to sort by, with direction (asc or desc).
    NOTE: fields will require a specialty index to use this, consult with the team.

    """
    select: NotRequired[Nullable[List[Any]]]
    r"""List of fields to return in results, supports dot notation. Everything else is excluded."""
    return_urls: NotRequired[bool]
    r"""When true, generates presigned URLs for assets"""


class ListFeaturesRequest(BaseModel):
    collections: List[str]
    r"""Collection identifiers - can be either collection IDs or collection names"""

    filters: OptionalNullable[LogicalOperator] = UNSET
    r"""Complex nested query filters"""

    sort: OptionalNullable[SortOption] = UNSET
    r"""
    List of fields to sort by, with direction (asc or desc).
    NOTE: fields will require a specialty index to use this, consult with the team.

    """

    select: OptionalNullable[List[Any]] = UNSET
    r"""List of fields to return in results, supports dot notation. Everything else is excluded."""

    return_urls: Optional[bool] = False
    r"""When true, generates presigned URLs for assets"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["filters", "sort", "select", "return_urls"]
        nullable_fields = ["filters", "sort", "select"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
