"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sortoption import SortOption, SortOptionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class GroupByOptionsAssetTypedDict(TypedDict):
    field: NotRequired[Nullable[str]]
    r"""
    Field to group by

    Note: We currently do not support ad-hoc grouping.
    This means the field must be indexed separately.
    Please contact us to add additional fields for grouping.

    """
    max_assets: NotRequired[Nullable[int]]
    r"""Maximum number of assets to group"""
    sort: NotRequired[Nullable[SortOptionTypedDict]]
    r"""Sort options for ordering the inside of the groups"""


class GroupByOptionsAsset(BaseModel):
    field: OptionalNullable[str] = UNSET
    r"""
    Field to group by

    Note: We currently do not support ad-hoc grouping.
    This means the field must be indexed separately.
    Please contact us to add additional fields for grouping.

    """

    max_assets: OptionalNullable[int] = UNSET
    r"""Maximum number of assets to group"""

    sort: OptionalNullable[SortOption] = UNSET
    r"""Sort options for ordering the inside of the groups"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["field", "max_assets", "sort"]
        nullable_fields = ["field", "max_assets", "sort"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
