"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .classificationmatch import ClassificationMatch, ClassificationMatchTypedDict
from .featureresponse import FeatureResponse, FeatureResponseTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class ClassificationWithFeatureTypedDict(TypedDict):
    r"""Classification entry with optional full feature and node data"""

    feature_id: str
    r"""ID of the classified feature"""
    classification_id: str
    r"""ID of the classification run"""
    taxonomy_id: str
    r"""ID of the taxonomy used"""
    matches: List[ClassificationMatchTypedDict]
    r"""List of node matches with scores"""
    feature: NotRequired[Nullable[FeatureResponseTypedDict]]
    r"""Full feature object if requested"""


class ClassificationWithFeature(BaseModel):
    r"""Classification entry with optional full feature and node data"""

    feature_id: str
    r"""ID of the classified feature"""

    classification_id: str
    r"""ID of the classification run"""

    taxonomy_id: str
    r"""ID of the taxonomy used"""

    matches: List[ClassificationMatch]
    r"""List of node matches with scores"""

    feature: OptionalNullable[FeatureResponse] = UNSET
    r"""Full feature object if requested"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["feature"]
        nullable_fields = ["feature"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
