"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .assignmentmode import AssignmentMode
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class AssignmentConfigTypedDict(TypedDict):
    r"""Configuration for how classifications should be assigned to features"""

    enabled: NotRequired[bool]
    r"""Whether to assign the taxonomy to the feature"""
    mode: NotRequired[AssignmentMode]
    r"""Mode for how classifications should be assigned"""
    append: NotRequired[bool]
    r"""Whether to append the classification to the feature, if false, replaces any existing classification"""
    confidence_threshold: NotRequired[Nullable[float]]
    r"""Minimum confidence score required for classification (only used in threshold mode)"""


class AssignmentConfig(BaseModel):
    r"""Configuration for how classifications should be assigned to features"""

    enabled: Optional[bool] = False
    r"""Whether to assign the taxonomy to the feature"""

    mode: Optional[AssignmentMode] = None
    r"""Mode for how classifications should be assigned"""

    append: Optional[bool] = False
    r"""Whether to append the classification to the feature, if false, replaces any existing classification"""

    confidence_threshold: OptionalNullable[float] = UNSET
    r"""Minimum confidence score required for classification (only used in threshold mode)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["enabled", "mode", "append", "confidence_threshold"]
        nullable_fields = ["confidence_threshold"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
