"""単体でもディスクリプタとしても使用できるバリデータライブラリです。

    以下で紹介されているクラスは対応するモジュールからインポートしてください。

    base:
        CNoneable
        CNumerical
        Converter
        Validator
        VContainer
"""


__all__ = (
    "CBool",
    "CFloat",
    "CInt",
    "CNoneable",
    "CNumber",
    "CPath",
    "CString",
    "CTimedelta",
    "VBool",
    "VChoice",
    "VDict",
    "VFloat",
    "VInt",
    "VList",
    "VNumber",
    "VPath",
    "VRegex",
    "VString",
    "VTimedelta",
    "VTuple",
)


from .bases import CNoneable
from .converters import (
    CBool,
    CFloat,
    CInt,
    CNumber,
    CPath,
    CString,
    CTimedelta,
)
from .validators import (
    VBool,
    VChoice,
    VDict,
    VFloat,
    VInt,
    VList,
    VNumber,
    VPath,
    VRegex,
    VString,
    VTimedelta,
    VTuple,
)
