# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class TenantApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_tenant(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create a tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tenant(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Tenant body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool use_global_default:
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tenant_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tenant_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_tenant_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create a tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tenant_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Tenant body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool use_global_default:
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'use_global_default']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tenant" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_tenant`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_tenant`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'use_global_default' in params:
            query_params.append(('useGlobalDefault', params['use_global_default']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tenant',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_per_tenant_configuration(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_per_tenant_configuration(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_per_tenant_configuration_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_per_tenant_configuration_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_per_tenant_configuration_with_http_info(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_per_tenant_configuration_with_http_info(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_per_tenant_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_per_tenant_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPerTenantConfig', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plugin_configuration(self, plugin_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plugin_configuration(plugin_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plugin_configuration_with_http_info(plugin_name, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plugin_configuration_with_http_info(plugin_name, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_plugin_configuration_with_http_info(self, plugin_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plugin_configuration_with_http_info(plugin_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_name', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plugin_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `delete_plugin_configuration`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_plugin_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginConfig/{pluginName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plugin_payment_state_machine_config(self, plugin_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plugin_payment_state_machine_config(plugin_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plugin_payment_state_machine_config_with_http_info(plugin_name, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plugin_payment_state_machine_config_with_http_info(plugin_name, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_plugin_payment_state_machine_config_with_http_info(self, plugin_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plugin_payment_state_machine_config_with_http_info(plugin_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_name', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plugin_payment_state_machine_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `delete_plugin_payment_state_machine_config`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_plugin_payment_state_machine_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_push_notification_callbacks(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_push_notification_callbacks(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_push_notification_callbacks_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_push_notification_callbacks_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_push_notification_callbacks_with_http_info(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_push_notification_callbacks_with_http_info(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_push_notification_callbacks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_push_notification_callbacks`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/registerNotificationCallback', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user_key_value(self, key_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete  a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_key_value(key_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_user_key_value_with_http_info(key_name, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_user_key_value_with_http_info(key_name, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_user_key_value_with_http_info(self, key_name, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete  a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_key_value_with_http_info(key_name, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_key_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `delete_user_key_value`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_user_key_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key_name' in params:
            path_params['keyName'] = params['key_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/userKeyValue/{keyName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_plugin_configuration(self, key_prefix, **kwargs):  # noqa: E501
        """Retrieve a per tenant key value based on key prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_plugin_configuration(key_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_prefix: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_plugin_configuration_with_http_info(key_prefix, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_plugin_configuration_with_http_info(key_prefix, **kwargs)  # noqa: E501
            return data

    def get_all_plugin_configuration_with_http_info(self, key_prefix, **kwargs):  # noqa: E501
        """Retrieve a per tenant key value based on key prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_plugin_configuration_with_http_info(key_prefix, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_prefix: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_plugin_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_prefix' is set
        if ('key_prefix' not in params or
                params['key_prefix'] is None):
            raise ValueError("Missing the required parameter `key_prefix` when calling `get_all_plugin_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key_prefix' in params:
            path_params['keyPrefix'] = params['key_prefix']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPerTenantConfig/{keyPrefix}/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_per_tenant_configuration(self, **kwargs):  # noqa: E501
        """Retrieve a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_per_tenant_configuration(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_per_tenant_configuration_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_per_tenant_configuration_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_per_tenant_configuration_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_per_tenant_configuration_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_per_tenant_configuration" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPerTenantConfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plugin_configuration(self, plugin_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugin_configuration(plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plugin_configuration_with_http_info(plugin_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plugin_configuration_with_http_info(plugin_name, **kwargs)  # noqa: E501
            return data

    def get_plugin_configuration_with_http_info(self, plugin_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugin_configuration_with_http_info(plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plugin_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `get_plugin_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginConfig/{pluginName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plugin_payment_state_machine_config(self, plugin_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugin_payment_state_machine_config(plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plugin_payment_state_machine_config_with_http_info(plugin_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plugin_payment_state_machine_config_with_http_info(plugin_name, **kwargs)  # noqa: E501
            return data

    def get_plugin_payment_state_machine_config_with_http_info(self, plugin_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugin_payment_state_machine_config_with_http_info(plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plugin_payment_state_machine_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `get_plugin_payment_state_machine_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_push_notification_callbacks(self, **kwargs):  # noqa: E501
        """Retrieve a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_push_notification_callbacks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_push_notification_callbacks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_push_notification_callbacks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_push_notification_callbacks_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_push_notification_callbacks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_push_notification_callbacks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/registerNotificationCallback', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant(self, tenant_id, **kwargs):  # noqa: E501
        """Retrieve a tenant by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant(tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_id: (required)
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_with_http_info(tenant_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_with_http_info(tenant_id, **kwargs)  # noqa: E501
            return data

    def get_tenant_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Retrieve a tenant by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_id: (required)
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if ('tenant_id' not in params or
                params['tenant_id'] is None):
            raise ValueError("Missing the required parameter `tenant_id` when calling `get_tenant`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in params:
            path_params['tenantId'] = params['tenant_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/{tenantId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tenant',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_by_api_key(self, **kwargs):  # noqa: E501
        """Retrieve a tenant by its API key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_by_api_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_by_api_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_by_api_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tenant_by_api_key_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a tenant by its API key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_by_api_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str api_key:
        :return: Tenant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['api_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_by_api_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in params:
            query_params.append(('apiKey', params['api_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tenant',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_key_value(self, key_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_key_value(key_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_key_value_with_http_info(key_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_key_value_with_http_info(key_name, **kwargs)  # noqa: E501
            return data

    def get_user_key_value_with_http_info(self, key_name, **kwargs):  # noqa: E501
        """Retrieve a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_key_value_with_http_info(key_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key_name: (required)
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_key_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `get_user_key_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key_name' in params:
            path_params['keyName'] = params['key_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/userKeyValue/{keyName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_user_key_value(self, body, x_killbill_created_by, key_name, **kwargs):  # noqa: E501
        """Add a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_user_key_value(body, x_killbill_created_by, key_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str key_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_user_key_value_with_http_info(body, x_killbill_created_by, key_name, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_user_key_value_with_http_info(body, x_killbill_created_by, key_name, **kwargs)  # noqa: E501
            return data

    def insert_user_key_value_with_http_info(self, body, x_killbill_created_by, key_name, **kwargs):  # noqa: E501
        """Add a per tenant user key/value  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_user_key_value_with_http_info(body, x_killbill_created_by, key_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str key_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'key_name', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_user_key_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `insert_user_key_value`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `insert_user_key_value`")  # noqa: E501
        # verify the required parameter 'key_name' is set
        if ('key_name' not in params or
                params['key_name'] is None):
            raise ValueError("Missing the required parameter `key_name` when calling `insert_user_key_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key_name' in params:
            path_params['keyName'] = params['key_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/userKeyValue/{keyName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_push_notification_callback(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_push_notification_callback(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str cb:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_push_notification_callback_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.register_push_notification_callback_with_http_info(x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def register_push_notification_callback_with_http_info(self, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create a push notification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_push_notification_callback_with_http_info(x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_killbill_created_by: (required)
        :param str cb:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_killbill_created_by', 'cb', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_push_notification_callback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `register_push_notification_callback`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cb' in params:
            query_params.append(('cb', params['cb']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/registerNotificationCallback', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_per_tenant_configuration(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Add a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_per_tenant_configuration(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_per_tenant_configuration_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_per_tenant_configuration_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def upload_per_tenant_configuration_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Add a per tenant configuration (system properties)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_per_tenant_configuration_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_per_tenant_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_per_tenant_configuration`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_per_tenant_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPerTenantConfig', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_plugin_configuration(self, body, x_killbill_created_by, plugin_name, **kwargs):  # noqa: E501
        """Add a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_plugin_configuration(body, x_killbill_created_by, plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str plugin_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_plugin_configuration_with_http_info(body, x_killbill_created_by, plugin_name, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_plugin_configuration_with_http_info(body, x_killbill_created_by, plugin_name, **kwargs)  # noqa: E501
            return data

    def upload_plugin_configuration_with_http_info(self, body, x_killbill_created_by, plugin_name, **kwargs):  # noqa: E501
        """Add a per tenant configuration for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_plugin_configuration_with_http_info(body, x_killbill_created_by, plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str plugin_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'plugin_name', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_plugin_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_plugin_configuration`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_plugin_configuration`")  # noqa: E501
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `upload_plugin_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginConfig/{pluginName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_plugin_payment_state_machine_config(self, body, x_killbill_created_by, plugin_name, **kwargs):  # noqa: E501
        """Add a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_plugin_payment_state_machine_config(body, x_killbill_created_by, plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str plugin_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_plugin_payment_state_machine_config_with_http_info(body, x_killbill_created_by, plugin_name, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_plugin_payment_state_machine_config_with_http_info(body, x_killbill_created_by, plugin_name, **kwargs)  # noqa: E501
            return data

    def upload_plugin_payment_state_machine_config_with_http_info(self, body, x_killbill_created_by, plugin_name, **kwargs):  # noqa: E501
        """Add a per tenant payment state machine for a plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_plugin_payment_state_machine_config_with_http_info(body, x_killbill_created_by, plugin_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str plugin_name: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: TenantKeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'plugin_name', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_plugin_payment_state_machine_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_plugin_payment_state_machine_config`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_plugin_payment_state_machine_config`")  # noqa: E501
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params or
                params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `upload_plugin_payment_state_machine_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TenantKeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
