# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class SubscriptionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_subscription_blocking_state(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Block a subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscription_blocking_state(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockingState body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[BlockingState]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_subscription_blocking_state_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_subscription_blocking_state_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def add_subscription_blocking_state_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Block a subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscription_blocking_state_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockingState body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[BlockingState]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_subscription_blocking_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_subscription_blocking_state`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `add_subscription_blocking_state`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `add_subscription_blocking_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/block', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlockingState]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_subscription_plan(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancel an entitlement plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_subscription_plan(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param str entitlement_policy:
        :param str billing_policy:
        :param bool use_requested_date_for_billing:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def cancel_subscription_plan_with_http_info(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancel an entitlement plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param str entitlement_policy:
        :param str billing_policy:
        :param bool use_requested_date_for_billing:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'x_killbill_created_by', 'requested_date', 'call_completion', 'call_timeout_sec', 'entitlement_policy', 'billing_policy', 'use_requested_date_for_billing', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_subscription_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `cancel_subscription_plan`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `cancel_subscription_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'call_completion' in params:
            query_params.append(('callCompletion', params['call_completion']))  # noqa: E501
        if 'call_timeout_sec' in params:
            query_params.append(('callTimeoutSec', params['call_timeout_sec']))  # noqa: E501
        if 'entitlement_policy' in params:
            query_params.append(('entitlementPolicy', params['entitlement_policy']))  # noqa: E501
        if 'billing_policy' in params:
            query_params.append(('billingPolicy', params['billing_policy']))  # noqa: E501
        if 'use_requested_date_for_billing' in params:
            query_params.append(('useRequestedDateForBilling', params['use_requested_date_for_billing']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_subscription_plan(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Change entitlement plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_subscription_plan(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param str billing_policy:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.change_subscription_plan_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.change_subscription_plan_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def change_subscription_plan_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Change entitlement plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_subscription_plan_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param str billing_policy:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'call_completion', 'call_timeout_sec', 'billing_policy', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_subscription_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_subscription_plan`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `change_subscription_plan`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `change_subscription_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'call_completion' in params:
            query_params.append(('callCompletion', params['call_completion']))  # noqa: E501
        if 'call_timeout_sec' in params:
            query_params.append(('callTimeoutSec', params['call_timeout_sec']))  # noqa: E501
        if 'billing_policy' in params:
            query_params.append(('billingPolicy', params['billing_policy']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subscription(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create an subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool rename_key_if_exists_and_unused:
        :param bool migrated:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subscription_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subscription_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_subscription_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create an subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool rename_key_if_exists_and_unused:
        :param bool migrated:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'entitlement_date', 'billing_date', 'rename_key_if_exists_and_unused', 'migrated', 'call_completion', 'call_timeout_sec', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_subscription`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'entitlement_date' in params:
            query_params.append(('entitlementDate', params['entitlement_date']))  # noqa: E501
        if 'billing_date' in params:
            query_params.append(('billingDate', params['billing_date']))  # noqa: E501
        if 'rename_key_if_exists_and_unused' in params:
            query_params.append(('renameKeyIfExistsAndUnused', params['rename_key_if_exists_and_unused']))  # noqa: E501
        if 'migrated' in params:
            query_params.append(('migrated', params['migrated']))  # noqa: E501
        if 'call_completion' in params:
            query_params.append(('callCompletion', params['call_completion']))  # noqa: E501
        if 'call_timeout_sec' in params:
            query_params.append(('callTimeoutSec', params['call_timeout_sec']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Subscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subscription_custom_fields(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Add custom fields to subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_custom_fields(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def create_subscription_custom_fields_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Add custom fields to subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscription_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_subscription_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_subscription_custom_fields`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `create_subscription_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/customFields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subscription_tags(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """create_subscription_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_tags(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subscription_tags_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subscription_tags_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def create_subscription_tags_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """create_subscription_tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_tags_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscription_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_subscription_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_subscription_tags`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `create_subscription_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subscription_with_add_ons(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create an entitlement with addOn products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_with_add_ons(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Subscription] body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool migrated:
        :param bool rename_key_if_exists_and_unused:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subscription_with_add_ons_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subscription_with_add_ons_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_subscription_with_add_ons_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create an entitlement with addOn products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscription_with_add_ons_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Subscription] body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool migrated:
        :param bool rename_key_if_exists_and_unused:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'entitlement_date', 'billing_date', 'migrated', 'rename_key_if_exists_and_unused', 'call_completion', 'call_timeout_sec', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscription_with_add_ons" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_subscription_with_add_ons`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_subscription_with_add_ons`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'entitlement_date' in params:
            query_params.append(('entitlementDate', params['entitlement_date']))  # noqa: E501
        if 'billing_date' in params:
            query_params.append(('billingDate', params['billing_date']))  # noqa: E501
        if 'migrated' in params:
            query_params.append(('migrated', params['migrated']))  # noqa: E501
        if 'rename_key_if_exists_and_unused' in params:
            query_params.append(('renameKeyIfExistsAndUnused', params['rename_key_if_exists_and_unused']))  # noqa: E501
        if 'call_completion' in params:
            query_params.append(('callCompletion', params['call_completion']))  # noqa: E501
        if 'call_timeout_sec' in params:
            query_params.append(('callTimeoutSec', params['call_timeout_sec']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/createSubscriptionWithAddOns', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bundle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subscriptions_with_add_ons(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create multiple entitlements with addOn products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscriptions_with_add_ons(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[BulkSubscriptionsBundle] body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool rename_key_if_exists_and_unused:
        :param bool migrated:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subscriptions_with_add_ons_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subscriptions_with_add_ons_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_subscriptions_with_add_ons_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Create multiple entitlements with addOn products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subscriptions_with_add_ons_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[BulkSubscriptionsBundle] body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date entitlement_date:
        :param date billing_date:
        :param bool rename_key_if_exists_and_unused:
        :param bool migrated:
        :param bool call_completion:
        :param int call_timeout_sec:
        :param list[str] plugin_property:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'entitlement_date', 'billing_date', 'rename_key_if_exists_and_unused', 'migrated', 'call_completion', 'call_timeout_sec', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscriptions_with_add_ons" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_subscriptions_with_add_ons`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_subscriptions_with_add_ons`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'entitlement_date' in params:
            query_params.append(('entitlementDate', params['entitlement_date']))  # noqa: E501
        if 'billing_date' in params:
            query_params.append(('billingDate', params['billing_date']))  # noqa: E501
        if 'rename_key_if_exists_and_unused' in params:
            query_params.append(('renameKeyIfExistsAndUnused', params['rename_key_if_exists_and_unused']))  # noqa: E501
        if 'migrated' in params:
            query_params.append(('migrated', params['migrated']))  # noqa: E501
        if 'call_completion' in params:
            query_params.append(('callCompletion', params['call_completion']))  # noqa: E501
        if 'call_timeout_sec' in params:
            query_params.append(('callTimeoutSec', params['call_timeout_sec']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/createSubscriptionsWithAddOns', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Bundle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subscription_custom_fields(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscription_custom_fields(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_subscription_custom_fields_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subscription_custom_fields_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_subscription_custom_fields_with_http_info(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscription_custom_fields_with_http_info(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'x_killbill_created_by', 'custom_field', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subscription_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `delete_subscription_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_subscription_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'custom_field' in params:
            query_params.append(('customField', params['custom_field']))  # noqa: E501
            collection_formats['customField'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/customFields', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subscription_tags(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscription_tags(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_subscription_tags_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subscription_tags_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_subscription_tags_with_http_info(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscription_tags_with_http_info(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'x_killbill_created_by', 'tag_def', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subscription_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `delete_subscription_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_subscription_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'tag_def' in params:
            query_params.append(('tagDef', params['tag_def']))  # noqa: E501
            collection_formats['tagDef'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve a subscription by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str audit:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def get_subscription_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve a subscription by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str audit:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `get_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Subscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_audit_logs_with_history(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_audit_logs_with_history(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_audit_logs_with_history_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_audit_logs_with_history_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def get_subscription_audit_logs_with_history_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_audit_logs_with_history_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `get_subscription_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_by_key(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a subscription by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_by_key(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param str audit:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
            return data

    def get_subscription_by_key_with_http_info(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a subscription by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_by_key_with_http_info(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param str audit:
        :return: Subscription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_key', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_key' is set
        if ('external_key' not in params or
                params['external_key'] is None):
            raise ValueError("Missing the required parameter `external_key` when calling `get_subscription_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_key' in params:
            query_params.append(('externalKey', params['external_key']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Subscription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_custom_fields(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_custom_fields(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_custom_fields_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_custom_fields_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def get_subscription_custom_fields_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_custom_fields_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `get_subscription_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_event_audit_logs_with_history(self, event_id, **kwargs):  # noqa: E501
        """Retrieve subscription event audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_event_audit_logs_with_history(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_event_audit_logs_with_history_with_http_info(event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_event_audit_logs_with_history_with_http_info(event_id, **kwargs)  # noqa: E501
            return data

    def get_subscription_event_audit_logs_with_history_with_http_info(self, event_id, **kwargs):  # noqa: E501
        """Retrieve subscription event audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_event_audit_logs_with_history_with_http_info(event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_event_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params or
                params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_subscription_event_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/events/{eventId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subscription_tags(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_tags(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subscription_tags_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subscription_tags_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def get_subscription_tags_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Retrieve subscription tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscription_tags_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'included_deleted', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `get_subscription_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_subscription_custom_fields(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Modify custom fields to subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_subscription_custom_fields(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def modify_subscription_custom_fields_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Modify custom fields to subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_subscription_custom_fields_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_subscription_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_subscription_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `modify_subscription_custom_fields`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `modify_subscription_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def uncancel_subscription_plan(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Un-cancel an entitlement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uncancel_subscription_plan(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.uncancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.uncancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def uncancel_subscription_plan_with_http_info(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Un-cancel an entitlement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uncancel_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'x_killbill_created_by', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method uncancel_subscription_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `uncancel_subscription_plan`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `uncancel_subscription_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/uncancel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def undo_change_subscription_plan(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Undo a pending change plan on an entitlement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.undo_change_subscription_plan(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.undo_change_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.undo_change_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def undo_change_subscription_plan_with_http_info(self, subscription_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Undo a pending change plan on an entitlement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.undo_change_subscription_plan_with_http_info(subscription_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'x_killbill_created_by', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method undo_change_subscription_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `undo_change_subscription_plan`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `undo_change_subscription_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/undoChangePlan', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_subscription_bcd(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Update the BCD associated to a subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_subscription_bcd(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date effective_from_date:
        :param bool force_new_bcd_with_past_effective_date:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_subscription_bcd_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_subscription_bcd_with_http_info(body, x_killbill_created_by, subscription_id, **kwargs)  # noqa: E501
            return data

    def update_subscription_bcd_with_http_info(self, body, x_killbill_created_by, subscription_id, **kwargs):  # noqa: E501
        """Update the BCD associated to a subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_subscription_bcd_with_http_info(body, x_killbill_created_by, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Subscription body: (required)
        :param str x_killbill_created_by: (required)
        :param str subscription_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date effective_from_date:
        :param bool force_new_bcd_with_past_effective_date:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'subscription_id', 'x_killbill_reason', 'x_killbill_comment', 'effective_from_date', 'force_new_bcd_with_past_effective_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_subscription_bcd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_subscription_bcd`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `update_subscription_bcd`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `update_subscription_bcd`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []
        if 'effective_from_date' in params:
            query_params.append(('effectiveFromDate', params['effective_from_date']))  # noqa: E501
        if 'force_new_bcd_with_past_effective_date' in params:
            query_params.append(('forceNewBcdWithPastEffectiveDate', params['force_new_bcd_with_past_effective_date']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/subscriptions/{subscriptionId}/bcd', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
