# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class PaymentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_scheduled_payment_transaction_by_external_key(self, transaction_external_key, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancels a scheduled payment attempt retry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_payment_transaction_by_external_key(transaction_external_key, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_external_key: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_scheduled_payment_transaction_by_external_key_with_http_info(transaction_external_key, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_scheduled_payment_transaction_by_external_key_with_http_info(transaction_external_key, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def cancel_scheduled_payment_transaction_by_external_key_with_http_info(self, transaction_external_key, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancels a scheduled payment attempt retry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_payment_transaction_by_external_key_with_http_info(transaction_external_key, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_external_key: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transaction_external_key', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_scheduled_payment_transaction_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transaction_external_key' is set
        if ('transaction_external_key' not in params or
                params['transaction_external_key'] is None):
            raise ValueError("Missing the required parameter `transaction_external_key` when calling `cancel_scheduled_payment_transaction_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `cancel_scheduled_payment_transaction_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'transaction_external_key' in params:
            query_params.append(('transactionExternalKey', params['transaction_external_key']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/cancelScheduledPaymentTransaction', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_scheduled_payment_transaction_by_id(self, payment_transaction_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancels a scheduled payment attempt retry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_payment_transaction_by_id(payment_transaction_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_transaction_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_scheduled_payment_transaction_by_id_with_http_info(payment_transaction_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_scheduled_payment_transaction_by_id_with_http_info(payment_transaction_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def cancel_scheduled_payment_transaction_by_id_with_http_info(self, payment_transaction_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Cancels a scheduled payment attempt retry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_payment_transaction_by_id_with_http_info(payment_transaction_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_transaction_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_transaction_id', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_scheduled_payment_transaction_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_transaction_id' is set
        if ('payment_transaction_id' not in params or
                params['payment_transaction_id'] is None):
            raise ValueError("Missing the required parameter `payment_transaction_id` when calling `cancel_scheduled_payment_transaction_by_id`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `cancel_scheduled_payment_transaction_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_transaction_id' in params:
            path_params['paymentTransactionId'] = params['payment_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentTransactionId}/cancelScheduledPaymentTransaction', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def capture_authorization(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Capture an existing authorization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.capture_authorization(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.capture_authorization_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.capture_authorization_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def capture_authorization_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Capture an existing authorization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.capture_authorization_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method capture_authorization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `capture_authorization`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `capture_authorization`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `capture_authorization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def capture_authorization_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Capture an existing authorization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.capture_authorization_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.capture_authorization_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.capture_authorization_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def capture_authorization_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Capture an existing authorization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.capture_authorization_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method capture_authorization_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `capture_authorization_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `capture_authorization_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chargeback_payment(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Record a chargeback  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_payment(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chargeback_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.chargeback_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def chargeback_payment_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Record a chargeback  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_payment_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chargeback_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `chargeback_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `chargeback_payment`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `chargeback_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/chargebacks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chargeback_payment_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Record a chargeback  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_payment_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chargeback_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.chargeback_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def chargeback_payment_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Record a chargeback  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_payment_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chargeback_payment_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `chargeback_payment_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `chargeback_payment_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/chargebacks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chargeback_reversal_payment(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Record a chargeback reversal  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_reversal_payment(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chargeback_reversal_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.chargeback_reversal_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def chargeback_reversal_payment_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Record a chargeback reversal  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_reversal_payment_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chargeback_reversal_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `chargeback_reversal_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `chargeback_reversal_payment`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `chargeback_reversal_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/chargebackReversals', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chargeback_reversal_payment_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Record a chargeback reversal  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_reversal_payment_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chargeback_reversal_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.chargeback_reversal_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def chargeback_reversal_payment_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Record a chargeback reversal  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chargeback_reversal_payment_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chargeback_reversal_payment_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `chargeback_reversal_payment_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `chargeback_reversal_payment_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/chargebackReversals', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_transaction(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Complete an existing transaction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_transaction_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_transaction_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def complete_transaction_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Complete an existing transaction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `complete_transaction`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `complete_transaction`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `complete_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_transaction_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Complete an existing transaction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_transaction_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_transaction_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def complete_transaction_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Complete an existing transaction  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_transaction_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_transaction_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `complete_transaction_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `complete_transaction_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_combo_payment(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Combo api to create a new payment transaction on a existing (or not) account   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_combo_payment(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComboPaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_combo_payment_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_combo_payment_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_combo_payment_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Combo api to create a new payment transaction on a existing (or not) account   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_combo_payment_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ComboPaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_combo_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_combo_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_combo_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/combo', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_payment_custom_fields(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Add custom fields to payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_custom_fields(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def create_payment_custom_fields_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Add custom fields to payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payment_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_payment_custom_fields`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `create_payment_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/customFields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_payment_tags(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Add tags to payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_tags(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payment_tags_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payment_tags_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def create_payment_tags_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Add tags to payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_tags_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payment_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_payment_tags`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `create_payment_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payment_custom_fields(self, payment_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_custom_fields(payment_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payment_custom_fields_with_http_info(payment_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payment_custom_fields_with_http_info(payment_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_payment_custom_fields_with_http_info(self, payment_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_custom_fields_with_http_info(payment_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id', 'x_killbill_created_by', 'custom_field', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payment_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `delete_payment_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_payment_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'custom_field' in params:
            query_params.append(('customField', params['custom_field']))  # noqa: E501
            collection_formats['customField'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/customFields', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payment_tags(self, payment_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_tags(payment_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payment_tags_with_http_info(payment_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payment_tags_with_http_info(payment_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_payment_tags_with_http_info(self, payment_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from payment payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_tags_with_http_info(payment_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id', 'x_killbill_created_by', 'tag_def', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payment_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `delete_payment_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_payment_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'tag_def' in params:
            query_params.append(('tagDef', params['tag_def']))  # noqa: E501
            collection_formats['tagDef'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve a payment by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_with_http_info(payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_with_http_info(payment_id, **kwargs)  # noqa: E501
            return data

    def get_payment_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve a payment by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id', 'with_plugin_info', 'with_attempts', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `get_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'with_attempts' in params:
            query_params.append(('withAttempts', params['with_attempts']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_attempt_audit_logs_with_history(self, payment_attempt_id, **kwargs):  # noqa: E501
        """Retrieve payment attempt audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_attempt_audit_logs_with_history(payment_attempt_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_attempt_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_attempt_audit_logs_with_history_with_http_info(payment_attempt_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_attempt_audit_logs_with_history_with_http_info(payment_attempt_id, **kwargs)  # noqa: E501
            return data

    def get_payment_attempt_audit_logs_with_history_with_http_info(self, payment_attempt_id, **kwargs):  # noqa: E501
        """Retrieve payment attempt audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_attempt_audit_logs_with_history_with_http_info(payment_attempt_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_attempt_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_attempt_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_attempt_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_attempt_id' is set
        if ('payment_attempt_id' not in params or
                params['payment_attempt_id'] is None):
            raise ValueError("Missing the required parameter `payment_attempt_id` when calling `get_payment_attempt_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_attempt_id' in params:
            path_params['paymentAttemptId'] = params['payment_attempt_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/attempts/{paymentAttemptId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_audit_logs_with_history(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_audit_logs_with_history(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_audit_logs_with_history_with_http_info(payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_audit_logs_with_history_with_http_info(payment_id, **kwargs)  # noqa: E501
            return data

    def get_payment_audit_logs_with_history_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_audit_logs_with_history_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `get_payment_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_by_external_key(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a payment by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_by_external_key(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_by_external_key_with_http_info(external_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_by_external_key_with_http_info(external_key, **kwargs)  # noqa: E501
            return data

    def get_payment_by_external_key_with_http_info(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a payment by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_by_external_key_with_http_info(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_key', 'with_plugin_info', 'with_attempts', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_key' is set
        if ('external_key' not in params or
                params['external_key'] is None):
            raise ValueError("Missing the required parameter `external_key` when calling `get_payment_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'with_attempts' in params:
            query_params.append(('withAttempts', params['with_attempts']))  # noqa: E501
        if 'external_key' in params:
            query_params.append(('externalKey', params['external_key']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_custom_fields(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_custom_fields(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_custom_fields_with_http_info(payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_custom_fields_with_http_info(payment_id, **kwargs)  # noqa: E501
            return data

    def get_payment_custom_fields_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_custom_fields_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `get_payment_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_tags(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment payment tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_tags(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_tags_with_http_info(payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_tags_with_http_info(payment_id, **kwargs)  # noqa: E501
            return data

    def get_payment_tags_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Retrieve payment payment tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_tags_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id', 'included_deleted', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `get_payment_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments(self, **kwargs):  # noqa: E501
        """Get payments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payments_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_payments_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_payments_with_http_info(self, **kwargs):  # noqa: E501
        """Get payments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'plugin_name', 'with_plugin_info', 'with_attempts', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'plugin_name' in params:
            query_params.append(('pluginName', params['plugin_name']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'with_attempts' in params:
            query_params.append(('withAttempts', params['with_attempts']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/pagination', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_payment_custom_fields(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Modify custom fields to payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_payment_custom_fields(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def modify_payment_custom_fields_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Modify custom fields to payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_payment_custom_fields_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_payment_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_payment_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `modify_payment_custom_fields`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `modify_payment_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refund_payment(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Refund an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_payment(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refund_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.refund_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def refund_payment_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Refund an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_payment_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refund_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `refund_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `refund_payment`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `refund_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}/refunds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refund_payment_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Refund an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_payment_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refund_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.refund_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def refund_payment_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Refund an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_payment_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refund_payment_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `refund_payment_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `refund_payment_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/refunds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_payments(self, search_key, **kwargs):  # noqa: E501
        """Search payments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_payments(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param str plugin_name:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_payments_with_http_info(search_key, **kwargs)  # noqa: E501
        else:
            (data) = self.search_payments_with_http_info(search_key, **kwargs)  # noqa: E501
            return data

    def search_payments_with_http_info(self, search_key, **kwargs):  # noqa: E501
        """Search payments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_payments_with_http_info(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param str plugin_name:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_key', 'offset', 'limit', 'with_plugin_info', 'with_attempts', 'plugin_name', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_payments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_key' is set
        if ('search_key' not in params or
                params['search_key'] is None):
            raise ValueError("Missing the required parameter `search_key` when calling `search_payments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'search_key' in params:
            path_params['searchKey'] = params['search_key']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'with_attempts' in params:
            query_params.append(('withAttempts', params['with_attempts']))  # noqa: E501
        if 'plugin_name' in params:
            query_params.append(('pluginName', params['plugin_name']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/search/{searchKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def void_payment(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Void an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_payment(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.void_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.void_payment_with_http_info(body, x_killbill_created_by, payment_id, **kwargs)  # noqa: E501
            return data

    def void_payment_with_http_info(self, body, x_killbill_created_by, payment_id, **kwargs):  # noqa: E501
        """Void an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_payment_with_http_info(body, x_killbill_created_by, payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_id', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method void_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `void_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `void_payment`")  # noqa: E501
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `void_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments/{paymentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def void_payment_by_external_key(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Void an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_payment_by_external_key(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.void_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.void_payment_by_external_key_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def void_payment_by_external_key_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Void an existing payment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_payment_by_external_key_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentTransaction body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method void_payment_by_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `void_payment_by_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `void_payment_by_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/payments', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
