# forestvpn-killbill
Kill Bill is an open-source billing and payments platform

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.22.0
- Package version: 0.0.2
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/forestvpn/killbill.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/forestvpn/killbill.git`)

Then import the package:
```python
import killbill 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import killbill
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import killbill
from killbill.rest import ApiException
from pprint import pprint

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.BlockingState() # BlockingState | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)
requested_date = '2013-10-20' # date |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)

try:
    # Block an account
    api_response = api_instance.add_account_blocking_state(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment, requested_date=requested_date, plugin_property=plugin_property)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->add_account_blocking_state: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.AccountEmail() # AccountEmail | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Add account email
    api_response = api_instance.add_email(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->add_email: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
cancel_all_subscriptions = false # bool |  (optional) (default to false)
write_off_unpaid_invoices = false # bool |  (optional) (default to false)
item_adjust_unpaid_invoices = false # bool |  (optional) (default to false)
remove_future_notifications = true # bool |  (optional) (default to true)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Close account
    api_instance.close_account(account_id, x_killbill_created_by, cancel_all_subscriptions=cancel_all_subscriptions, write_off_unpaid_invoices=write_off_unpaid_invoices, item_adjust_unpaid_invoices=item_adjust_unpaid_invoices, remove_future_notifications=remove_future_notifications, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->close_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.Account() # Account | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Create account
    api_response = api_instance.create_account(body, x_killbill_created_by, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->create_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = [killbill.CustomField()] # list[CustomField] | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Add custom fields to account
    api_response = api_instance.create_account_custom_fields(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->create_account_custom_fields: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = ['body_example'] # list[str] | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Add tags to account
    api_response = api_instance.create_account_tags(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->create_account_tags: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.PaymentMethod() # PaymentMethod | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)
is_default = false # bool |  (optional) (default to false)
pay_all_unpaid_invoices = false # bool |  (optional) (default to false)
control_plugin_name = ['control_plugin_name_example'] # list[str] |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)

try:
    # Add a payment method
    api_response = api_instance.create_payment_method(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment, is_default=is_default, pay_all_unpaid_invoices=pay_all_unpaid_invoices, control_plugin_name=control_plugin_name, plugin_property=plugin_property)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->create_payment_method: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
custom_field = ['custom_field_example'] # list[str] |  (optional)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Remove custom fields from account
    api_instance.delete_account_custom_fields(account_id, x_killbill_created_by, custom_field=custom_field, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->delete_account_custom_fields: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
tag_def = ['tag_def_example'] # list[str] |  (optional)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Remove tags from account
    api_instance.delete_account_tags(account_id, x_killbill_created_by, tag_def=tag_def, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->delete_account_tags: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
account_with_balance = false # bool |  (optional) (default to false)
account_with_balance_and_cba = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve an account by id
    api_response = api_instance.get_account(account_id, account_with_balance=account_with_balance, account_with_balance_and_cba=account_with_balance_and_cba, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve audit logs by account id
    api_response = api_instance.get_account_audit_logs(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_audit_logs: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve account audit logs with history by account id
    api_response = api_instance.get_account_audit_logs_with_history(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_audit_logs_with_history: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
external_key = 'external_key_example' # str |  (optional)
bundles_filter = 'bundles_filter_example' # str |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve bundles for account
    api_response = api_instance.get_account_bundles(account_id, external_key=external_key, bundles_filter=bundles_filter, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_bundles: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
external_key = 'external_key_example' # str | 
account_with_balance = false # bool |  (optional) (default to false)
account_with_balance_and_cba = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve an account by external key
    api_response = api_instance.get_account_by_key(external_key, account_with_balance=account_with_balance, account_with_balance_and_cba=account_with_balance_and_cba, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_by_key: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account custom fields
    api_response = api_instance.get_account_custom_fields(account_id, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_custom_fields: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
account_email_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve account email audit logs with history by id
    api_response = api_instance.get_account_email_audit_logs_with_history(account_id, account_email_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_email_audit_logs_with_history: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
included_deleted = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account tags
    api_response = api_instance.get_account_tags(account_id, included_deleted=included_deleted, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_tags: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
parallel = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account timeline
    api_response = api_instance.get_account_timeline(account_id, parallel=parallel, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_account_timeline: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
offset = 0 # int |  (optional) (default to 0)
limit = 100 # int |  (optional) (default to 100)
account_with_balance = false # bool |  (optional) (default to false)
account_with_balance_and_cba = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # List accounts
    api_response = api_instance.get_accounts(offset=offset, limit=limit, account_with_balance=account_with_balance, account_with_balance_and_cba=account_with_balance_and_cba, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_accounts: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
object_type = 'object_type_example' # str |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account customFields
    api_response = api_instance.get_all_custom_fields(account_id, object_type=object_type, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_all_custom_fields: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
object_type = 'object_type_example' # str |  (optional)
included_deleted = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account tags
    api_response = api_instance.get_all_tags(account_id, object_type=object_type, included_deleted=included_deleted, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_all_tags: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
blocking_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve blocking state audit logs with history by id
    api_response = api_instance.get_blocking_state_audit_logs_with_history(blocking_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_blocking_state_audit_logs_with_history: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
blocking_state_types = ['blocking_state_types_example'] # list[str] |  (optional)
blocking_state_svcs = ['blocking_state_svcs_example'] # list[str] |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve blocking states for account
    api_response = api_instance.get_blocking_states(account_id, blocking_state_types=blocking_state_types, blocking_state_svcs=blocking_state_svcs, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_blocking_states: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
account_with_balance = false # bool |  (optional) (default to false)
account_with_balance_and_cba = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # List children accounts
    api_response = api_instance.get_children_accounts(account_id, account_with_balance=account_with_balance, account_with_balance_and_cba=account_with_balance_and_cba, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_children_accounts: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve an account emails
    api_response = api_instance.get_emails(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_emails: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
with_plugin_info = false # bool |  (optional) (default to false)
with_attempts = false # bool |  (optional) (default to false)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account invoice payments
    api_response = api_instance.get_invoice_payments(account_id, with_plugin_info=with_plugin_info, with_attempts=with_attempts, plugin_property=plugin_property, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_invoice_payments: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
start_date = '2013-10-20' # date |  (optional)
end_date = '2013-10-20' # date |  (optional)
with_migration_invoices = false # bool |  (optional) (default to false)
unpaid_invoices_only = false # bool |  (optional) (default to false)
include_voided_invoices = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account invoices
    api_response = api_instance.get_invoices_for_account(account_id, start_date=start_date, end_date=end_date, with_migration_invoices=with_migration_invoices, unpaid_invoices_only=unpaid_invoices_only, include_voided_invoices=include_voided_invoices, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_invoices_for_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 

try:
    # Retrieve overdue state for account
    api_response = api_instance.get_overdue_account(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_overdue_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
with_plugin_info = false # bool |  (optional) (default to false)
included_deleted = false # bool |  (optional) (default to false)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account payment methods
    api_response = api_instance.get_payment_methods_for_account(account_id, with_plugin_info=with_plugin_info, included_deleted=included_deleted, plugin_property=plugin_property, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_payment_methods_for_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
with_attempts = false # bool |  (optional) (default to false)
with_plugin_info = false # bool |  (optional) (default to false)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Retrieve account payments
    api_response = api_instance.get_payments_for_account(account_id, with_attempts=with_attempts, with_plugin_info=with_plugin_info, plugin_property=plugin_property, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->get_payments_for_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = [killbill.CustomField()] # list[CustomField] | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Modify custom fields to account
    api_instance.modify_account_custom_fields(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->modify_account_custom_fields: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
payment_method_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str |  (optional)
external_payment = false # bool |  (optional) (default to false)
payment_amount = 1.2 # float |  (optional)
target_date = '2013-10-20' # date |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Trigger a payment for all unpaid invoices
    api_instance.pay_all_invoices(account_id, x_killbill_created_by, payment_method_id=payment_method_id, external_payment=external_payment, payment_amount=payment_amount, target_date=target_date, plugin_property=plugin_property, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->pay_all_invoices: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.PaymentTransaction() # PaymentTransaction | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)
payment_method_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str |  (optional)
control_plugin_name = ['control_plugin_name_example'] # list[str] |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)

try:
    # Trigger a payment (authorization, purchase or credit)
    api_response = api_instance.process_payment(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment, payment_method_id=payment_method_id, control_plugin_name=control_plugin_name, plugin_property=plugin_property)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->process_payment: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.PaymentTransaction() # PaymentTransaction | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
external_key = 'external_key_example' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)
payment_method_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str |  (optional)
control_plugin_name = ['control_plugin_name_example'] # list[str] |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)

try:
    # Trigger a payment using the account external key (authorization, purchase or credit)
    api_response = api_instance.process_payment_by_external_key(body, x_killbill_created_by, external_key, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment, payment_method_id=payment_method_id, control_plugin_name=control_plugin_name, plugin_property=plugin_property)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->process_payment_by_external_key: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Rebalance account CBA
    api_instance.rebalance_existing_cba_on_account(account_id, x_killbill_created_by, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->rebalance_existing_cba_on_account: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
plugin_name = 'plugin_name_example' # str |  (optional)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Refresh account payment methods
    api_instance.refresh_payment_methods(account_id, x_killbill_created_by, plugin_name=plugin_name, plugin_property=plugin_property, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->refresh_payment_methods: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
email = 'email_example' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Delete email from account
    api_instance.remove_email(account_id, email, x_killbill_created_by, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->remove_email: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
search_key = 'search_key_example' # str | 
offset = 0 # int |  (optional) (default to 0)
limit = 100 # int |  (optional) (default to 100)
account_with_balance = false # bool |  (optional) (default to false)
account_with_balance_and_cba = false # bool |  (optional) (default to false)
audit = 'NONE' # str |  (optional) (default to NONE)

try:
    # Search accounts
    api_response = api_instance.search_accounts(search_key, offset=offset, limit=limit, account_with_balance=account_with_balance, account_with_balance_and_cba=account_with_balance_and_cba, audit=audit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->search_accounts: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
payment_method_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
pay_all_unpaid_invoices = false # bool |  (optional) (default to false)
plugin_property = ['plugin_property_example'] # list[str] |  (optional)
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Set the default payment method
    api_instance.set_default_payment_method(account_id, payment_method_id, x_killbill_created_by, pay_all_unpaid_invoices=pay_all_unpaid_invoices, plugin_property=plugin_property, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->set_default_payment_method: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
child_account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)

try:
    # Move a given child credit to the parent level
    api_instance.transfer_child_credit_to_parent(child_account_id, x_killbill_created_by, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment)
except ApiException as e:
    print("Exception when calling AccountApi->transfer_child_credit_to_parent: %s\n" % e)

# Configure API key authorization: Killbill Api Key
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiKey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiKey'] = 'Bearer'
# Configure API key authorization: Killbill Api Secret
configuration = killbill.Configuration()
configuration.api_key['X-Killbill-ApiSecret'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Killbill-ApiSecret'] = 'Bearer'# Configure HTTP basic authorization: basicAuth
configuration = killbill.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = killbill.AccountApi(killbill.ApiClient(configuration))
body = killbill.Account() # Account | 
x_killbill_created_by = 'x_killbill_created_by_example' # str | 
account_id = '38400000-8cf0-11bd-b23e-10b96e4ef00d' # str | 
x_killbill_reason = 'x_killbill_reason_example' # str |  (optional)
x_killbill_comment = 'x_killbill_comment_example' # str |  (optional)
treat_null_as_reset = false # bool |  (optional) (default to false)

try:
    # Update account
    api_instance.update_account(body, x_killbill_created_by, account_id, x_killbill_reason=x_killbill_reason, x_killbill_comment=x_killbill_comment, treat_null_as_reset=treat_null_as_reset)
except ApiException as e:
    print("Exception when calling AccountApi->update_account: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**add_account_blocking_state**](docs/AccountApi.md#add_account_blocking_state) | **POST** /1.0/kb/accounts/{accountId}/block | Block an account
*AccountApi* | [**add_email**](docs/AccountApi.md#add_email) | **POST** /1.0/kb/accounts/{accountId}/emails | Add account email
*AccountApi* | [**close_account**](docs/AccountApi.md#close_account) | **DELETE** /1.0/kb/accounts/{accountId} | Close account
*AccountApi* | [**create_account**](docs/AccountApi.md#create_account) | **POST** /1.0/kb/accounts | Create account
*AccountApi* | [**create_account_custom_fields**](docs/AccountApi.md#create_account_custom_fields) | **POST** /1.0/kb/accounts/{accountId}/customFields | Add custom fields to account
*AccountApi* | [**create_account_tags**](docs/AccountApi.md#create_account_tags) | **POST** /1.0/kb/accounts/{accountId}/tags | Add tags to account
*AccountApi* | [**create_payment_method**](docs/AccountApi.md#create_payment_method) | **POST** /1.0/kb/accounts/{accountId}/paymentMethods | Add a payment method
*AccountApi* | [**delete_account_custom_fields**](docs/AccountApi.md#delete_account_custom_fields) | **DELETE** /1.0/kb/accounts/{accountId}/customFields | Remove custom fields from account
*AccountApi* | [**delete_account_tags**](docs/AccountApi.md#delete_account_tags) | **DELETE** /1.0/kb/accounts/{accountId}/tags | Remove tags from account
*AccountApi* | [**get_account**](docs/AccountApi.md#get_account) | **GET** /1.0/kb/accounts/{accountId} | Retrieve an account by id
*AccountApi* | [**get_account_audit_logs**](docs/AccountApi.md#get_account_audit_logs) | **GET** /1.0/kb/accounts/{accountId}/auditLogs | Retrieve audit logs by account id
*AccountApi* | [**get_account_audit_logs_with_history**](docs/AccountApi.md#get_account_audit_logs_with_history) | **GET** /1.0/kb/accounts/{accountId}/auditLogsWithHistory | Retrieve account audit logs with history by account id
*AccountApi* | [**get_account_bundles**](docs/AccountApi.md#get_account_bundles) | **GET** /1.0/kb/accounts/{accountId}/bundles | Retrieve bundles for account
*AccountApi* | [**get_account_by_key**](docs/AccountApi.md#get_account_by_key) | **GET** /1.0/kb/accounts | Retrieve an account by external key
*AccountApi* | [**get_account_custom_fields**](docs/AccountApi.md#get_account_custom_fields) | **GET** /1.0/kb/accounts/{accountId}/customFields | Retrieve account custom fields
*AccountApi* | [**get_account_email_audit_logs_with_history**](docs/AccountApi.md#get_account_email_audit_logs_with_history) | **GET** /1.0/kb/accounts/{accountId}/emails/{accountEmailId}/auditLogsWithHistory | Retrieve account email audit logs with history by id
*AccountApi* | [**get_account_tags**](docs/AccountApi.md#get_account_tags) | **GET** /1.0/kb/accounts/{accountId}/tags | Retrieve account tags
*AccountApi* | [**get_account_timeline**](docs/AccountApi.md#get_account_timeline) | **GET** /1.0/kb/accounts/{accountId}/timeline | Retrieve account timeline
*AccountApi* | [**get_accounts**](docs/AccountApi.md#get_accounts) | **GET** /1.0/kb/accounts/pagination | List accounts
*AccountApi* | [**get_all_custom_fields**](docs/AccountApi.md#get_all_custom_fields) | **GET** /1.0/kb/accounts/{accountId}/allCustomFields | Retrieve account customFields
*AccountApi* | [**get_all_tags**](docs/AccountApi.md#get_all_tags) | **GET** /1.0/kb/accounts/{accountId}/allTags | Retrieve account tags
*AccountApi* | [**get_blocking_state_audit_logs_with_history**](docs/AccountApi.md#get_blocking_state_audit_logs_with_history) | **GET** /1.0/kb/accounts/block/{blockingId}/auditLogsWithHistory | Retrieve blocking state audit logs with history by id
*AccountApi* | [**get_blocking_states**](docs/AccountApi.md#get_blocking_states) | **GET** /1.0/kb/accounts/{accountId}/block | Retrieve blocking states for account
*AccountApi* | [**get_children_accounts**](docs/AccountApi.md#get_children_accounts) | **GET** /1.0/kb/accounts/{accountId}/children | List children accounts
*AccountApi* | [**get_emails**](docs/AccountApi.md#get_emails) | **GET** /1.0/kb/accounts/{accountId}/emails | Retrieve an account emails
*AccountApi* | [**get_invoice_payments**](docs/AccountApi.md#get_invoice_payments) | **GET** /1.0/kb/accounts/{accountId}/invoicePayments | Retrieve account invoice payments
*AccountApi* | [**get_invoices_for_account**](docs/AccountApi.md#get_invoices_for_account) | **GET** /1.0/kb/accounts/{accountId}/invoices | Retrieve account invoices
*AccountApi* | [**get_overdue_account**](docs/AccountApi.md#get_overdue_account) | **GET** /1.0/kb/accounts/{accountId}/overdue | Retrieve overdue state for account
*AccountApi* | [**get_payment_methods_for_account**](docs/AccountApi.md#get_payment_methods_for_account) | **GET** /1.0/kb/accounts/{accountId}/paymentMethods | Retrieve account payment methods
*AccountApi* | [**get_payments_for_account**](docs/AccountApi.md#get_payments_for_account) | **GET** /1.0/kb/accounts/{accountId}/payments | Retrieve account payments
*AccountApi* | [**modify_account_custom_fields**](docs/AccountApi.md#modify_account_custom_fields) | **PUT** /1.0/kb/accounts/{accountId}/customFields | Modify custom fields to account
*AccountApi* | [**pay_all_invoices**](docs/AccountApi.md#pay_all_invoices) | **POST** /1.0/kb/accounts/{accountId}/invoicePayments | Trigger a payment for all unpaid invoices
*AccountApi* | [**process_payment**](docs/AccountApi.md#process_payment) | **POST** /1.0/kb/accounts/{accountId}/payments | Trigger a payment (authorization, purchase or credit)
*AccountApi* | [**process_payment_by_external_key**](docs/AccountApi.md#process_payment_by_external_key) | **POST** /1.0/kb/accounts/payments | Trigger a payment using the account external key (authorization, purchase or credit)
*AccountApi* | [**rebalance_existing_cba_on_account**](docs/AccountApi.md#rebalance_existing_cba_on_account) | **PUT** /1.0/kb/accounts/{accountId}/cbaRebalancing | Rebalance account CBA
*AccountApi* | [**refresh_payment_methods**](docs/AccountApi.md#refresh_payment_methods) | **PUT** /1.0/kb/accounts/{accountId}/paymentMethods/refresh | Refresh account payment methods
*AccountApi* | [**remove_email**](docs/AccountApi.md#remove_email) | **DELETE** /1.0/kb/accounts/{accountId}/emails/{email} | Delete email from account
*AccountApi* | [**search_accounts**](docs/AccountApi.md#search_accounts) | **GET** /1.0/kb/accounts/search/{searchKey} | Search accounts
*AccountApi* | [**set_default_payment_method**](docs/AccountApi.md#set_default_payment_method) | **PUT** /1.0/kb/accounts/{accountId}/paymentMethods/{paymentMethodId}/setDefault | Set the default payment method
*AccountApi* | [**transfer_child_credit_to_parent**](docs/AccountApi.md#transfer_child_credit_to_parent) | **PUT** /1.0/kb/accounts/{childAccountId}/transferCredit | Move a given child credit to the parent level
*AccountApi* | [**update_account**](docs/AccountApi.md#update_account) | **PUT** /1.0/kb/accounts/{accountId} | Update account
*AdminApi* | [**get_queue_entries**](docs/AdminApi.md#get_queue_entries) | **GET** /1.0/kb/admin/queues | Get queues entries
*AdminApi* | [**invalidates_cache**](docs/AdminApi.md#invalidates_cache) | **DELETE** /1.0/kb/admin/cache | Invalidates the given Cache if specified, otherwise invalidates all caches
*AdminApi* | [**invalidates_cache_by_account**](docs/AdminApi.md#invalidates_cache_by_account) | **DELETE** /1.0/kb/admin/cache/accounts/{accountId} | Invalidates Caches per account level
*AdminApi* | [**invalidates_cache_by_tenant**](docs/AdminApi.md#invalidates_cache_by_tenant) | **DELETE** /1.0/kb/admin/cache/tenants | Invalidates Caches per tenant level
*AdminApi* | [**put_in_rotation**](docs/AdminApi.md#put_in_rotation) | **PUT** /1.0/kb/admin/healthcheck | Put the host back into rotation
*AdminApi* | [**put_out_of_rotation**](docs/AdminApi.md#put_out_of_rotation) | **DELETE** /1.0/kb/admin/healthcheck | Put the host out of rotation
*AdminApi* | [**trigger_invoice_generation_for_parked_accounts**](docs/AdminApi.md#trigger_invoice_generation_for_parked_accounts) | **POST** /1.0/kb/admin/invoices | Trigger an invoice generation for all parked accounts
*AdminApi* | [**update_payment_transaction_state**](docs/AdminApi.md#update_payment_transaction_state) | **PUT** /1.0/kb/admin/payments/{paymentId}/transactions/{paymentTransactionId} | Update existing paymentTransaction and associated payment state
*BundleApi* | [**add_bundle_blocking_state**](docs/BundleApi.md#add_bundle_blocking_state) | **POST** /1.0/kb/bundles/{bundleId}/block | Block a bundle
*BundleApi* | [**create_bundle_custom_fields**](docs/BundleApi.md#create_bundle_custom_fields) | **POST** /1.0/kb/bundles/{bundleId}/customFields | Add custom fields to bundle
*BundleApi* | [**create_bundle_tags**](docs/BundleApi.md#create_bundle_tags) | **POST** /1.0/kb/bundles/{bundleId}/tags | Add tags to bundle
*BundleApi* | [**delete_bundle_custom_fields**](docs/BundleApi.md#delete_bundle_custom_fields) | **DELETE** /1.0/kb/bundles/{bundleId}/customFields | Remove custom fields from bundle
*BundleApi* | [**delete_bundle_tags**](docs/BundleApi.md#delete_bundle_tags) | **DELETE** /1.0/kb/bundles/{bundleId}/tags | Remove tags from bundle
*BundleApi* | [**get_bundle**](docs/BundleApi.md#get_bundle) | **GET** /1.0/kb/bundles/{bundleId} | Retrieve a bundle by id
*BundleApi* | [**get_bundle_audit_logs_with_history**](docs/BundleApi.md#get_bundle_audit_logs_with_history) | **GET** /1.0/kb/bundles/{bundleId}/auditLogsWithHistory | Retrieve bundle audit logs with history by id
*BundleApi* | [**get_bundle_by_key**](docs/BundleApi.md#get_bundle_by_key) | **GET** /1.0/kb/bundles | Retrieve a bundle by external key
*BundleApi* | [**get_bundle_custom_fields**](docs/BundleApi.md#get_bundle_custom_fields) | **GET** /1.0/kb/bundles/{bundleId}/customFields | Retrieve bundle custom fields
*BundleApi* | [**get_bundle_tags**](docs/BundleApi.md#get_bundle_tags) | **GET** /1.0/kb/bundles/{bundleId}/tags | Retrieve bundle tags
*BundleApi* | [**get_bundles**](docs/BundleApi.md#get_bundles) | **GET** /1.0/kb/bundles/pagination | List bundles
*BundleApi* | [**modify_bundle_custom_fields**](docs/BundleApi.md#modify_bundle_custom_fields) | **PUT** /1.0/kb/bundles/{bundleId}/customFields | Modify custom fields to bundle
*BundleApi* | [**pause_bundle**](docs/BundleApi.md#pause_bundle) | **PUT** /1.0/kb/bundles/{bundleId}/pause | Pause a bundle
*BundleApi* | [**rename_external_key**](docs/BundleApi.md#rename_external_key) | **PUT** /1.0/kb/bundles/{bundleId}/renameKey | Update a bundle externalKey
*BundleApi* | [**resume_bundle**](docs/BundleApi.md#resume_bundle) | **PUT** /1.0/kb/bundles/{bundleId}/resume | Resume a bundle
*BundleApi* | [**search_bundles**](docs/BundleApi.md#search_bundles) | **GET** /1.0/kb/bundles/search/{searchKey} | Search bundles
*BundleApi* | [**transfer_bundle**](docs/BundleApi.md#transfer_bundle) | **POST** /1.0/kb/bundles/{bundleId} | Transfer a bundle to another account
*CatalogApi* | [**add_simple_plan**](docs/CatalogApi.md#add_simple_plan) | **POST** /1.0/kb/catalog/simplePlan | Add a simple plan entry in the current version of the catalog
*CatalogApi* | [**delete_catalog**](docs/CatalogApi.md#delete_catalog) | **DELETE** /1.0/kb/catalog | Delete all versions for a per tenant catalog
*CatalogApi* | [**get_available_addons**](docs/CatalogApi.md#get_available_addons) | **GET** /1.0/kb/catalog/availableAddons | Retrieve available add-ons for a given product
*CatalogApi* | [**get_available_base_plans**](docs/CatalogApi.md#get_available_base_plans) | **GET** /1.0/kb/catalog/availableBasePlans | Retrieve available base plans
*CatalogApi* | [**get_catalog_json**](docs/CatalogApi.md#get_catalog_json) | **GET** /1.0/kb/catalog | Retrieve the catalog as JSON
*CatalogApi* | [**get_catalog_versions**](docs/CatalogApi.md#get_catalog_versions) | **GET** /1.0/kb/catalog/versions | Retrieve a list of catalog versions
*CatalogApi* | [**get_catalog_xml**](docs/CatalogApi.md#get_catalog_xml) | **GET** /1.0/kb/catalog/xml | Retrieve the full catalog as XML
*CatalogApi* | [**get_phase_for_subscription_and_date**](docs/CatalogApi.md#get_phase_for_subscription_and_date) | **GET** /1.0/kb/catalog/phase | Retrieve phase for a given subscription and date
*CatalogApi* | [**get_plan_for_subscription_and_date**](docs/CatalogApi.md#get_plan_for_subscription_and_date) | **GET** /1.0/kb/catalog/plan | Retrieve plan for a given subscription and date
*CatalogApi* | [**get_price_list_for_subscription_and_date**](docs/CatalogApi.md#get_price_list_for_subscription_and_date) | **GET** /1.0/kb/catalog/priceList | Retrieve priceList for a given subscription and date
*CatalogApi* | [**get_product_for_subscription_and_date**](docs/CatalogApi.md#get_product_for_subscription_and_date) | **GET** /1.0/kb/catalog/product | Retrieve product for a given subscription and date
*CatalogApi* | [**upload_catalog_xml**](docs/CatalogApi.md#upload_catalog_xml) | **POST** /1.0/kb/catalog/xml | Upload the full catalog as XML
*CreditApi* | [**create_credits**](docs/CreditApi.md#create_credits) | **POST** /1.0/kb/credits | Create a credit
*CreditApi* | [**get_credit**](docs/CreditApi.md#get_credit) | **GET** /1.0/kb/credits/{creditId} | Retrieve a credit by id
*CustomFieldApi* | [**get_custom_field_audit_logs_with_history**](docs/CustomFieldApi.md#get_custom_field_audit_logs_with_history) | **GET** /1.0/kb/customFields/{customFieldId}/auditLogsWithHistory | Retrieve custom field audit logs with history by id
*CustomFieldApi* | [**get_custom_fields**](docs/CustomFieldApi.md#get_custom_fields) | **GET** /1.0/kb/customFields/pagination | List custom fields
*CustomFieldApi* | [**search_custom_fields**](docs/CustomFieldApi.md#search_custom_fields) | **GET** /1.0/kb/customFields/search/{searchKey} | Search custom fields
*CustomFieldApi* | [**search_custom_fields_by_type_name**](docs/CustomFieldApi.md#search_custom_fields_by_type_name) | **GET** /1.0/kb/customFields/search | Search custom fields by type, name and optional value
*ExportApi* | [**export_data_for_account**](docs/ExportApi.md#export_data_for_account) | **GET** /1.0/kb/export/{accountId} | Export account data
*InvoiceApi* | [**adjust_invoice_item**](docs/InvoiceApi.md#adjust_invoice_item) | **POST** /1.0/kb/invoices/{invoiceId} | Adjust an invoice item
*InvoiceApi* | [**commit_invoice**](docs/InvoiceApi.md#commit_invoice) | **PUT** /1.0/kb/invoices/{invoiceId}/commitInvoice | Perform the invoice status transition from DRAFT to COMMITTED
*InvoiceApi* | [**create_external_charges**](docs/InvoiceApi.md#create_external_charges) | **POST** /1.0/kb/invoices/charges/{accountId} | Create external charge(s)
*InvoiceApi* | [**create_future_invoice**](docs/InvoiceApi.md#create_future_invoice) | **POST** /1.0/kb/invoices | Trigger an invoice generation
*InvoiceApi* | [**create_instant_payment**](docs/InvoiceApi.md#create_instant_payment) | **POST** /1.0/kb/invoices/{invoiceId}/payments | Trigger a payment for invoice
*InvoiceApi* | [**create_invoice_custom_fields**](docs/InvoiceApi.md#create_invoice_custom_fields) | **POST** /1.0/kb/invoices/{invoiceId}/customFields | Add custom fields to invoice
*InvoiceApi* | [**create_invoice_tags**](docs/InvoiceApi.md#create_invoice_tags) | **POST** /1.0/kb/invoices/{invoiceId}/tags | Add tags to invoice
*InvoiceApi* | [**create_migration_invoice**](docs/InvoiceApi.md#create_migration_invoice) | **POST** /1.0/kb/invoices/migration/{accountId} | Create a migration invoice
*InvoiceApi* | [**create_tax_items**](docs/InvoiceApi.md#create_tax_items) | **POST** /1.0/kb/invoices/taxes/{accountId} | Create tax items
*InvoiceApi* | [**delete_cba**](docs/InvoiceApi.md#delete_cba) | **DELETE** /1.0/kb/invoices/{invoiceId}/{invoiceItemId}/cba | Delete a CBA item
*InvoiceApi* | [**delete_invoice_custom_fields**](docs/InvoiceApi.md#delete_invoice_custom_fields) | **DELETE** /1.0/kb/invoices/{invoiceId}/customFields | Remove custom fields from invoice
*InvoiceApi* | [**delete_invoice_tags**](docs/InvoiceApi.md#delete_invoice_tags) | **DELETE** /1.0/kb/invoices/{invoiceId}/tags | Remove tags from invoice
*InvoiceApi* | [**generate_dry_run_invoice**](docs/InvoiceApi.md#generate_dry_run_invoice) | **POST** /1.0/kb/invoices/dryRun | Generate a dryRun invoice
*InvoiceApi* | [**get_catalog_translation**](docs/InvoiceApi.md#get_catalog_translation) | **GET** /1.0/kb/invoices/catalogTranslation/{locale} | Retrieves the catalog translation for the tenant
*InvoiceApi* | [**get_invoice**](docs/InvoiceApi.md#get_invoice) | **GET** /1.0/kb/invoices/{invoiceId} | Retrieve an invoice by id
*InvoiceApi* | [**get_invoice_as_html**](docs/InvoiceApi.md#get_invoice_as_html) | **GET** /1.0/kb/invoices/{invoiceId}/html | Render an invoice as HTML
*InvoiceApi* | [**get_invoice_audit_logs_with_history**](docs/InvoiceApi.md#get_invoice_audit_logs_with_history) | **GET** /1.0/kb/invoices/{invoiceId}/auditLogsWithHistory | Retrieve invoice audit logs with history by id
*InvoiceApi* | [**get_invoice_by_item_id**](docs/InvoiceApi.md#get_invoice_by_item_id) | **GET** /1.0/kb/invoices/byItemId/{itemId} | Retrieve an invoice by invoice item id
*InvoiceApi* | [**get_invoice_by_number**](docs/InvoiceApi.md#get_invoice_by_number) | **GET** /1.0/kb/invoices/byNumber/{invoiceNumber} | Retrieve an invoice by number
*InvoiceApi* | [**get_invoice_custom_fields**](docs/InvoiceApi.md#get_invoice_custom_fields) | **GET** /1.0/kb/invoices/{invoiceId}/customFields | Retrieve invoice custom fields
*InvoiceApi* | [**get_invoice_mp_template**](docs/InvoiceApi.md#get_invoice_mp_template) | **GET** /1.0/kb/invoices/manualPayTemplate/{locale} | Retrieves the manualPay invoice template for the tenant
*InvoiceApi* | [**get_invoice_tags**](docs/InvoiceApi.md#get_invoice_tags) | **GET** /1.0/kb/invoices/{invoiceId}/tags | Retrieve invoice tags
*InvoiceApi* | [**get_invoice_template**](docs/InvoiceApi.md#get_invoice_template) | **GET** /1.0/kb/invoices/template | Retrieves the invoice template for the tenant
*InvoiceApi* | [**get_invoice_translation**](docs/InvoiceApi.md#get_invoice_translation) | **GET** /1.0/kb/invoices/translation/{locale} | Retrieves the invoice translation for the tenant
*InvoiceApi* | [**get_invoices**](docs/InvoiceApi.md#get_invoices) | **GET** /1.0/kb/invoices/pagination | List invoices
*InvoiceApi* | [**get_payments_for_invoice**](docs/InvoiceApi.md#get_payments_for_invoice) | **GET** /1.0/kb/invoices/{invoiceId}/payments | Retrieve payments associated with an invoice
*InvoiceApi* | [**modify_invoice_custom_fields**](docs/InvoiceApi.md#modify_invoice_custom_fields) | **PUT** /1.0/kb/invoices/{invoiceId}/customFields | Modify custom fields to invoice
*InvoiceApi* | [**search_invoices**](docs/InvoiceApi.md#search_invoices) | **GET** /1.0/kb/invoices/search/{searchKey} | Search invoices
*InvoiceApi* | [**upload_catalog_translation**](docs/InvoiceApi.md#upload_catalog_translation) | **POST** /1.0/kb/invoices/catalogTranslation/{locale} | Upload the catalog translation for the tenant
*InvoiceApi* | [**upload_invoice_mp_template**](docs/InvoiceApi.md#upload_invoice_mp_template) | **POST** /1.0/kb/invoices/manualPayTemplate | Upload the manualPay invoice template for the tenant
*InvoiceApi* | [**upload_invoice_template**](docs/InvoiceApi.md#upload_invoice_template) | **POST** /1.0/kb/invoices/template | Upload the invoice template for the tenant
*InvoiceApi* | [**upload_invoice_translation**](docs/InvoiceApi.md#upload_invoice_translation) | **POST** /1.0/kb/invoices/translation/{locale} | Upload the invoice translation for the tenant
*InvoiceApi* | [**void_invoice**](docs/InvoiceApi.md#void_invoice) | **PUT** /1.0/kb/invoices/{invoiceId}/voidInvoice | Perform the action of voiding an invoice
*InvoiceItemApi* | [**create_invoice_item_custom_fields**](docs/InvoiceItemApi.md#create_invoice_item_custom_fields) | **POST** /1.0/kb/invoiceItems/{invoiceItemId}/customFields | Add custom fields to invoice item
*InvoiceItemApi* | [**create_invoice_item_tags**](docs/InvoiceItemApi.md#create_invoice_item_tags) | **POST** /1.0/kb/invoiceItems/{invoiceItemId}/tags | Add tags to invoice item
*InvoiceItemApi* | [**delete_invoice_item_custom_fields**](docs/InvoiceItemApi.md#delete_invoice_item_custom_fields) | **DELETE** /1.0/kb/invoiceItems/{invoiceItemId}/customFields | Remove custom fields from invoice item
*InvoiceItemApi* | [**delete_invoice_item_tags**](docs/InvoiceItemApi.md#delete_invoice_item_tags) | **DELETE** /1.0/kb/invoiceItems/{invoiceItemId}/tags | Remove tags from invoice item
*InvoiceItemApi* | [**get_invoice_item_audit_logs_with_history**](docs/InvoiceItemApi.md#get_invoice_item_audit_logs_with_history) | **GET** /1.0/kb/invoiceItems/{invoiceItemId}/auditLogsWithHistory | Retrieve invoice item audit logs with history by id
*InvoiceItemApi* | [**get_invoice_item_custom_fields**](docs/InvoiceItemApi.md#get_invoice_item_custom_fields) | **GET** /1.0/kb/invoiceItems/{invoiceItemId}/customFields | Retrieve invoice item custom fields
*InvoiceItemApi* | [**get_invoice_item_tags**](docs/InvoiceItemApi.md#get_invoice_item_tags) | **GET** /1.0/kb/invoiceItems/{invoiceItemId}/tags | Retrieve invoice item tags
*InvoiceItemApi* | [**modify_invoice_item_custom_fields**](docs/InvoiceItemApi.md#modify_invoice_item_custom_fields) | **PUT** /1.0/kb/invoiceItems/{invoiceItemId}/customFields | Modify custom fields to invoice item
*InvoicePaymentApi* | [**complete_invoice_payment_transaction**](docs/InvoicePaymentApi.md#complete_invoice_payment_transaction) | **PUT** /1.0/kb/invoicePayments/{paymentId} | Complete an existing transaction
*InvoicePaymentApi* | [**create_chargeback**](docs/InvoicePaymentApi.md#create_chargeback) | **POST** /1.0/kb/invoicePayments/{paymentId}/chargebacks | Record a chargeback
*InvoicePaymentApi* | [**create_chargeback_reversal**](docs/InvoicePaymentApi.md#create_chargeback_reversal) | **POST** /1.0/kb/invoicePayments/{paymentId}/chargebackReversals | Record a chargebackReversal
*InvoicePaymentApi* | [**create_invoice_payment_custom_fields**](docs/InvoicePaymentApi.md#create_invoice_payment_custom_fields) | **POST** /1.0/kb/invoicePayments/{paymentId}/customFields | Add custom fields to payment
*InvoicePaymentApi* | [**create_invoice_payment_tags**](docs/InvoicePaymentApi.md#create_invoice_payment_tags) | **POST** /1.0/kb/invoicePayments/{paymentId}/tags | Add tags to payment
*InvoicePaymentApi* | [**create_refund_with_adjustments**](docs/InvoicePaymentApi.md#create_refund_with_adjustments) | **POST** /1.0/kb/invoicePayments/{paymentId}/refunds | Refund a payment, and adjust the invoice if needed
*InvoicePaymentApi* | [**delete_invoice_payment_custom_fields**](docs/InvoicePaymentApi.md#delete_invoice_payment_custom_fields) | **DELETE** /1.0/kb/invoicePayments/{paymentId}/customFields | Remove custom fields from payment
*InvoicePaymentApi* | [**delete_invoice_payment_tags**](docs/InvoicePaymentApi.md#delete_invoice_payment_tags) | **DELETE** /1.0/kb/invoicePayments/{paymentId}/tags | Remove tags from payment
*InvoicePaymentApi* | [**get_invoice_payment**](docs/InvoicePaymentApi.md#get_invoice_payment) | **GET** /1.0/kb/invoicePayments/{paymentId} | Retrieve a payment by id
*InvoicePaymentApi* | [**get_invoice_payment_audit_logs_with_history**](docs/InvoicePaymentApi.md#get_invoice_payment_audit_logs_with_history) | **GET** /1.0/kb/invoicePayments/{invoicePaymentId}/auditLogsWithHistory | Retrieve invoice payment audit logs with history by id
*InvoicePaymentApi* | [**get_invoice_payment_custom_fields**](docs/InvoicePaymentApi.md#get_invoice_payment_custom_fields) | **GET** /1.0/kb/invoicePayments/{paymentId}/customFields | Retrieve payment custom fields
*InvoicePaymentApi* | [**get_invoice_payment_tags**](docs/InvoicePaymentApi.md#get_invoice_payment_tags) | **GET** /1.0/kb/invoicePayments/{paymentId}/tags | Retrieve payment tags
*InvoicePaymentApi* | [**modify_invoice_payment_custom_fields**](docs/InvoicePaymentApi.md#modify_invoice_payment_custom_fields) | **PUT** /1.0/kb/invoicePayments/{paymentId}/customFields | Modify custom fields to payment
*NodesInfoApi* | [**get_nodes_info**](docs/NodesInfoApi.md#get_nodes_info) | **GET** /1.0/kb/nodesInfo | Retrieve all the nodes infos
*NodesInfoApi* | [**trigger_node_command**](docs/NodesInfoApi.md#trigger_node_command) | **POST** /1.0/kb/nodesInfo | Trigger a node command
*OverdueApi* | [**get_overdue_config_json**](docs/OverdueApi.md#get_overdue_config_json) | **GET** /1.0/kb/overdue | Retrieve the overdue config as JSON
*OverdueApi* | [**get_overdue_config_xml**](docs/OverdueApi.md#get_overdue_config_xml) | **GET** /1.0/kb/overdue/xml | Retrieve the overdue config as XML
*OverdueApi* | [**upload_overdue_config_json**](docs/OverdueApi.md#upload_overdue_config_json) | **POST** /1.0/kb/overdue | Upload the full overdue config as JSON
*OverdueApi* | [**upload_overdue_config_xml**](docs/OverdueApi.md#upload_overdue_config_xml) | **POST** /1.0/kb/overdue/xml | Upload the full overdue config as XML
*PaymentApi* | [**cancel_scheduled_payment_transaction_by_external_key**](docs/PaymentApi.md#cancel_scheduled_payment_transaction_by_external_key) | **DELETE** /1.0/kb/payments/cancelScheduledPaymentTransaction | Cancels a scheduled payment attempt retry
*PaymentApi* | [**cancel_scheduled_payment_transaction_by_id**](docs/PaymentApi.md#cancel_scheduled_payment_transaction_by_id) | **DELETE** /1.0/kb/payments/{paymentTransactionId}/cancelScheduledPaymentTransaction | Cancels a scheduled payment attempt retry
*PaymentApi* | [**capture_authorization**](docs/PaymentApi.md#capture_authorization) | **POST** /1.0/kb/payments/{paymentId} | Capture an existing authorization
*PaymentApi* | [**capture_authorization_by_external_key**](docs/PaymentApi.md#capture_authorization_by_external_key) | **POST** /1.0/kb/payments | Capture an existing authorization
*PaymentApi* | [**chargeback_payment**](docs/PaymentApi.md#chargeback_payment) | **POST** /1.0/kb/payments/{paymentId}/chargebacks | Record a chargeback
*PaymentApi* | [**chargeback_payment_by_external_key**](docs/PaymentApi.md#chargeback_payment_by_external_key) | **POST** /1.0/kb/payments/chargebacks | Record a chargeback
*PaymentApi* | [**chargeback_reversal_payment**](docs/PaymentApi.md#chargeback_reversal_payment) | **POST** /1.0/kb/payments/{paymentId}/chargebackReversals | Record a chargeback reversal
*PaymentApi* | [**chargeback_reversal_payment_by_external_key**](docs/PaymentApi.md#chargeback_reversal_payment_by_external_key) | **POST** /1.0/kb/payments/chargebackReversals | Record a chargeback reversal
*PaymentApi* | [**complete_transaction**](docs/PaymentApi.md#complete_transaction) | **PUT** /1.0/kb/payments/{paymentId} | Complete an existing transaction
*PaymentApi* | [**complete_transaction_by_external_key**](docs/PaymentApi.md#complete_transaction_by_external_key) | **PUT** /1.0/kb/payments | Complete an existing transaction
*PaymentApi* | [**create_combo_payment**](docs/PaymentApi.md#create_combo_payment) | **POST** /1.0/kb/payments/combo | Combo api to create a new payment transaction on a existing (or not) account 
*PaymentApi* | [**create_payment_custom_fields**](docs/PaymentApi.md#create_payment_custom_fields) | **POST** /1.0/kb/payments/{paymentId}/customFields | Add custom fields to payment
*PaymentApi* | [**create_payment_tags**](docs/PaymentApi.md#create_payment_tags) | **POST** /1.0/kb/payments/{paymentId}/tags | Add tags to payment payment
*PaymentApi* | [**delete_payment_custom_fields**](docs/PaymentApi.md#delete_payment_custom_fields) | **DELETE** /1.0/kb/payments/{paymentId}/customFields | Remove custom fields from payment payment
*PaymentApi* | [**delete_payment_tags**](docs/PaymentApi.md#delete_payment_tags) | **DELETE** /1.0/kb/payments/{paymentId}/tags | Remove tags from payment payment
*PaymentApi* | [**get_payment**](docs/PaymentApi.md#get_payment) | **GET** /1.0/kb/payments/{paymentId} | Retrieve a payment by id
*PaymentApi* | [**get_payment_attempt_audit_logs_with_history**](docs/PaymentApi.md#get_payment_attempt_audit_logs_with_history) | **GET** /1.0/kb/payments/attempts/{paymentAttemptId}/auditLogsWithHistory | Retrieve payment attempt audit logs with history by id
*PaymentApi* | [**get_payment_audit_logs_with_history**](docs/PaymentApi.md#get_payment_audit_logs_with_history) | **GET** /1.0/kb/payments/{paymentId}/auditLogsWithHistory | Retrieve payment audit logs with history by id
*PaymentApi* | [**get_payment_by_external_key**](docs/PaymentApi.md#get_payment_by_external_key) | **GET** /1.0/kb/payments | Retrieve a payment by external key
*PaymentApi* | [**get_payment_custom_fields**](docs/PaymentApi.md#get_payment_custom_fields) | **GET** /1.0/kb/payments/{paymentId}/customFields | Retrieve payment custom fields
*PaymentApi* | [**get_payment_tags**](docs/PaymentApi.md#get_payment_tags) | **GET** /1.0/kb/payments/{paymentId}/tags | Retrieve payment payment tags
*PaymentApi* | [**get_payments**](docs/PaymentApi.md#get_payments) | **GET** /1.0/kb/payments/pagination | Get payments
*PaymentApi* | [**modify_payment_custom_fields**](docs/PaymentApi.md#modify_payment_custom_fields) | **PUT** /1.0/kb/payments/{paymentId}/customFields | Modify custom fields to payment
*PaymentApi* | [**refund_payment**](docs/PaymentApi.md#refund_payment) | **POST** /1.0/kb/payments/{paymentId}/refunds | Refund an existing payment
*PaymentApi* | [**refund_payment_by_external_key**](docs/PaymentApi.md#refund_payment_by_external_key) | **POST** /1.0/kb/payments/refunds | Refund an existing payment
*PaymentApi* | [**search_payments**](docs/PaymentApi.md#search_payments) | **GET** /1.0/kb/payments/search/{searchKey} | Search payments
*PaymentApi* | [**void_payment**](docs/PaymentApi.md#void_payment) | **DELETE** /1.0/kb/payments/{paymentId} | Void an existing payment
*PaymentApi* | [**void_payment_by_external_key**](docs/PaymentApi.md#void_payment_by_external_key) | **DELETE** /1.0/kb/payments | Void an existing payment
*PaymentGatewayApi* | [**build_combo_form_descriptor**](docs/PaymentGatewayApi.md#build_combo_form_descriptor) | **POST** /1.0/kb/paymentGateways/hosted/form | Combo API to generate form data to redirect the customer to the gateway
*PaymentGatewayApi* | [**build_form_descriptor**](docs/PaymentGatewayApi.md#build_form_descriptor) | **POST** /1.0/kb/paymentGateways/hosted/form/{accountId} | Generate form data to redirect the customer to the gateway
*PaymentGatewayApi* | [**process_notification**](docs/PaymentGatewayApi.md#process_notification) | **POST** /1.0/kb/paymentGateways/notification/{pluginName} | Process a gateway notification
*PaymentMethodApi* | [**create_payment_method_custom_fields**](docs/PaymentMethodApi.md#create_payment_method_custom_fields) | **POST** /1.0/kb/paymentMethods/{paymentMethodId}/customFields | Add custom fields to payment method
*PaymentMethodApi* | [**delete_payment_method**](docs/PaymentMethodApi.md#delete_payment_method) | **DELETE** /1.0/kb/paymentMethods/{paymentMethodId} | Delete a payment method
*PaymentMethodApi* | [**delete_payment_method_custom_fields**](docs/PaymentMethodApi.md#delete_payment_method_custom_fields) | **DELETE** /1.0/kb/paymentMethods/{paymentMethodId}/customFields | Remove custom fields from payment method
*PaymentMethodApi* | [**get_payment_method**](docs/PaymentMethodApi.md#get_payment_method) | **GET** /1.0/kb/paymentMethods/{paymentMethodId} | Retrieve a payment method by id
*PaymentMethodApi* | [**get_payment_method_audit_logs_with_history**](docs/PaymentMethodApi.md#get_payment_method_audit_logs_with_history) | **GET** /1.0/kb/paymentMethods/{paymentMethodId}/auditLogsWithHistory | Retrieve payment method audit logs with history by id
*PaymentMethodApi* | [**get_payment_method_by_key**](docs/PaymentMethodApi.md#get_payment_method_by_key) | **GET** /1.0/kb/paymentMethods | Retrieve a payment method by external key
*PaymentMethodApi* | [**get_payment_method_custom_fields**](docs/PaymentMethodApi.md#get_payment_method_custom_fields) | **GET** /1.0/kb/paymentMethods/{paymentMethodId}/customFields | Retrieve payment method custom fields
*PaymentMethodApi* | [**get_payment_methods**](docs/PaymentMethodApi.md#get_payment_methods) | **GET** /1.0/kb/paymentMethods/pagination | List payment methods
*PaymentMethodApi* | [**modify_payment_method_custom_fields**](docs/PaymentMethodApi.md#modify_payment_method_custom_fields) | **PUT** /1.0/kb/paymentMethods/{paymentMethodId}/customFields | Modify custom fields to payment method
*PaymentMethodApi* | [**search_payment_methods**](docs/PaymentMethodApi.md#search_payment_methods) | **GET** /1.0/kb/paymentMethods/search/{searchKey} | Search payment methods
*PaymentTransactionApi* | [**create_transaction_custom_fields**](docs/PaymentTransactionApi.md#create_transaction_custom_fields) | **POST** /1.0/kb/paymentTransactions/{transactionId}/customFields | Add custom fields to payment transaction
*PaymentTransactionApi* | [**create_transaction_tags**](docs/PaymentTransactionApi.md#create_transaction_tags) | **POST** /1.0/kb/paymentTransactions/{transactionId}/tags | Add tags to payment transaction
*PaymentTransactionApi* | [**delete_transaction_custom_fields**](docs/PaymentTransactionApi.md#delete_transaction_custom_fields) | **DELETE** /1.0/kb/paymentTransactions/{transactionId}/customFields | Remove custom fields from payment transaction
*PaymentTransactionApi* | [**delete_transaction_tags**](docs/PaymentTransactionApi.md#delete_transaction_tags) | **DELETE** /1.0/kb/paymentTransactions/{transactionId}/tags | Remove tags from payment transaction
*PaymentTransactionApi* | [**get_payment_by_transaction_external_key**](docs/PaymentTransactionApi.md#get_payment_by_transaction_external_key) | **GET** /1.0/kb/paymentTransactions | Retrieve a payment by transaction external key
*PaymentTransactionApi* | [**get_payment_by_transaction_id**](docs/PaymentTransactionApi.md#get_payment_by_transaction_id) | **GET** /1.0/kb/paymentTransactions/{transactionId} | Retrieve a payment by transaction id
*PaymentTransactionApi* | [**get_transaction_audit_logs_with_history**](docs/PaymentTransactionApi.md#get_transaction_audit_logs_with_history) | **GET** /1.0/kb/paymentTransactions/{transactionId}/auditLogsWithHistory | Retrieve payment transaction audit logs with history by id
*PaymentTransactionApi* | [**get_transaction_custom_fields**](docs/PaymentTransactionApi.md#get_transaction_custom_fields) | **GET** /1.0/kb/paymentTransactions/{transactionId}/customFields | Retrieve payment transaction custom fields
*PaymentTransactionApi* | [**get_transaction_tags**](docs/PaymentTransactionApi.md#get_transaction_tags) | **GET** /1.0/kb/paymentTransactions/{transactionId}/tags | Retrieve payment transaction tags
*PaymentTransactionApi* | [**modify_transaction_custom_fields**](docs/PaymentTransactionApi.md#modify_transaction_custom_fields) | **PUT** /1.0/kb/paymentTransactions/{transactionId}/customFields | Modify custom fields to payment transaction
*PaymentTransactionApi* | [**notify_state_changed**](docs/PaymentTransactionApi.md#notify_state_changed) | **POST** /1.0/kb/paymentTransactions/{transactionId} | Mark a pending payment transaction as succeeded or failed
*PluginInfoApi* | [**get_plugins_info**](docs/PluginInfoApi.md#get_plugins_info) | **GET** /1.0/kb/pluginsInfo | Retrieve the list of registered plugins
*SecurityApi* | [**add_role_definition**](docs/SecurityApi.md#add_role_definition) | **POST** /1.0/kb/security/roles | Add a new role definition)
*SecurityApi* | [**add_user_roles**](docs/SecurityApi.md#add_user_roles) | **POST** /1.0/kb/security/users | Add a new user with roles (to make api requests)
*SecurityApi* | [**get_current_user_permissions**](docs/SecurityApi.md#get_current_user_permissions) | **GET** /1.0/kb/security/permissions | List user permissions
*SecurityApi* | [**get_current_user_subject**](docs/SecurityApi.md#get_current_user_subject) | **GET** /1.0/kb/security/subject | Get user information
*SecurityApi* | [**get_role_definition**](docs/SecurityApi.md#get_role_definition) | **GET** /1.0/kb/security/roles/{role} | Get role definition
*SecurityApi* | [**get_user_roles**](docs/SecurityApi.md#get_user_roles) | **GET** /1.0/kb/security/users/{username}/roles | Get roles associated to a user
*SecurityApi* | [**invalidate_user**](docs/SecurityApi.md#invalidate_user) | **DELETE** /1.0/kb/security/users/{username} | Invalidate an existing user
*SecurityApi* | [**update_role_definition**](docs/SecurityApi.md#update_role_definition) | **PUT** /1.0/kb/security/roles | Update a new role definition)
*SecurityApi* | [**update_user_password**](docs/SecurityApi.md#update_user_password) | **PUT** /1.0/kb/security/users/{username}/password | Update a user password
*SecurityApi* | [**update_user_roles**](docs/SecurityApi.md#update_user_roles) | **PUT** /1.0/kb/security/users/{username}/roles | Update roles associated to a user
*SubscriptionApi* | [**add_subscription_blocking_state**](docs/SubscriptionApi.md#add_subscription_blocking_state) | **POST** /1.0/kb/subscriptions/{subscriptionId}/block | Block a subscription
*SubscriptionApi* | [**cancel_subscription_plan**](docs/SubscriptionApi.md#cancel_subscription_plan) | **DELETE** /1.0/kb/subscriptions/{subscriptionId} | Cancel an entitlement plan
*SubscriptionApi* | [**change_subscription_plan**](docs/SubscriptionApi.md#change_subscription_plan) | **PUT** /1.0/kb/subscriptions/{subscriptionId} | Change entitlement plan
*SubscriptionApi* | [**create_subscription**](docs/SubscriptionApi.md#create_subscription) | **POST** /1.0/kb/subscriptions | Create an subscription
*SubscriptionApi* | [**create_subscription_custom_fields**](docs/SubscriptionApi.md#create_subscription_custom_fields) | **POST** /1.0/kb/subscriptions/{subscriptionId}/customFields | Add custom fields to subscription
*SubscriptionApi* | [**create_subscription_tags**](docs/SubscriptionApi.md#create_subscription_tags) | **POST** /1.0/kb/subscriptions/{subscriptionId}/tags | 
*SubscriptionApi* | [**create_subscription_with_add_ons**](docs/SubscriptionApi.md#create_subscription_with_add_ons) | **POST** /1.0/kb/subscriptions/createSubscriptionWithAddOns | Create an entitlement with addOn products
*SubscriptionApi* | [**create_subscriptions_with_add_ons**](docs/SubscriptionApi.md#create_subscriptions_with_add_ons) | **POST** /1.0/kb/subscriptions/createSubscriptionsWithAddOns | Create multiple entitlements with addOn products
*SubscriptionApi* | [**delete_subscription_custom_fields**](docs/SubscriptionApi.md#delete_subscription_custom_fields) | **DELETE** /1.0/kb/subscriptions/{subscriptionId}/customFields | Remove custom fields from subscription
*SubscriptionApi* | [**delete_subscription_tags**](docs/SubscriptionApi.md#delete_subscription_tags) | **DELETE** /1.0/kb/subscriptions/{subscriptionId}/tags | Remove tags from subscription
*SubscriptionApi* | [**get_subscription**](docs/SubscriptionApi.md#get_subscription) | **GET** /1.0/kb/subscriptions/{subscriptionId} | Retrieve a subscription by id
*SubscriptionApi* | [**get_subscription_audit_logs_with_history**](docs/SubscriptionApi.md#get_subscription_audit_logs_with_history) | **GET** /1.0/kb/subscriptions/{subscriptionId}/auditLogsWithHistory | Retrieve subscription audit logs with history by id
*SubscriptionApi* | [**get_subscription_by_key**](docs/SubscriptionApi.md#get_subscription_by_key) | **GET** /1.0/kb/subscriptions | Retrieve a subscription by external key
*SubscriptionApi* | [**get_subscription_custom_fields**](docs/SubscriptionApi.md#get_subscription_custom_fields) | **GET** /1.0/kb/subscriptions/{subscriptionId}/customFields | Retrieve subscription custom fields
*SubscriptionApi* | [**get_subscription_event_audit_logs_with_history**](docs/SubscriptionApi.md#get_subscription_event_audit_logs_with_history) | **GET** /1.0/kb/subscriptions/events/{eventId}/auditLogsWithHistory | Retrieve subscription event audit logs with history by id
*SubscriptionApi* | [**get_subscription_tags**](docs/SubscriptionApi.md#get_subscription_tags) | **GET** /1.0/kb/subscriptions/{subscriptionId}/tags | Retrieve subscription tags
*SubscriptionApi* | [**modify_subscription_custom_fields**](docs/SubscriptionApi.md#modify_subscription_custom_fields) | **PUT** /1.0/kb/subscriptions/{subscriptionId}/customFields | Modify custom fields to subscription
*SubscriptionApi* | [**uncancel_subscription_plan**](docs/SubscriptionApi.md#uncancel_subscription_plan) | **PUT** /1.0/kb/subscriptions/{subscriptionId}/uncancel | Un-cancel an entitlement
*SubscriptionApi* | [**undo_change_subscription_plan**](docs/SubscriptionApi.md#undo_change_subscription_plan) | **PUT** /1.0/kb/subscriptions/{subscriptionId}/undoChangePlan | Undo a pending change plan on an entitlement
*SubscriptionApi* | [**update_subscription_bcd**](docs/SubscriptionApi.md#update_subscription_bcd) | **PUT** /1.0/kb/subscriptions/{subscriptionId}/bcd | Update the BCD associated to a subscription
*TagApi* | [**get_tag_audit_logs_with_history**](docs/TagApi.md#get_tag_audit_logs_with_history) | **GET** /1.0/kb/tags/{tagId}/auditLogsWithHistory | Retrieve tag audit logs with history by id
*TagApi* | [**get_tags**](docs/TagApi.md#get_tags) | **GET** /1.0/kb/tags/pagination | List tags
*TagApi* | [**search_tags**](docs/TagApi.md#search_tags) | **GET** /1.0/kb/tags/search/{searchKey} | Search tags
*TagDefinitionApi* | [**create_tag_definition**](docs/TagDefinitionApi.md#create_tag_definition) | **POST** /1.0/kb/tagDefinitions | Create a tag definition
*TagDefinitionApi* | [**delete_tag_definition**](docs/TagDefinitionApi.md#delete_tag_definition) | **DELETE** /1.0/kb/tagDefinitions/{tagDefinitionId} | Delete a tag definition
*TagDefinitionApi* | [**get_tag_definition**](docs/TagDefinitionApi.md#get_tag_definition) | **GET** /1.0/kb/tagDefinitions/{tagDefinitionId} | Retrieve a tag definition
*TagDefinitionApi* | [**get_tag_definition_audit_logs_with_history**](docs/TagDefinitionApi.md#get_tag_definition_audit_logs_with_history) | **GET** /1.0/kb/tagDefinitions/{tagDefinitionId}/auditLogsWithHistory | Retrieve tag definition audit logs with history by id
*TagDefinitionApi* | [**get_tag_definitions**](docs/TagDefinitionApi.md#get_tag_definitions) | **GET** /1.0/kb/tagDefinitions | List tag definitions
*TenantApi* | [**create_tenant**](docs/TenantApi.md#create_tenant) | **POST** /1.0/kb/tenants | Create a tenant
*TenantApi* | [**delete_per_tenant_configuration**](docs/TenantApi.md#delete_per_tenant_configuration) | **DELETE** /1.0/kb/tenants/uploadPerTenantConfig | Delete a per tenant configuration (system properties)
*TenantApi* | [**delete_plugin_configuration**](docs/TenantApi.md#delete_plugin_configuration) | **DELETE** /1.0/kb/tenants/uploadPluginConfig/{pluginName} | Delete a per tenant configuration for a plugin
*TenantApi* | [**delete_plugin_payment_state_machine_config**](docs/TenantApi.md#delete_plugin_payment_state_machine_config) | **DELETE** /1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName} | Delete a per tenant payment state machine for a plugin
*TenantApi* | [**delete_push_notification_callbacks**](docs/TenantApi.md#delete_push_notification_callbacks) | **DELETE** /1.0/kb/tenants/registerNotificationCallback | Delete a push notification
*TenantApi* | [**delete_user_key_value**](docs/TenantApi.md#delete_user_key_value) | **DELETE** /1.0/kb/tenants/userKeyValue/{keyName} | Delete  a per tenant user key/value
*TenantApi* | [**get_all_plugin_configuration**](docs/TenantApi.md#get_all_plugin_configuration) | **GET** /1.0/kb/tenants/uploadPerTenantConfig/{keyPrefix}/search | Retrieve a per tenant key value based on key prefix
*TenantApi* | [**get_per_tenant_configuration**](docs/TenantApi.md#get_per_tenant_configuration) | **GET** /1.0/kb/tenants/uploadPerTenantConfig | Retrieve a per tenant configuration (system properties)
*TenantApi* | [**get_plugin_configuration**](docs/TenantApi.md#get_plugin_configuration) | **GET** /1.0/kb/tenants/uploadPluginConfig/{pluginName} | Retrieve a per tenant configuration for a plugin
*TenantApi* | [**get_plugin_payment_state_machine_config**](docs/TenantApi.md#get_plugin_payment_state_machine_config) | **GET** /1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName} | Retrieve a per tenant payment state machine for a plugin
*TenantApi* | [**get_push_notification_callbacks**](docs/TenantApi.md#get_push_notification_callbacks) | **GET** /1.0/kb/tenants/registerNotificationCallback | Retrieve a push notification
*TenantApi* | [**get_tenant**](docs/TenantApi.md#get_tenant) | **GET** /1.0/kb/tenants/{tenantId} | Retrieve a tenant by id
*TenantApi* | [**get_tenant_by_api_key**](docs/TenantApi.md#get_tenant_by_api_key) | **GET** /1.0/kb/tenants | Retrieve a tenant by its API key
*TenantApi* | [**get_user_key_value**](docs/TenantApi.md#get_user_key_value) | **GET** /1.0/kb/tenants/userKeyValue/{keyName} | Retrieve a per tenant user key/value
*TenantApi* | [**insert_user_key_value**](docs/TenantApi.md#insert_user_key_value) | **POST** /1.0/kb/tenants/userKeyValue/{keyName} | Add a per tenant user key/value
*TenantApi* | [**register_push_notification_callback**](docs/TenantApi.md#register_push_notification_callback) | **POST** /1.0/kb/tenants/registerNotificationCallback | Create a push notification
*TenantApi* | [**upload_per_tenant_configuration**](docs/TenantApi.md#upload_per_tenant_configuration) | **POST** /1.0/kb/tenants/uploadPerTenantConfig | Add a per tenant configuration (system properties)
*TenantApi* | [**upload_plugin_configuration**](docs/TenantApi.md#upload_plugin_configuration) | **POST** /1.0/kb/tenants/uploadPluginConfig/{pluginName} | Add a per tenant configuration for a plugin
*TenantApi* | [**upload_plugin_payment_state_machine_config**](docs/TenantApi.md#upload_plugin_payment_state_machine_config) | **POST** /1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/{pluginName} | Add a per tenant payment state machine for a plugin
*UsageApi* | [**get_all_usage**](docs/UsageApi.md#get_all_usage) | **GET** /1.0/kb/usages/{subscriptionId} | Retrieve usage for a subscription
*UsageApi* | [**get_usage**](docs/UsageApi.md#get_usage) | **GET** /1.0/kb/usages/{subscriptionId}/{unitType} | Retrieve usage for a subscription and unit type
*UsageApi* | [**record_usage**](docs/UsageApi.md#record_usage) | **POST** /1.0/kb/usages | Record usage for a subscription

## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountEmail](docs/AccountEmail.md)
 - [AccountTimeline](docs/AccountTimeline.md)
 - [AdminPayment](docs/AdminPayment.md)
 - [AuditLog](docs/AuditLog.md)
 - [BlockPrice](docs/BlockPrice.md)
 - [BlockingState](docs/BlockingState.md)
 - [BulkSubscriptionsBundle](docs/BulkSubscriptionsBundle.md)
 - [Bundle](docs/Bundle.md)
 - [BundleTimeline](docs/BundleTimeline.md)
 - [Catalog](docs/Catalog.md)
 - [ComboHostedPaymentPage](docs/ComboHostedPaymentPage.md)
 - [ComboPaymentTransaction](docs/ComboPaymentTransaction.md)
 - [CustomField](docs/CustomField.md)
 - [Duration](docs/Duration.md)
 - [Entity](docs/Entity.md)
 - [EventSubscription](docs/EventSubscription.md)
 - [HostedPaymentPageFields](docs/HostedPaymentPageFields.md)
 - [HostedPaymentPageFormDescriptor](docs/HostedPaymentPageFormDescriptor.md)
 - [Invoice](docs/Invoice.md)
 - [InvoiceDryRun](docs/InvoiceDryRun.md)
 - [InvoiceItem](docs/InvoiceItem.md)
 - [InvoicePayment](docs/InvoicePayment.md)
 - [InvoicePaymentTransaction](docs/InvoicePaymentTransaction.md)
 - [Limit](docs/Limit.md)
 - [NodeCommand](docs/NodeCommand.md)
 - [NodeCommandProperty](docs/NodeCommandProperty.md)
 - [Overdue](docs/Overdue.md)
 - [OverdueCondition](docs/OverdueCondition.md)
 - [OverdueState](docs/OverdueState.md)
 - [OverdueStateConfig](docs/OverdueStateConfig.md)
 - [Payment](docs/Payment.md)
 - [PaymentAttempt](docs/PaymentAttempt.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodPluginDetail](docs/PaymentMethodPluginDetail.md)
 - [PaymentTransaction](docs/PaymentTransaction.md)
 - [Phase](docs/Phase.md)
 - [PhasePrice](docs/PhasePrice.md)
 - [Plan](docs/Plan.md)
 - [PlanDetail](docs/PlanDetail.md)
 - [PluginInfo](docs/PluginInfo.md)
 - [PluginProperty](docs/PluginProperty.md)
 - [PluginServiceInfo](docs/PluginServiceInfo.md)
 - [Price](docs/Price.md)
 - [PriceList](docs/PriceList.md)
 - [Product](docs/Product.md)
 - [RoleDefinition](docs/RoleDefinition.md)
 - [RolledUpUnit](docs/RolledUpUnit.md)
 - [RolledUpUsage](docs/RolledUpUsage.md)
 - [Session](docs/Session.md)
 - [SimplePlan](docs/SimplePlan.md)
 - [Subject](docs/Subject.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionUsageRecord](docs/SubscriptionUsageRecord.md)
 - [Tag](docs/Tag.md)
 - [TagDefinition](docs/TagDefinition.md)
 - [Tenant](docs/Tenant.md)
 - [TenantKeyValue](docs/TenantKeyValue.md)
 - [Tier](docs/Tier.md)
 - [TierPrice](docs/TierPrice.md)
 - [TieredBlock](docs/TieredBlock.md)
 - [Unit](docs/Unit.md)
 - [UnitUsageRecord](docs/UnitUsageRecord.md)
 - [Usage](docs/Usage.md)
 - [UsagePrice](docs/UsagePrice.md)
 - [UsageRecord](docs/UsageRecord.md)
 - [UserRoles](docs/UserRoles.md)

## Documentation For Authorization


## Killbill Api Key

- **Type**: API key
- **API key parameter name**: X-Killbill-ApiKey
- **Location**: HTTP header

## Killbill Api Secret

- **Type**: API key
- **API key parameter name**: X-Killbill-ApiSecret
- **Location**: HTTP header

## basicAuth

- **Type**: HTTP basic authentication


## Author


