"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenIdConnectProvider = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * IAM OIDC identity providers are entities in IAM that describe an external
 * identity provider (IdP) service that supports the OpenID Connect (OIDC)
 * standard, such as Google or Salesforce. You use an IAM OIDC identity provider
 * when you want to establish trust between an OIDC-compatible IdP and your AWS
 * account.
 *
 * This implementation has default values for thumbprints and clientIds props
 * that will be compatible with the eks cluster
 *
 * @see http://openid.net/connect
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html
 *
 * @resource AWS::CloudFormation::CustomResource
 */
class OpenIdConnectProvider extends iam.OpenIdConnectProvider {
    /**
     * Defines an OpenID Connect provider.
     * @param scope The definition scope
     * @param id Construct ID
     * @param props Initialization properties
     */
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_OpenIdConnectProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        /**
         * For some reason EKS isn't validating the root certificate but a intermediate certificate
         * which is one level up in the tree. Because of the a constant thumbprint value has to be
         * stated with this OpenID Connect provider. The certificate thumbprint is the same for all the regions.
         */
        const thumbprints = ['9e99a48a9960b14926bb7f3b02e22da2b0ab7280'];
        const clientIds = ['sts.amazonaws.com'];
        super(scope, id, {
            url: props.url,
            thumbprints,
            clientIds,
        });
    }
}
exports.OpenIdConnectProvider = OpenIdConnectProvider;
_a = JSII_RTTI_SYMBOL_1;
OpenIdConnectProvider[_a] = { fqn: "@aws-cdk/aws-eks.OpenIdConnectProvider", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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