/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.triangle.MultiEntriesFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.MultiKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.PutMapBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.remoting.responses.ValidResponse;

public final class TriangleFunctionsUtil {
    private TriangleFunctionsUtil() {
    }

    public static PutMapCommand copy(PutMapCommand command, Collection<Object> keys2) {
        PutMapCommand copy = new PutMapCommand(command);
        copy.setMap(TriangleFunctionsUtil.filterEntries(command.getMap(), keys2));
        return copy;
    }

    public static <K, V, T> WriteOnlyManyEntriesCommand<K, V, T> copy(WriteOnlyManyEntriesCommand<K, V, T> command, Collection<Object> keys2) {
        return new WriteOnlyManyEntriesCommand<K, V, T>(command).withArguments(TriangleFunctionsUtil.filterEntries(command.getArguments(), keys2));
    }

    public static <K, V> WriteOnlyManyCommand<K, V> copy(WriteOnlyManyCommand<K, V> command, Collection<Object> keys2) {
        WriteOnlyManyCommand<K, V> copy = new WriteOnlyManyCommand<K, V>(command);
        copy.setKeys(keys2);
        return copy;
    }

    public static <K, V, R> ReadWriteManyCommand<K, V, R> copy(ReadWriteManyCommand<K, V, R> command, Collection<Object> keys2) {
        ReadWriteManyCommand copy = new ReadWriteManyCommand(command);
        copy.setKeys(keys2);
        return copy;
    }

    public static <K, V, T, R> ReadWriteManyEntriesCommand<K, V, T, R> copy(ReadWriteManyEntriesCommand<K, V, T, R> command, Collection<Object> keys2) {
        return new ReadWriteManyEntriesCommand(command).withArguments(TriangleFunctionsUtil.filterEntries(command.getArguments(), keys2));
    }

    public static Map<Object, Object> mergeHashMap(ValidResponse response, Map<Object, Object> resultMap) {
        Map remoteMap = (Map)response.getResponseValue();
        return InfinispanCollections.mergeMaps(resultMap, remoteMap);
    }

    public static Void voidMerge(ValidResponse ignored1, Void ignored2) {
        return null;
    }

    public static List<Object> mergeList(ValidResponse response, List<Object> resultList) {
        List list = (List)response.getResponseValue();
        return InfinispanCollections.mergeLists(list, resultList);
    }

    public static Map<Integer, Collection<Object>> filterBySegment(LocalizedCacheTopology cacheTopology, Collection<Object> keys2) {
        HashMap<Integer, Collection<Object>> filteredKeys = new HashMap<Integer, Collection<Object>>(cacheTopology.getReadConsistentHash().getNumSegments());
        for (Object key : keys2) {
            filteredKeys.computeIfAbsent(cacheTopology.getSegment(key), integer -> new ArrayList()).add(key);
        }
        return filteredKeys;
    }

    public static <K, V> Map<K, V> filterEntries(Map<K, V> map, Collection<Object> keys2) {
        return map.entrySet().stream().filter(entry -> keys2.contains(entry.getKey())).collect(HashMap::new, (rMap, entry) -> rMap.put(entry.getKey(), entry.getValue()), HashMap::putAll);
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, PutKeyValueCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setPutKeyValueCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, IracPutKeyValueCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setIracPutKeyValueCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, RemoveCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setRemoveCommand(command, command.getCommandId() == 58);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, ReplaceCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setReplaceCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, ComputeIfAbsentCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setComputeIfAbsentCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, ComputeCommand command) {
        SingleKeyBackupWriteCommand cmd = factory2.buildSingleKeyBackupWriteCommand();
        cmd.setComputeCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, ReadWriteKeyValueCommand command) {
        SingleKeyFunctionalBackupWriteCommand cmd = factory2.buildSingleKeyFunctionalBackupWriteCommand();
        cmd.setReadWriteKeyValueCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, ReadWriteKeyCommand command) {
        SingleKeyFunctionalBackupWriteCommand cmd = factory2.buildSingleKeyFunctionalBackupWriteCommand();
        cmd.setReadWriteKeyCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, WriteOnlyKeyValueCommand command) {
        SingleKeyFunctionalBackupWriteCommand cmd = factory2.buildSingleKeyFunctionalBackupWriteCommand();
        cmd.setWriteOnlyKeyValueCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, WriteOnlyKeyCommand command) {
        SingleKeyFunctionalBackupWriteCommand cmd = factory2.buildSingleKeyFunctionalBackupWriteCommand();
        cmd.setWriteOnlyKeyCommand(command);
        return cmd;
    }

    public static BackupWriteCommand backupFrom(CommandsFactory factory2, PutMapCommand command, Collection<Object> keys2) {
        PutMapBackupWriteCommand cmd = factory2.buildPutMapBackupWriteCommand();
        cmd.setPutMapCommand(command, keys2);
        return cmd;
    }

    public static <K, V, T> BackupWriteCommand backupFrom(CommandsFactory factory2, WriteOnlyManyEntriesCommand<K, V, T> command, Collection<Object> keys2) {
        MultiEntriesFunctionalBackupWriteCommand cmd = factory2.buildMultiEntriesFunctionalBackupWriteCommand();
        cmd.setWriteOnly(command, keys2);
        return cmd;
    }

    public static <K, V, T, R> BackupWriteCommand backupFrom(CommandsFactory factory2, ReadWriteManyEntriesCommand<K, V, T, R> command, Collection<Object> keys2) {
        MultiEntriesFunctionalBackupWriteCommand cmd = factory2.buildMultiEntriesFunctionalBackupWriteCommand();
        cmd.setReadWrite(command, keys2);
        return cmd;
    }

    public static <K, V> BackupWriteCommand backupFrom(CommandsFactory factory2, WriteOnlyManyCommand<K, V> command, Collection<Object> keys2) {
        MultiKeyFunctionalBackupWriteCommand cmd = factory2.buildMultiKeyFunctionalBackupWriteCommand();
        cmd.setWriteOnly(command, keys2);
        return cmd;
    }

    public static <K, V, R> BackupWriteCommand backupFrom(CommandsFactory factory2, ReadWriteManyCommand<K, V, R> command, Collection<Object> keys2) {
        MultiKeyFunctionalBackupWriteCommand cmd = factory2.buildMultiKeyFunctionalBackupWriteCommand();
        cmd.setReadWrite(command, keys2);
        return cmd;
    }
}

