/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

public class StripedHashFunction<T> {
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    private final int numSegments;

    public StripedHashFunction(int concurrencyLevel) {
        int tmpNumSegments;
        int tempLockSegShift = 0;
        for (tmpNumSegments = 1; tmpNumSegments < concurrencyLevel; tmpNumSegments <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = tmpNumSegments - 1;
        this.numSegments = tmpNumSegments;
    }

    private static int hash(int hashCode) {
        int h2 = hashCode;
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    public final int getNumSegments() {
        return this.numSegments;
    }

    public final int hashToSegment(T object) {
        return StripedHashFunction.hash(object.hashCode()) >>> this.lockSegmentShift & this.lockSegmentMask;
    }
}

