/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.XAResource;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;

public final class EmbeddedTransaction
extends TransactionImpl {
    private static final int FORMAT = 1;
    private static final AtomicLong GLOBAL_ID_GENERATOR = new AtomicLong(1L);
    private static final AtomicLong BRANCH_QUALIFIER_GENERATOR = new AtomicLong(1L);

    public EmbeddedTransaction(EmbeddedBaseTransactionManager tm) {
        this.setXid(EmbeddedTransaction.createXid(tm.getTransactionManagerId()));
    }

    public XAResource firstEnlistedResource() {
        return this.getEnlistedResources().iterator().next();
    }

    public static XidImpl createXid(UUID transactionManagerId) {
        return XidImpl.create(1, EmbeddedTransaction.create(transactionManagerId, GLOBAL_ID_GENERATOR), EmbeddedTransaction.create(transactionManagerId, BRANCH_QUALIFIER_GENERATOR));
    }

    private static byte[] create(UUID transactionManagerId, AtomicLong generator) {
        byte[] field = new byte[24];
        Util.longToBytes(transactionManagerId.getLeastSignificantBits(), field, 0);
        Util.longToBytes(transactionManagerId.getMostSignificantBits(), field, 8);
        Util.longToBytes(generator.incrementAndGet(), field, 16);
        return field;
    }
}

