/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.expiration.TouchMode;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;

public abstract class ClusteringInterceptor
extends BaseRpcInterceptor {
    @Inject
    protected CommandsFactory cf;
    @Inject
    protected EntryFactory entryFactory;
    @Inject
    protected LockManager lockManager;
    @Inject
    protected InternalDataContainer dataContainer;
    @Inject
    protected DistributionManager distributionManager;
    private TouchMode touchMode;
    private boolean isScattered;

    @Override
    public void init() {
        super.init();
        this.isScattered = this.cacheConfiguration.clustering().cacheMode().isScattered();
        this.touchMode = this.cacheConfiguration.clustering().cacheMode().isSynchronous() ? this.cacheConfiguration.expiration().touch() : TouchMode.ASYNC;
    }

    protected LocalizedCacheTopology checkTopologyId(TopologyAffectedCommand command) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        int currentTopologyId = cacheTopology.getTopologyId();
        int cmdTopology = command.getTopologyId();
        if (command instanceof FlagAffectedCommand && ((FlagAffectedCommand)((Object)command)).hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.CACHE_MODE_LOCAL)) {
            this.getLog().tracef("Skipping topology check for command %s", (Object)command);
            return cacheTopology;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Current topology %d, command topology %d", currentTopologyId, cmdTopology);
        }
        if (cmdTopology >= 0 && currentTopologyId != cmdTopology) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
        return cacheTopology;
    }

    @Override
    public Object visitTouchCommand(InvocationContext ctx, TouchCommand command) throws Throwable {
        List<Address> owners;
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            return this.invokeNext(ctx, command);
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        DistributionInfo info = cacheTopology.getSegmentDistribution(command.getSegment());
        List<Address> list = owners = this.isScattered ? cacheTopology.getActualMembers() : info.readOwners();
        if (this.touchMode == TouchMode.ASYNC) {
            if (ctx.isOriginLocal()) {
                this.rpcManager.sendToMany(owners, command, DeliverOrder.NONE);
            }
            return this.invokeNext(ctx, command);
        }
        if (info.isPrimary()) {
            AbstractTouchResponseCollector collector = this.isScattered ? ScatteredTouchResponseCollector.INSTANCE : TouchResponseCollector.INSTANCE;
            CompletionStage<Boolean> remoteInvocation = this.rpcManager.invokeCommand(owners, (ReplicableCommand)command, collector, this.rpcManager.getSyncRpcOptions());
            return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rValue) -> {
                Boolean touchedLocally = (Boolean)rValue;
                if (touchedLocally.booleanValue()) {
                    return ClusteringInterceptor.asyncValue(remoteInvocation);
                }
                return Boolean.FALSE;
            });
        }
        if (ctx.isOriginLocal()) {
            CompletionStage<ValidResponse> remoteInvocation = this.rpcManager.invokeCommand(info.primary(), (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
            return ClusteringInterceptor.asyncValue(remoteInvocation).thenApply(ctx, command, (rCtx, rCommand, rResponse) -> ((ValidResponse)rResponse).getResponseValue());
        }
        return this.invokeNext(ctx, command);
    }

    protected static SuccessfulResponse getSuccessfulResponseOrFail(Map<Address, Response> responseMap, CompletableFuture<?> future, Consumer<Response> cacheNotFound) {
        Iterator<Map.Entry<Address, Response>> it = responseMap.entrySet().iterator();
        if (!it.hasNext()) {
            future.completeExceptionally(AllOwnersLostException.INSTANCE);
            return null;
        }
        Map.Entry<Address, Response> e = it.next();
        Address sender = e.getKey();
        Response response = e.getValue();
        if (it.hasNext()) {
            future.completeExceptionally(new IllegalStateException("Too many responses " + responseMap));
        } else {
            if (response instanceof SuccessfulResponse) {
                return (SuccessfulResponse)response;
            }
            if (response instanceof CacheNotFoundResponse || response instanceof UnsureResponse) {
                if (cacheNotFound == null) {
                    future.completeExceptionally(ClusteringInterceptor.unexpected(sender, response));
                } else {
                    try {
                        cacheNotFound.accept(response);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            } else {
                future.completeExceptionally(ClusteringInterceptor.unexpected(sender, response));
            }
        }
        return null;
    }

    protected static RuntimeException unexpected(Address sender, Response response) {
        return Log.CLUSTER.unexpectedResponse(sender, response);
    }

    protected class ClusteredGetAllFuture
    extends CompletableFuture<Void> {
        public int counter;

        public ClusteredGetAllFuture(int counter) {
            this.counter = counter;
        }

        @Override
        public synchronized boolean completeExceptionally(Throwable ex) {
            return super.completeExceptionally(ex);
        }
    }

    private static class TouchResponseCollector
    extends AbstractTouchResponseCollector {
        private static final TouchResponseCollector INSTANCE = new TouchResponseCollector();

        private TouchResponseCollector() {
        }

        @Override
        public Boolean finish() {
            return Boolean.TRUE;
        }

        @Override
        protected Boolean addBooleanResponse(Address sender, Boolean response) {
            if (response == Boolean.FALSE) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static class ScatteredTouchResponseCollector
    extends AbstractTouchResponseCollector {
        private static final ScatteredTouchResponseCollector INSTANCE = new ScatteredTouchResponseCollector();

        private ScatteredTouchResponseCollector() {
        }

        @Override
        public Boolean finish() {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean addBooleanResponse(Address sender, Boolean response) {
            if (response == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    private static abstract class AbstractTouchResponseCollector
    extends ValidResponseCollector<Boolean> {
        private AbstractTouchResponseCollector() {
        }

        @Override
        protected Boolean addTargetNotFound(Address sender) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }

        @Override
        protected Boolean addException(Address sender, Exception exception) {
            if (exception instanceof CacheException) {
                throw (CacheException)exception;
            }
            throw new CacheException(exception);
        }

        @Override
        protected final Boolean addValidResponse(Address sender, ValidResponse response) {
            return this.addBooleanResponse(sender, (Boolean)response.getResponseValue());
        }

        abstract Boolean addBooleanResponse(Address var1, Boolean var2);
    }
}

