/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class ReadOnlyMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.ReadOnlyMap<K, V> {
    private static final Log log = LogFactory.getLog(ReadOnlyMapImpl.class);

    private ReadOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
    }

    public static <K, V> FunctionalMap.ReadOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return ReadOnlyMapImpl.create(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.ReadOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new ReadOnlyMapImpl<K, V>(params, functionalMap);
    }

    @Override
    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, %s)", (Object)key, (Object)this.params);
        Object keyEncoded = this.keyDataConversion.toStorage(key);
        ReadOnlyKeyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadOnlyKeyCommand(keyEncoded, f, this.fmap.keyPartitioner.getSegment(keyEncoded), this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.fmap.invCtxFactory.createInvocationContext(false, 1);
        return this.fmap.chain.invokeAsync(ctx, cmd);
    }

    @Override
    public <R> Traversable<R> evalMany(Set<? extends K> keys2, Function<EntryView.ReadEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(m=%s, %s)", (Object)keys2, (Object)this.params);
        Set<?> encodedKeys = this.encodeKeys(keys2);
        ReadOnlyManyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadOnlyManyCommand(encodedKeys, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.fmap.invCtxFactory.createInvocationContext(false, keys2.size());
        return Traversables.of((Stream)this.fmap.chain.invokeAsync(ctx, cmd).join());
    }

    @Override
    public Traversable<K> keys() {
        log.tracef("Invoked keys(%s)", (Object)this.params);
        return Traversables.of(this.fmap.cache.keySet().stream());
    }

    @Override
    public Traversable<EntryView.ReadEntryView<K, V>> entries() {
        log.tracef("Invoked entries(%s)", (Object)this.params);
        Iterator it = this.fmap.cache.cacheEntrySet().iterator();
        Stream<CacheEntry> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1024), false);
        return Traversables.of(stream.map(EntryViews::readOnly));
    }

    @Override
    public FunctionalMap.ReadOnlyMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return ReadOnlyMapImpl.create(this.params.addAll(ps), this.fmap);
    }
}

